/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.platform.nft;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.impl.PartialMerkleLeaf;
import com.swirlds.demo.platform.nft.NftId;
import java.io.IOException;
import java.util.Objects;
import org.hiero.base.io.exceptions.InvalidVersionException;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class MerkleNftId
extends PartialMerkleLeaf
implements MerkleLeaf {
    public static final long CLASS_ID = -5812583014956764589L;
    private static final int VERSION_ORIGINAL = 1;
    private long shardNum;
    private long realmNum;
    private long tokenNum;

    public MerkleNftId() {
    }

    public MerkleNftId(NftId nftId) {
        this.shardNum = nftId.getShardNum();
        this.realmNum = nftId.getRealmNum();
        this.tokenNum = nftId.getTokenNum();
    }

    public MerkleNftId(long shardNum, long realmNum, long tokenNum) {
        this.shardNum = shardNum;
        this.realmNum = realmNum;
        this.tokenNum = tokenNum;
    }

    private MerkleNftId(MerkleNftId nftId) {
        super((PartialMerkleLeaf)nftId);
        this.setNftId(nftId.getNftId());
        nftId.setImmutable(true);
    }

    public long getClassId() {
        return -5812583014956764589L;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeLong(this.shardNum);
        out.writeLong(this.realmNum);
        out.writeLong(this.tokenNum);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        if (version != 1) {
            throw new InvalidVersionException(1, version);
        }
        NftId nftId = (NftId)in.readSerializable(false, NftId::new);
        this.setNftId(nftId);
    }

    public int getVersion() {
        return 1;
    }

    public MerkleNftId copy() {
        return new MerkleNftId(this);
    }

    public MerkleNftId deepCopy() {
        return new MerkleNftId(this.shardNum, this.realmNum, this.tokenNum);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        MerkleNftId that = (MerkleNftId)((Object)other);
        return this.shardNum == that.shardNum && this.realmNum == that.realmNum && this.tokenNum == that.tokenNum;
    }

    public NftId getNftId() {
        return new NftId(this.shardNum, this.realmNum, this.tokenNum);
    }

    public void setNftId(NftId nftId) {
        this.shardNum = nftId.getShardNum();
        this.realmNum = nftId.getRealmNum();
        this.tokenNum = nftId.getTokenNum();
    }

    public int hashCode() {
        return Objects.hash(this.shardNum, this.realmNum, this.tokenNum);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("ShardNum", (Object)this.shardNum).append("RealmNum", (Object)this.realmNum).append("TokenNum", (Object)this.tokenNum).toString();
    }
}

