/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.consensus;

import com.hedera.hapi.node.base.Transaction;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.hapi.node.transaction.Response;
import com.hedera.hapi.node.transaction.TransactionResponse;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.grpc.GrpcCall;
import com.hedera.pbj.runtime.grpc.GrpcClient;
import com.hedera.pbj.runtime.grpc.Pipeline;
import com.hedera.pbj.runtime.grpc.Pipelines;
import com.hedera.pbj.runtime.grpc.ServiceInterface;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReference;

public interface ConsensusServiceInterface
extends ServiceInterface {
    public static final String SERVICE_NAME = "ConsensusService";
    public static final String FULL_NAME = "proto.ConsensusService";

    @NonNull
    public TransactionResponse createTopic(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse updateTopic(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse deleteTopic(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse submitMessage(@NonNull Transaction var1);

    @NonNull
    public Response getTopicInfo(@NonNull Query var1);

    @NonNull
    default public String serviceName() {
        return SERVICE_NAME;
    }

    @NonNull
    default public String fullName() {
        return FULL_NAME;
    }

    @NonNull
    default public List<ServiceInterface.Method> methods() {
        return Arrays.asList(ConsensusServiceMethod.values());
    }

    @NonNull
    default public Pipeline<? super Bytes> open(@NonNull ServiceInterface.Method method, @NonNull ServiceInterface.RequestOptions options, @NonNull Pipeline<? super Bytes> replies) {
        ConsensusServiceMethod m = (ConsensusServiceMethod)method;
        try {
            return switch (m.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Pipelines.unary().mapRequest(bytes -> ConsensusServiceInterface.parseTransaction(bytes, options)).method(this::createTopic).mapResponse(reply -> ConsensusServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 1 -> Pipelines.unary().mapRequest(bytes -> ConsensusServiceInterface.parseTransaction(bytes, options)).method(this::updateTopic).mapResponse(reply -> ConsensusServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 2 -> Pipelines.unary().mapRequest(bytes -> ConsensusServiceInterface.parseTransaction(bytes, options)).method(this::deleteTopic).mapResponse(reply -> ConsensusServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 3 -> Pipelines.unary().mapRequest(bytes -> ConsensusServiceInterface.parseTransaction(bytes, options)).method(this::submitMessage).mapResponse(reply -> ConsensusServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 4 -> Pipelines.unary().mapRequest(bytes -> ConsensusServiceInterface.parseQuery(bytes, options)).method(this::getTopicInfo).mapResponse(reply -> ConsensusServiceInterface.serializeResponse(reply, options)).respondTo(replies).build();
            };
        }
        catch (Exception e) {
            replies.onError((Throwable)e);
            return Pipelines.noop();
        }
    }

    @NonNull
    private static Codec<Transaction> getTransactionCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return Transaction.JSON;
        }
        return Transaction.PROTOBUF;
    }

    @NonNull
    private static Codec<TransactionResponse> getTransactionResponseCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return TransactionResponse.JSON;
        }
        return TransactionResponse.PROTOBUF;
    }

    @NonNull
    private static Codec<Query> getQueryCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return Query.JSON;
        }
        return Query.PROTOBUF;
    }

    @NonNull
    private static Codec<Response> getResponseCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return Response.JSON;
        }
        return Response.PROTOBUF;
    }

    @NonNull
    private static Transaction parseTransaction(@NonNull Bytes message, @NonNull ServiceInterface.RequestOptions options) throws ParseException {
        Objects.requireNonNull(message);
        Objects.requireNonNull(options);
        return (Transaction)ConsensusServiceInterface.getTransactionCodec(options).parse(message.toReadableSequentialData(), false, 16);
    }

    @NonNull
    private static Query parseQuery(@NonNull Bytes message, @NonNull ServiceInterface.RequestOptions options) throws ParseException {
        Objects.requireNonNull(message);
        Objects.requireNonNull(options);
        return (Query)ConsensusServiceInterface.getQueryCodec(options).parse(message.toReadableSequentialData(), false, 16);
    }

    @NonNull
    private static Bytes serializeTransactionResponse(@NonNull TransactionResponse reply, @NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(reply);
        Objects.requireNonNull(options);
        return ConsensusServiceInterface.getTransactionResponseCodec(options).toBytes((Object)reply);
    }

    @NonNull
    private static Bytes serializeResponse(@NonNull Response reply, @NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(reply);
        Objects.requireNonNull(options);
        return ConsensusServiceInterface.getResponseCodec(options).toBytes((Object)reply);
    }

    public static enum ConsensusServiceMethod implements ServiceInterface.Method
    {
        createTopic,
        updateTopic,
        deleteTopic,
        submitMessage,
        getTopicInfo;

    }

    public static class ConsensusServiceClient
    implements ConsensusServiceInterface {
        private final GrpcClient grpcClient;
        private final ServiceInterface.RequestOptions requestOptions;

        public ConsensusServiceClient(@NonNull GrpcClient grpcClient, @NonNull ServiceInterface.RequestOptions requestOptions) {
            this.grpcClient = Objects.requireNonNull(grpcClient);
            this.requestOptions = Objects.requireNonNull(requestOptions);
        }

        public void close() {
            this.grpcClient.close();
        }

        @Override
        @NonNull
        public TransactionResponse createTopic(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("createTopic is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.ConsensusService/createTopic", ConsensusServiceInterface.getTransactionCodec(this.requestOptions), ConsensusServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to createTopic completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse updateTopic(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("updateTopic is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.ConsensusService/updateTopic", ConsensusServiceInterface.getTransactionCodec(this.requestOptions), ConsensusServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to updateTopic completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse deleteTopic(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("deleteTopic is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.ConsensusService/deleteTopic", ConsensusServiceInterface.getTransactionCodec(this.requestOptions), ConsensusServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to deleteTopic completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse submitMessage(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("submitMessage is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.ConsensusService/submitMessage", ConsensusServiceInterface.getTransactionCodec(this.requestOptions), ConsensusServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to submitMessage completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public Response getTopicInfo(@NonNull Query request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<Response> pipeline = new Pipeline<Response>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(Response reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("getTopicInfo is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.ConsensusService/getTopicInfo", ConsensusServiceInterface.getQueryCodec(this.requestOptions), ConsensusServiceInterface.getResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (Response)replyRef.get();
            }
            throw new RuntimeException("Call to getTopicInfo completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }
    }
}

