/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.virtualmerkle.config;

import com.swirlds.demo.platform.PAYLOAD_TYPE;
import com.swirlds.demo.virtualmerkle.config.TransactionRequestConfig;
import com.swirlds.demo.virtualmerkle.random.PTTRandom;
import java.util.List;
import java.util.function.Supplier;

public final class AssortedTransactionRequestSupplier
implements Supplier<TransactionRequestConfig> {
    private final List<TransactionRequestConfig> requestConfigs;
    private final PTTRandom random;
    private TransactionRequestConfig expectedMapTransactionRequest;

    public AssortedTransactionRequestSupplier(List<TransactionRequestConfig> requestConfigs) {
        this.requestConfigs = requestConfigs;
        this.random = new PTTRandom();
    }

    @Override
    public TransactionRequestConfig get() {
        if (this.requestConfigs.isEmpty()) {
            TransactionRequestConfig t = this.expectedMapTransactionRequest;
            this.expectedMapTransactionRequest = null;
            return t;
        }
        int randomIndex = this.random.nextInt(this.requestConfigs.size());
        TransactionRequestConfig transactionRequestConfig = this.requestConfigs.get(randomIndex);
        if (transactionRequestConfig.decrementAndGetAmount() == 0L) {
            this.requestConfigs.remove(transactionRequestConfig);
        }
        if (transactionRequestConfig.getType() == PAYLOAD_TYPE.SAVE_EXPECTED_MAP) {
            this.expectedMapTransactionRequest = transactionRequestConfig;
            return this.get();
        }
        return transactionRequestConfig;
    }
}

