/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable.primitive;

import aQute.bnd.annotation.spi.ServiceProvider;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.factory.list.primitive.ImmutableCharListFactory;
import org.eclipse.collections.api.list.primitive.ImmutableCharList;
import org.eclipse.collections.impl.factory.primitive.CharLists;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableCharArrayList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableCharEmptyList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableCharSingletonList;

@ServiceProvider(value=ImmutableCharListFactory.class)
public class ImmutableCharListFactoryImpl
implements ImmutableCharListFactory {
    public static final ImmutableCharListFactory INSTANCE = new ImmutableCharListFactoryImpl();

    public ImmutableCharList empty() {
        return ImmutableCharEmptyList.INSTANCE;
    }

    public ImmutableCharList of() {
        return this.empty();
    }

    public ImmutableCharList with() {
        return this.empty();
    }

    public ImmutableCharList of(char one) {
        return this.with(one);
    }

    public ImmutableCharList with(char one) {
        return new ImmutableCharSingletonList(one);
    }

    public ImmutableCharList of(char ... items) {
        return this.with(items);
    }

    public ImmutableCharList with(char ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableCharArrayList.newListWith(items);
    }

    public ImmutableCharList ofAll(CharIterable items) {
        return this.withAll(items);
    }

    public ImmutableCharList withAll(CharIterable items) {
        if (items instanceof ImmutableCharList) {
            return (ImmutableCharList)items;
        }
        if (items == null || items.size() == 0) {
            return this.with();
        }
        if (items.size() == 1) {
            return this.with(items.toArray()[0]);
        }
        return ImmutableCharArrayList.newList(items);
    }

    public ImmutableCharList ofAll(Iterable<Character> iterable) {
        return this.withAll(iterable);
    }

    public ImmutableCharList withAll(Iterable<Character> iterable) {
        return CharLists.mutable.withAll(iterable).toImmutable();
    }
}

