/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.addressbook;

import com.hedera.hapi.node.addressbook.codec.NodeUpdateTransactionBodyJsonCodec;
import com.hedera.hapi.node.addressbook.codec.NodeUpdateTransactionBodyProtoCodec;
import com.hedera.hapi.node.addressbook.schema.NodeUpdateTransactionBodySchema;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ServiceEndpoint;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class NodeUpdateTransactionBody {
    public static final Codec<NodeUpdateTransactionBody> PROTOBUF = new NodeUpdateTransactionBodyProtoCodec();
    public static final JsonCodec<NodeUpdateTransactionBody> JSON = new NodeUpdateTransactionBodyJsonCodec();
    public static final NodeUpdateTransactionBody DEFAULT = NodeUpdateTransactionBody.newBuilder().build();
    private final long nodeId;
    @Nullable
    private final AccountID accountId;
    @Nullable
    private final String description;
    @NonNull
    private final List<ServiceEndpoint> gossipEndpoint;
    @NonNull
    private final List<ServiceEndpoint> serviceEndpoint;
    @Nullable
    private final Bytes gossipCaCertificate;
    @Nullable
    private final Bytes grpcCertificateHash;
    @Nullable
    private final Key adminKey;
    @Nullable
    private final Boolean declineReward;
    @Nullable
    private final ServiceEndpoint grpcProxyEndpoint;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public NodeUpdateTransactionBody(long nodeId, AccountID accountId, String description, List<ServiceEndpoint> gossipEndpoint, List<ServiceEndpoint> serviceEndpoint, Bytes gossipCaCertificate, Bytes grpcCertificateHash, Key adminKey, Boolean declineReward, ServiceEndpoint grpcProxyEndpoint) {
        this.$unknownFields = null;
        this.nodeId = nodeId;
        this.accountId = accountId;
        this.description = description;
        this.gossipEndpoint = gossipEndpoint == null ? Collections.emptyList() : gossipEndpoint;
        this.serviceEndpoint = serviceEndpoint == null ? Collections.emptyList() : serviceEndpoint;
        this.gossipCaCertificate = gossipCaCertificate;
        this.grpcCertificateHash = grpcCertificateHash;
        this.adminKey = adminKey;
        this.declineReward = declineReward;
        this.grpcProxyEndpoint = grpcProxyEndpoint;
    }

    public NodeUpdateTransactionBody(long nodeId, AccountID accountId, String description, List<ServiceEndpoint> gossipEndpoint, List<ServiceEndpoint> serviceEndpoint, Bytes gossipCaCertificate, Bytes grpcCertificateHash, Key adminKey, Boolean declineReward, ServiceEndpoint grpcProxyEndpoint, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.nodeId = nodeId;
        this.accountId = accountId;
        this.description = description;
        this.gossipEndpoint = gossipEndpoint == null ? Collections.emptyList() : gossipEndpoint;
        this.serviceEndpoint = serviceEndpoint == null ? Collections.emptyList() : serviceEndpoint;
        this.gossipCaCertificate = gossipCaCertificate;
        this.grpcCertificateHash = grpcCertificateHash;
        this.adminKey = adminKey;
        this.declineReward = declineReward;
        this.grpcProxyEndpoint = grpcProxyEndpoint;
    }

    public long nodeId() {
        return this.nodeId;
    }

    public AccountID accountId() {
        return this.accountId;
    }

    public String description() {
        return this.description;
    }

    public List<ServiceEndpoint> gossipEndpoint() {
        return this.gossipEndpoint;
    }

    public List<ServiceEndpoint> serviceEndpoint() {
        return this.serviceEndpoint;
    }

    public Bytes gossipCaCertificate() {
        return this.gossipCaCertificate;
    }

    public Bytes grpcCertificateHash() {
        return this.grpcCertificateHash;
    }

    public Key adminKey() {
        return this.adminKey;
    }

    public Boolean declineReward() {
        return this.declineReward;
    }

    public ServiceEndpoint grpcProxyEndpoint() {
        return this.grpcProxyEndpoint;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeUpdateTransactionBodySchema.NODE_ID, (long)this.nodeId, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NodeUpdateTransactionBodySchema.ACCOUNT_ID, (Object)this.accountId, AccountID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfOptionalString((FieldDefinition)NodeUpdateTransactionBodySchema.DESCRIPTION, (String)this.description);
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)NodeUpdateTransactionBodySchema.GOSSIP_ENDPOINT, this.gossipEndpoint, ServiceEndpoint.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)NodeUpdateTransactionBodySchema.SERVICE_ENDPOINT, this.serviceEndpoint, ServiceEndpoint.PROTOBUF);
            _size += ProtoWriterTools.sizeOfOptionalBytes((FieldDefinition)NodeUpdateTransactionBodySchema.GOSSIP_CA_CERTIFICATE, (RandomAccessData)this.gossipCaCertificate);
            _size += ProtoWriterTools.sizeOfOptionalBytes((FieldDefinition)NodeUpdateTransactionBodySchema.GRPC_CERTIFICATE_HASH, (RandomAccessData)this.grpcCertificateHash);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NodeUpdateTransactionBodySchema.ADMIN_KEY, (Object)this.adminKey, Key.PROTOBUF);
            _size += ProtoWriterTools.sizeOfOptionalBoolean((FieldDefinition)NodeUpdateTransactionBodySchema.DECLINE_REWARD, (Boolean)this.declineReward);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NodeUpdateTransactionBodySchema.GRPC_PROXY_ENDPOINT, (Object)this.grpcProxyEndpoint, ServiceEndpoint.PROTOBUF);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        if (this.$hashCode == -1) {
            List<ServiceEndpoint> list$serviceEndpoint;
            List<ServiceEndpoint> list$gossipEndpoint;
            int result = 1;
            if (this.nodeId != NodeUpdateTransactionBody.DEFAULT.nodeId) {
                result = 31 * result + Long.hashCode(this.nodeId);
            }
            if (this.accountId != null && !this.accountId.equals(NodeUpdateTransactionBody.DEFAULT.accountId)) {
                result = 31 * result + this.accountId.hashCode();
            }
            if (this.description != null && !this.description.equals(NodeUpdateTransactionBody.DEFAULT.description)) {
                result = 31 * result + this.description.hashCode();
            }
            if ((list$gossipEndpoint = this.gossipEndpoint) != null) {
                for (ServiceEndpoint serviceEndpoint : list$gossipEndpoint) {
                    if (serviceEndpoint != null) {
                        result = 31 * result + ((Object)serviceEndpoint).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if ((list$serviceEndpoint = this.serviceEndpoint) != null) {
                for (ServiceEndpoint serviceEndpoint : list$serviceEndpoint) {
                    if (serviceEndpoint != null) {
                        result = 31 * result + ((Object)serviceEndpoint).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if (this.gossipCaCertificate != null && !this.gossipCaCertificate.equals((Object)NodeUpdateTransactionBody.DEFAULT.gossipCaCertificate)) {
                result = 31 * result + (this.gossipCaCertificate == null ? 0 : this.gossipCaCertificate.hashCode());
            }
            if (this.grpcCertificateHash != null && !this.grpcCertificateHash.equals((Object)NodeUpdateTransactionBody.DEFAULT.grpcCertificateHash)) {
                result = 31 * result + (this.grpcCertificateHash == null ? 0 : this.grpcCertificateHash.hashCode());
            }
            if (this.adminKey != null && !this.adminKey.equals(NodeUpdateTransactionBody.DEFAULT.adminKey)) {
                result = 31 * result + this.adminKey.hashCode();
            }
            if (this.declineReward != null && !this.declineReward.equals(NodeUpdateTransactionBody.DEFAULT.declineReward)) {
                result = 31 * result + Boolean.hashCode(this.declineReward);
            }
            if (this.grpcProxyEndpoint != null && !this.grpcProxyEndpoint.equals(NodeUpdateTransactionBody.DEFAULT.grpcProxyEndpoint)) {
                result = 31 * result + this.grpcProxyEndpoint.hashCode();
            }
            if (this.$unknownFields != null) {
                void var4_8;
                boolean bl = false;
                while (var4_8 < this.$unknownFields.size()) {
                    result = 31 * result + this.$unknownFields.get((int)var4_8).hashCode();
                    ++var4_8;
                }
            }
            long l = result;
            l += l << 30;
            l ^= l >>> 27;
            l += l << 16;
            l ^= l >>> 20;
            l += l << 5;
            l ^= l >>> 18;
            l += l << 10;
            l ^= l >>> 24;
            l += l << 30;
            this.$hashCode = (int)l;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        NodeUpdateTransactionBody thatObj = (NodeUpdateTransactionBody)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.nodeId != thatObj.nodeId) {
            return false;
        }
        if (this.accountId == null && thatObj.accountId != null) {
            return false;
        }
        if (this.accountId != null && !this.accountId.equals(thatObj.accountId)) {
            return false;
        }
        if (this.description == null && thatObj.description != null) {
            return false;
        }
        if (this.description != null && !this.description.equals(thatObj.description)) {
            return false;
        }
        if (this.gossipEndpoint == null && thatObj.gossipEndpoint != null) {
            return false;
        }
        if (this.gossipEndpoint != null && !this.gossipEndpoint.equals(thatObj.gossipEndpoint)) {
            return false;
        }
        if (this.serviceEndpoint == null && thatObj.serviceEndpoint != null) {
            return false;
        }
        if (this.serviceEndpoint != null && !this.serviceEndpoint.equals(thatObj.serviceEndpoint)) {
            return false;
        }
        if (this.gossipCaCertificate == null && thatObj.gossipCaCertificate != null) {
            return false;
        }
        if (this.gossipCaCertificate != null && !this.gossipCaCertificate.equals((Object)thatObj.gossipCaCertificate)) {
            return false;
        }
        if (this.grpcCertificateHash == null && thatObj.grpcCertificateHash != null) {
            return false;
        }
        if (this.grpcCertificateHash != null && !this.grpcCertificateHash.equals((Object)thatObj.grpcCertificateHash)) {
            return false;
        }
        if (this.adminKey == null && thatObj.adminKey != null) {
            return false;
        }
        if (this.adminKey != null && !this.adminKey.equals(thatObj.adminKey)) {
            return false;
        }
        if (this.declineReward == null && thatObj.declineReward != null) {
            return false;
        }
        if (this.declineReward != null && !this.declineReward.equals(thatObj.declineReward)) {
            return false;
        }
        if (this.grpcProxyEndpoint == null && thatObj.grpcProxyEndpoint != null) {
            return false;
        }
        if (this.grpcProxyEndpoint != null && !this.grpcProxyEndpoint.equals(thatObj.grpcProxyEndpoint)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "NodeUpdateTransactionBody[nodeId=" + this.nodeId + ", accountId=" + String.valueOf(this.accountId) + ", description=" + this.description + ", gossipEndpoint=" + String.valueOf(this.gossipEndpoint) + ", serviceEndpoint=" + String.valueOf(this.serviceEndpoint) + ", gossipCaCertificate=" + String.valueOf(this.gossipCaCertificate) + ", grpcCertificateHash=" + String.valueOf(this.grpcCertificateHash) + ", adminKey=" + String.valueOf(this.adminKey) + ", declineReward=" + this.declineReward + ", grpcProxyEndpoint=" + String.valueOf(this.grpcProxyEndpoint) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasAccountId() {
        return this.accountId != null;
    }

    public AccountID accountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasAccountId() ? this.accountId : defaultValue;
    }

    @NonNull
    public AccountID accountIdOrThrow() {
        return Objects.requireNonNull(this.accountId, "Field accountId is null");
    }

    public void ifAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAccountId()) {
            ifPresent.accept(this.accountId);
        }
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public String descriptionOrElse(@NonNull String defaultValue) {
        return this.hasDescription() ? this.description : defaultValue;
    }

    @NonNull
    public String descriptionOrThrow() {
        return Objects.requireNonNull(this.description, "Field description is null");
    }

    public void ifDescription(@NonNull Consumer<String> ifPresent) {
        if (this.hasDescription()) {
            ifPresent.accept(this.description);
        }
    }

    public boolean hasGossipCaCertificate() {
        return this.gossipCaCertificate != null;
    }

    public Bytes gossipCaCertificateOrElse(@NonNull Bytes defaultValue) {
        return this.hasGossipCaCertificate() ? this.gossipCaCertificate : defaultValue;
    }

    @NonNull
    public Bytes gossipCaCertificateOrThrow() {
        return Objects.requireNonNull(this.gossipCaCertificate, "Field gossipCaCertificate is null");
    }

    public void ifGossipCaCertificate(@NonNull Consumer<Bytes> ifPresent) {
        if (this.hasGossipCaCertificate()) {
            ifPresent.accept(this.gossipCaCertificate);
        }
    }

    public boolean hasGrpcCertificateHash() {
        return this.grpcCertificateHash != null;
    }

    public Bytes grpcCertificateHashOrElse(@NonNull Bytes defaultValue) {
        return this.hasGrpcCertificateHash() ? this.grpcCertificateHash : defaultValue;
    }

    @NonNull
    public Bytes grpcCertificateHashOrThrow() {
        return Objects.requireNonNull(this.grpcCertificateHash, "Field grpcCertificateHash is null");
    }

    public void ifGrpcCertificateHash(@NonNull Consumer<Bytes> ifPresent) {
        if (this.hasGrpcCertificateHash()) {
            ifPresent.accept(this.grpcCertificateHash);
        }
    }

    public boolean hasAdminKey() {
        return this.adminKey != null;
    }

    public Key adminKeyOrElse(@NonNull Key defaultValue) {
        return this.hasAdminKey() ? this.adminKey : defaultValue;
    }

    @NonNull
    public Key adminKeyOrThrow() {
        return Objects.requireNonNull(this.adminKey, "Field adminKey is null");
    }

    public void ifAdminKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasAdminKey()) {
            ifPresent.accept(this.adminKey);
        }
    }

    public boolean hasDeclineReward() {
        return this.declineReward != null;
    }

    public Boolean declineRewardOrElse(@NonNull Boolean defaultValue) {
        return this.hasDeclineReward() ? this.declineReward : defaultValue;
    }

    @NonNull
    public Boolean declineRewardOrThrow() {
        return Objects.requireNonNull(this.declineReward, "Field declineReward is null");
    }

    public void ifDeclineReward(@NonNull Consumer<Boolean> ifPresent) {
        if (this.hasDeclineReward()) {
            ifPresent.accept(this.declineReward);
        }
    }

    public boolean hasGrpcProxyEndpoint() {
        return this.grpcProxyEndpoint != null;
    }

    public ServiceEndpoint grpcProxyEndpointOrElse(@NonNull ServiceEndpoint defaultValue) {
        return this.hasGrpcProxyEndpoint() ? this.grpcProxyEndpoint : defaultValue;
    }

    @NonNull
    public ServiceEndpoint grpcProxyEndpointOrThrow() {
        return Objects.requireNonNull(this.grpcProxyEndpoint, "Field grpcProxyEndpoint is null");
    }

    public void ifGrpcProxyEndpoint(@NonNull Consumer<ServiceEndpoint> ifPresent) {
        if (this.hasGrpcProxyEndpoint()) {
            ifPresent.accept(this.grpcProxyEndpoint);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.nodeId, this.accountId, this.description, this.gossipEndpoint, this.serviceEndpoint, this.gossipCaCertificate, this.grpcCertificateHash, this.adminKey, this.declineReward, this.grpcProxyEndpoint, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private long nodeId = 0L;
        @Nullable
        private AccountID accountId = null;
        @Nullable
        private String description = null;
        @NonNull
        private List<ServiceEndpoint> gossipEndpoint = Collections.emptyList();
        @NonNull
        private List<ServiceEndpoint> serviceEndpoint = Collections.emptyList();
        @Nullable
        private Bytes gossipCaCertificate = null;
        @Nullable
        private Bytes grpcCertificateHash = null;
        @Nullable
        private Key adminKey = null;
        @Nullable
        private Boolean declineReward = null;
        @Nullable
        private ServiceEndpoint grpcProxyEndpoint = null;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(long nodeId, AccountID accountId, String description, List<ServiceEndpoint> gossipEndpoint, List<ServiceEndpoint> serviceEndpoint, Bytes gossipCaCertificate, Bytes grpcCertificateHash, Key adminKey, Boolean declineReward, ServiceEndpoint grpcProxyEndpoint) {
            this.$unknownFields = null;
            this.nodeId = nodeId;
            this.accountId = accountId;
            this.description = description;
            this.gossipEndpoint = gossipEndpoint == null ? Collections.emptyList() : gossipEndpoint;
            this.serviceEndpoint = serviceEndpoint == null ? Collections.emptyList() : serviceEndpoint;
            this.gossipCaCertificate = gossipCaCertificate;
            this.grpcCertificateHash = grpcCertificateHash;
            this.adminKey = adminKey;
            this.declineReward = declineReward;
            this.grpcProxyEndpoint = grpcProxyEndpoint;
        }

        public Builder(long nodeId, AccountID accountId, String description, List<ServiceEndpoint> gossipEndpoint, List<ServiceEndpoint> serviceEndpoint, Bytes gossipCaCertificate, Bytes grpcCertificateHash, Key adminKey, Boolean declineReward, ServiceEndpoint grpcProxyEndpoint, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.nodeId = nodeId;
            this.accountId = accountId;
            this.description = description;
            this.gossipEndpoint = gossipEndpoint == null ? Collections.emptyList() : gossipEndpoint;
            this.serviceEndpoint = serviceEndpoint == null ? Collections.emptyList() : serviceEndpoint;
            this.gossipCaCertificate = gossipCaCertificate;
            this.grpcCertificateHash = grpcCertificateHash;
            this.adminKey = adminKey;
            this.declineReward = declineReward;
            this.grpcProxyEndpoint = grpcProxyEndpoint;
        }

        public NodeUpdateTransactionBody build() {
            return new NodeUpdateTransactionBody(this.nodeId, this.accountId, this.description, this.gossipEndpoint, this.serviceEndpoint, this.gossipCaCertificate, this.grpcCertificateHash, this.adminKey, this.declineReward, this.grpcProxyEndpoint);
        }

        public Builder nodeId(long nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder accountId(@Nullable AccountID accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder accountId(AccountID.Builder builder) {
            this.accountId = builder.build();
            return this;
        }

        public Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public Builder gossipEndpoint(@NonNull List<ServiceEndpoint> gossipEndpoint) {
            this.gossipEndpoint = gossipEndpoint != null ? gossipEndpoint : Collections.emptyList();
            return this;
        }

        public Builder gossipEndpoint(ServiceEndpoint ... values) {
            this.gossipEndpoint = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public Builder serviceEndpoint(@NonNull List<ServiceEndpoint> serviceEndpoint) {
            this.serviceEndpoint = serviceEndpoint != null ? serviceEndpoint : Collections.emptyList();
            return this;
        }

        public Builder serviceEndpoint(ServiceEndpoint ... values) {
            this.serviceEndpoint = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public Builder gossipCaCertificate(@Nullable Bytes gossipCaCertificate) {
            this.gossipCaCertificate = gossipCaCertificate;
            return this;
        }

        public Builder grpcCertificateHash(@Nullable Bytes grpcCertificateHash) {
            this.grpcCertificateHash = grpcCertificateHash;
            return this;
        }

        public Builder adminKey(@Nullable Key adminKey) {
            this.adminKey = adminKey;
            return this;
        }

        public Builder adminKey(Key.Builder builder) {
            this.adminKey = builder.build();
            return this;
        }

        public Builder declineReward(@Nullable Boolean declineReward) {
            this.declineReward = declineReward;
            return this;
        }

        public Builder grpcProxyEndpoint(@Nullable ServiceEndpoint grpcProxyEndpoint) {
            this.grpcProxyEndpoint = grpcProxyEndpoint;
            return this;
        }

        public Builder grpcProxyEndpoint(ServiceEndpoint.Builder builder) {
            this.grpcProxyEndpoint = builder.build();
            return this;
        }
    }
}

