/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.iss;

import com.swirlds.config.api.ConfigData;
import com.swirlds.demo.iss.PlannedIss;
import com.swirlds.demo.iss.PlannedLogError;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.LinkedList;
import java.util.List;

@ConfigData(value="issTestingTool")
public record ISSTestingToolConfig(int transactionsPerSecond, List<String> plannedISSs, List<String> plannedLogErrors) {
    @NonNull
    public List<PlannedIss> getPlannedISSs() {
        LinkedList<PlannedIss> parsedISSs = new LinkedList<PlannedIss>();
        for (String plannedISSString : this.plannedISSs()) {
            parsedISSs.add(PlannedIss.fromString(plannedISSString));
        }
        return parsedISSs;
    }

    @NonNull
    public List<PlannedLogError> getPlannedLogErrors() {
        LinkedList<PlannedLogError> parsedPlannedLogErrors = new LinkedList<PlannedLogError>();
        for (String plannedLogErrorString : this.plannedLogErrors()) {
            parsedPlannedLogErrors.add(PlannedLogError.fromString(plannedLogErrorString));
        }
        return parsedPlannedLogErrors;
    }
}

