/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.cli;

import com.swirlds.cli.PlatformCli;
import com.swirlds.cli.utility.AbstractCommand;
import com.swirlds.cli.utility.SubcommandOf;
import com.swirlds.platform.Browser;
import com.swirlds.platform.CommandLineArgs;
import com.swirlds.platform.cli.CleanCommand;
import com.swirlds.platform.system.SystemExitCode;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hiero.consensus.model.node.NodeId;
import picocli.CommandLine;

@CommandLine.Command(name="browse", mixinStandardHelpOptions=true, description={"Launch local instances of the platform using the Browser UI. Note: the Browser UI expects a very specific file system layout. Such a layout is present in the  hedera-services/platform-sdk/sdk/ directory."})
@SubcommandOf(value=PlatformCli.class)
public class BrowseCommand
extends AbstractCommand {
    private List<NodeId> localNodes = new ArrayList<NodeId>();
    private boolean clean = false;

    @CommandLine.Option(names={"-l", "--local-node"}, description={"Specify a node that should be run in this JVM. If no nodes are provided, all nodes with local IP addresses are loaded in this JVM. Multiple nodes can be specified by repeating the parameter `-l #1 -l #2 -l #3`."})
    private void setLocalNodes(Long ... localNodes) {
        for (Long nodeId : localNodes) {
            this.localNodes.add(NodeId.of((long)nodeId));
        }
    }

    @CommandLine.Option(names={"-c", "--clean"}, description={"Perform a clean operation before starting."})
    private void clean(boolean clean) {
        this.clean = clean;
    }

    public Integer call() throws IOException, InterruptedException {
        Path sdkPath = Path.of(System.getProperty("user.dir"), new String[0]);
        if (this.clean) {
            CleanCommand.clean(sdkPath);
        }
        try {
            Browser.launch(new CommandLineArgs(new HashSet<NodeId>(this.localNodes)), false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return SystemExitCode.FATAL_ERROR.getExitCode();
        }
        while (true) {
            TimeUnit.MINUTES.sleep(1L);
        }
    }
}

