/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.config.impl.internal;

import com.swirlds.config.api.source.ConfigSource;
import com.swirlds.config.impl.internal.ConfigLifecycle;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;

class ConfigSourceService
implements ConfigLifecycle {
    private final List<ConfigSource> sources = new CopyOnWriteArrayList<ConfigSource>();
    private boolean initialized = false;

    ConfigSourceService() {
    }

    void addConfigSource(@NonNull ConfigSource configSource) {
        this.throwIfInitialized();
        Objects.requireNonNull(configSource, "configSource must not be null");
        this.sources.add(configSource);
    }

    @NonNull
    Stream<ConfigSource> getSources() {
        this.throwIfNotInitialized();
        return this.sources.stream();
    }

    @Override
    public void init() {
        this.throwIfInitialized();
        this.sources.sort(Comparator.comparingInt(ConfigSource::getOrdinal));
        this.initialized = true;
    }

    @Override
    public void dispose() {
        this.sources.clear();
        this.initialized = false;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }
}

