/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.sun.net.httpserver.HttpServer;
import com.swirlds.base.state.Lifecycle;
import com.swirlds.base.state.LifecyclePhase;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.common.metrics.PlatformMetricsFactory;
import com.swirlds.common.metrics.PlatformMetricsProvider;
import com.swirlds.common.metrics.config.MetricsConfig;
import com.swirlds.common.metrics.platform.DefaultPlatformMetrics;
import com.swirlds.common.metrics.platform.LegacyCsvWriter;
import com.swirlds.common.metrics.platform.MetricKeyRegistry;
import com.swirlds.common.metrics.platform.PlatformMetricsFactoryImpl;
import com.swirlds.common.metrics.platform.SnapshotService;
import com.swirlds.common.metrics.platform.prometheus.PrometheusConfig;
import com.swirlds.common.metrics.platform.prometheus.PrometheusEndpoint;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.node.NodeId;

public class DefaultMetricsProvider
implements PlatformMetricsProvider,
Lifecycle {
    private static final Logger logger = LogManager.getLogger(DefaultMetricsProvider.class);
    @NonNull
    private final PlatformMetricsFactory factory;
    @NonNull
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(AdHocThreadManager.getStaticThreadManager().createThreadFactory("platform-core", "MetricsThread"));
    @NonNull
    private final MetricKeyRegistry metricKeyRegistry = new MetricKeyRegistry();
    @NonNull
    private final DefaultPlatformMetrics globalMetrics;
    @NonNull
    private final ConcurrentMap<NodeId, DefaultPlatformMetrics> platformMetrics = new ConcurrentHashMap<NodeId, DefaultPlatformMetrics>();
    @NonNull
    private final Map<NodeId, List<Runnable>> unsubscribers = new HashMap<NodeId, List<Runnable>>();
    @Nullable
    private final PrometheusEndpoint prometheusEndpoint;
    @NonNull
    private final SnapshotService snapshotService;
    @NonNull
    private final MetricsConfig metricsConfig;
    @NonNull
    private final Configuration configuration;
    @NonNull
    private LifecyclePhase lifecyclePhase = LifecyclePhase.NOT_STARTED;

    public DefaultMetricsProvider(@NonNull Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration, "configuration must not be null");
        this.metricsConfig = (MetricsConfig)configuration.getConfigData(MetricsConfig.class);
        PrometheusConfig prometheusConfig = (PrometheusConfig)configuration.getConfigData(PrometheusConfig.class);
        this.factory = new PlatformMetricsFactoryImpl(this.metricsConfig);
        this.globalMetrics = new DefaultPlatformMetrics(null, this.metricKeyRegistry, this.executor, this.factory, this.metricsConfig);
        this.snapshotService = new SnapshotService(this.globalMetrics, this.executor, this.metricsConfig.getMetricsSnapshotDuration());
        PrometheusEndpoint endpoint = null;
        if (!this.metricsConfig.disableMetricsOutput() && prometheusConfig.endpointEnabled()) {
            InetSocketAddress address = new InetSocketAddress(prometheusConfig.endpointPortNumber());
            try {
                HttpServer httpServer = HttpServer.create(address, prometheusConfig.endpointMaxBacklogAllowed());
                endpoint = new PrometheusEndpoint(httpServer);
                this.globalMetrics.subscribe(endpoint::handleMetricsChange);
                this.snapshotService.subscribe(endpoint::handleSnapshots);
            }
            catch (IOException e) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "Exception while setting up Prometheus endpoint", (Throwable)e);
            }
        }
        this.prometheusEndpoint = endpoint;
    }

    @Override
    @NonNull
    public Metrics createGlobalMetrics() {
        return this.globalMetrics;
    }

    @Override
    @NonNull
    public Metrics createPlatformMetrics(@NonNull NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId must not be null");
        DefaultPlatformMetrics newMetrics = new DefaultPlatformMetrics(nodeId, this.metricKeyRegistry, this.executor, this.factory, this.metricsConfig);
        DefaultPlatformMetrics oldMetrics = this.platformMetrics.putIfAbsent(nodeId, newMetrics);
        if (oldMetrics != null) {
            throw new IllegalStateException(String.format("PlatformMetrics for %s already exists", nodeId));
        }
        Runnable unsubscribeGlobalMetrics = this.globalMetrics.subscribe(newMetrics::handleGlobalMetrics);
        this.unsubscribers.put(nodeId, List.of(unsubscribeGlobalMetrics));
        if (this.lifecyclePhase == LifecyclePhase.STARTED) {
            newMetrics.start();
        }
        this.snapshotService.addPlatformMetric(newMetrics);
        if (!this.metricsConfig.disableMetricsOutput()) {
            String folderName = this.metricsConfig.csvOutputFolder();
            Path folderPath = Path.of(folderName.isBlank() ? FileUtils.getUserDir() : folderName, new String[0]);
            if (!this.metricsConfig.csvFileName().isBlank()) {
                LegacyCsvWriter legacyCsvWriter = new LegacyCsvWriter(nodeId, folderPath, this.configuration);
                Runnable unsubscribeCsvWriter = this.snapshotService.subscribe(legacyCsvWriter::handleSnapshots);
                this.unsubscribers.put(nodeId, List.of(unsubscribeCsvWriter, unsubscribeGlobalMetrics));
            }
            if (this.prometheusEndpoint != null) {
                newMetrics.subscribe(this.prometheusEndpoint::handleMetricsChange);
            }
        }
        return newMetrics;
    }

    @Override
    public void removePlatformMetrics(@NonNull NodeId nodeId) throws InterruptedException {
        Objects.requireNonNull(nodeId, "nodeId must not be null");
        DefaultPlatformMetrics metrics = (DefaultPlatformMetrics)this.platformMetrics.get(nodeId);
        if (metrics == null) {
            throw new IllegalArgumentException(String.format("PlatformMetrics for %s does not exist", nodeId));
        }
        metrics.shutdown();
        this.unsubscribers.remove(nodeId).forEach(Runnable::run);
        this.snapshotService.removePlatformMetric(metrics);
        this.platformMetrics.remove(nodeId);
    }

    @NonNull
    public LifecyclePhase getLifecyclePhase() {
        return this.lifecyclePhase;
    }

    public void start() {
        if (this.lifecyclePhase == LifecyclePhase.NOT_STARTED) {
            this.globalMetrics.start();
            for (DefaultPlatformMetrics metrics : this.platformMetrics.values()) {
                metrics.start();
            }
            this.snapshotService.start();
            this.lifecyclePhase = LifecyclePhase.STARTED;
        }
    }

    public void stop() {
        if (this.lifecyclePhase == LifecyclePhase.STARTED) {
            this.snapshotService.shutdown();
            if (this.prometheusEndpoint != null) {
                this.prometheusEndpoint.close();
            }
            this.lifecyclePhase = LifecyclePhase.STOPPED;
        }
    }
}

