/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.signed;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.utility.ReferenceCounter;
import com.swirlds.common.utility.RuntimeObjectRecord;
import com.swirlds.common.utility.RuntimeObjectRegistry;
import com.swirlds.common.utility.Threshold;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.config.StateConfig;
import com.swirlds.platform.crypto.SignatureVerifier;
import com.swirlds.platform.state.MerkleNodeState;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.state.signed.SigSet;
import com.swirlds.platform.state.signed.SignedStateHistory;
import com.swirlds.platform.state.signed.SignedStateInvalidException;
import com.swirlds.platform.state.snapshot.StateToDiskReason;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Signature;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.roster.Address;
import org.hiero.consensus.roster.RosterRetriever;
import org.hiero.consensus.roster.RosterUtils;

public class SignedState {
    private static final Logger logger = LogManager.getLogger(SignedState.class);
    private SigSet sigSet;
    private long signingWeight;
    private final boolean freezeState;
    private boolean deleted = false;
    private final MerkleNodeState state;
    private final Instant creationTimestamp = Instant.now();
    private StateToDiskReason stateToDiskReason;
    private boolean hasBeenSavedToDisk;
    private boolean recoveryState;
    private final RuntimeObjectRecord registryRecord;
    private final SignedStateHistory history;
    private final ReferenceCounter reservations = new ReferenceCounter(this::markEligibleForDeletion, this::onReferenceCountException);
    private final SignatureVerifier signatureVerifier;
    private final AtomicBoolean eligibleForDeletion = new AtomicBoolean(false);
    private final boolean deleteOnBackgroundThread;
    private final boolean pcesRound;
    private final PlatformStateFacade platformStateFacade;

    public SignedState(@NonNull Configuration configuration, @NonNull SignatureVerifier signatureVerifier, @NonNull MerkleNodeState state, @NonNull String reason, boolean freezeState, boolean deleteOnBackgroundThread, boolean pcesRound, @NonNull PlatformStateFacade platformStateFacade) {
        this.platformStateFacade = platformStateFacade;
        this.signatureVerifier = Objects.requireNonNull(signatureVerifier);
        this.state = Objects.requireNonNull(state);
        state.getRoot().reserve();
        StateConfig stateConfig = (StateConfig)configuration.getConfigData(StateConfig.class);
        if (stateConfig.stateHistoryEnabled()) {
            this.history = new SignedStateHistory(Time.getCurrent(), this.getRound(), stateConfig.debugStackTracesEnabled());
            this.history.recordAction(SignedStateHistory.SignedStateAction.CREATION, this.getReservationCount(), reason, null);
        } else {
            this.history = null;
        }
        this.registryRecord = RuntimeObjectRegistry.createRecord(this.getClass(), (Object)this.history);
        this.sigSet = new SigSet();
        this.freezeState = freezeState;
        this.deleteOnBackgroundThread = deleteOnBackgroundThread;
        this.pcesRound = pcesRound;
    }

    public void init(@NonNull PlatformContext platformContext) {
        this.state.init(platformContext.getTime(), platformContext.getMetrics(), platformContext.getMerkleCryptography(), () -> {
            ConsensusSnapshot consensusSnapshot = this.platformStateFacade.consensusSnapshotOf(this.state);
            return consensusSnapshot == null ? 0L : consensusSnapshot.round();
        });
    }

    public long getRound() {
        return this.platformStateFacade.roundOf(this.state);
    }

    public boolean isGenesisState() {
        return this.platformStateFacade.isGenesisStateOf(this.state);
    }

    @NonNull
    public SigSet getSigSet() {
        return this.sigSet;
    }

    public void setSigSet(@NonNull SigSet sigSet) {
        this.sigSet = Objects.requireNonNull(sigSet);
        this.signingWeight = 0L;
        if (!this.isGenesisState()) {
            Map entries = RosterUtils.toMap((Roster)this.getRoster());
            for (NodeId signingNode : sigSet) {
                RosterEntry entry = (RosterEntry)entries.get(signingNode.id());
                if (entry == null) continue;
                this.signingWeight += entry.weight();
            }
        }
    }

    @NonNull
    public Roster getRoster() {
        Roster roster = RosterRetriever.retrieveActive((State)this.state, (long)this.getRound());
        return Objects.requireNonNull(roster, "Roster stored in signed state is null (this should never happen)");
    }

    @NonNull
    public MerkleNodeState getState() {
        return this.state;
    }

    public boolean isFreezeState() {
        return this.freezeState;
    }

    public boolean isPcesRound() {
        return this.pcesRound;
    }

    public void markAsRecoveryState() {
        this.recoveryState = true;
    }

    @NonNull
    public ReservedSignedState reserve(@NonNull String reason) {
        return ReservedSignedState.createAndReserve(this, reason);
    }

    void incrementReservationCount(@NonNull String reason, long reservationId) {
        if (this.history != null) {
            this.history.recordAction(SignedStateHistory.SignedStateAction.RESERVE, this.getReservationCount(), reason, reservationId);
        }
        this.reservations.reserve();
    }

    boolean tryIncrementReservationCount(@NonNull String reason, long reservationId) {
        if (!this.reservations.tryReserve()) {
            return false;
        }
        if (this.history != null) {
            this.history.recordAction(SignedStateHistory.SignedStateAction.RESERVE, this.getReservationCount(), reason, reservationId);
        }
        return true;
    }

    void decrementReservationCount(@NonNull String reason, long reservationId) {
        if (this.history != null) {
            this.history.recordAction(SignedStateHistory.SignedStateAction.RELEASE, this.getReservationCount(), reason, reservationId);
        }
        this.reservations.release();
    }

    private void markEligibleForDeletion() {
        this.eligibleForDeletion.set(true);
        if (!this.deleteOnBackgroundThread) {
            this.delete();
        }
    }

    boolean shouldDeleteOnBackgroundThread() {
        return this.deleteOnBackgroundThread;
    }

    private void onReferenceCountException() {
        if (this.history != null) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "SignedState reference count error detected, dumping history.\n{}", (Object)this.history);
        }
    }

    boolean isEligibleForDeletion() {
        return this.eligibleForDeletion.get();
    }

    synchronized void delete() {
        if (this.reservations.isDestroyed() && !this.deleted) {
            try {
                this.deleted = true;
                if (this.history != null) {
                    this.history.recordAction(SignedStateHistory.SignedStateAction.DESTROY, this.getReservationCount(), null, null);
                }
                this.registryRecord.release();
                this.state.release();
            }
            catch (Throwable ex) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "exception while attempting to delete signed state", ex);
            }
        }
    }

    public synchronized int getReservationCount() {
        return this.reservations.getReservationCount();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SignedState that = (SignedState)other;
        return Objects.equals(this.sigSet, that.sigSet) && Objects.equals(this.state, that.state);
    }

    public int hashCode() {
        return Objects.hash(this.sigSet, this.state);
    }

    public String toString() {
        String hashString = this.state.isHashed() ? this.state.getHash().toString() : "not hashed";
        return "SS(round: %d, sigs: %d/%s, hash: %s)".formatted(this.getRound(), this.signingWeight, RosterUtils.computeTotalWeight((Roster)this.getRoster()), hashString);
    }

    @NonNull
    public Instant getConsensusTimestamp() {
        return this.platformStateFacade.consensusTimestampOf(this.state);
    }

    @NonNull
    public Instant getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public boolean isStateToSave() {
        return this.stateToDiskReason != null;
    }

    public void markAsStateToSave(@NonNull StateToDiskReason reason) {
        this.stateToDiskReason = reason;
    }

    @Nullable
    public StateToDiskReason getStateToDiskReason() {
        return this.stateToDiskReason;
    }

    public boolean hasStateBeenSavedToDisk() {
        return this.hasBeenSavedToDisk;
    }

    public void stateSavedToDisk() {
        this.hasBeenSavedToDisk = true;
    }

    public long getSigningWeight() {
        return this.signingWeight;
    }

    public boolean isComplete() {
        return this.recoveryState | this.signedBy(Threshold.SUPER_MAJORITY);
    }

    public boolean isVerifiable() {
        return this.recoveryState | this.signedBy(Threshold.MAJORITY);
    }

    private boolean signedBy(@NonNull Threshold threshold) {
        return Objects.requireNonNull(threshold).isSatisfiedBy(this.signingWeight, RosterUtils.computeTotalWeight((Roster)this.getRoster()));
    }

    public void throwIfNotVerifiable() {
        if (!this.isVerifiable()) {
            throw new SignedStateInvalidException("Signed state lacks sufficient valid signatures. This state has " + this.sigSet.size() + " valid signatures representing " + this.signingWeight + "/" + RosterUtils.computeTotalWeight((Roster)this.getRoster()) + " weight");
        }
    }

    public boolean addSignature(@NonNull NodeId nodeId, @NonNull Signature signature) {
        Objects.requireNonNull(nodeId, "nodeId");
        Objects.requireNonNull(signature, "signature");
        if (this.isComplete()) {
            return false;
        }
        RosterEntry rosterEntry = RosterUtils.getRosterEntryOrNull((Roster)this.getRoster(), (long)nodeId.id());
        if (rosterEntry == null) {
            return false;
        }
        if (!this.isSignatureValid(rosterEntry, signature)) {
            return false;
        }
        if (this.sigSet.hasSignature(nodeId)) {
            return false;
        }
        this.sigSet.addSignature(nodeId, signature);
        this.signingWeight += rosterEntry.weight();
        return this.isComplete();
    }

    private boolean isSignatureValid(@Nullable Address address, @NonNull Signature signature) {
        if (address == null) {
            return false;
        }
        if (address.getWeight() == 0L) {
            return false;
        }
        if (address.getSigPublicKey() == null) {
            return false;
        }
        return this.signatureVerifier.verifySignature(this.state.getHash().getBytes(), signature.getBytes(), address.getSigPublicKey());
    }

    private boolean isSignatureValid(@Nullable RosterEntry rosterEntry, @NonNull Signature signature) {
        if (rosterEntry == null) {
            return false;
        }
        if (rosterEntry.weight() == 0L) {
            return false;
        }
        X509Certificate cert = RosterUtils.fetchGossipCaCertificate((RosterEntry)rosterEntry);
        if (cert == null) {
            return false;
        }
        return this.signatureVerifier.verifySignature(this.state.getHash().getBytes(), signature.getBytes(), cert.getPublicKey());
    }

    public void pruneInvalidSignatures() {
        this.pruneInvalidSignatures(this.getRoster());
    }

    public void pruneInvalidSignatures(@NonNull Roster trustedRoster) {
        RosterEntry entry;
        Objects.requireNonNull(trustedRoster);
        Map entriesByNodeId = RosterUtils.toMap((Roster)trustedRoster);
        ArrayList<NodeId> signaturesToRemove = new ArrayList<NodeId>();
        for (NodeId nodeId : this.sigSet) {
            entry = (RosterEntry)entriesByNodeId.get(nodeId.id());
            if (this.isSignatureValid(entry, this.sigSet.getSignature(nodeId))) continue;
            signaturesToRemove.add(nodeId);
        }
        for (NodeId nodeId : signaturesToRemove) {
            this.sigSet.removeSignature(nodeId);
        }
        this.signingWeight = 0L;
        for (NodeId nodeId : this.sigSet) {
            entry = (RosterEntry)entriesByNodeId.get(nodeId.id());
            if (entry == null) continue;
            this.signingWeight += entry.weight();
        }
    }

    @Nullable
    public SignedStateHistory getHistory() {
        return this.history;
    }
}

