/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.component;

import com.swirlds.component.framework.component.InputWireLabel;
import com.swirlds.component.framework.component.SchedulerLabel;
import com.swirlds.component.framework.component.internal.FilterToBind;
import com.swirlds.component.framework.component.internal.InputWireToBind;
import com.swirlds.component.framework.component.internal.TransformerToBind;
import com.swirlds.component.framework.component.internal.WiringComponentProxy;
import com.swirlds.component.framework.model.WiringModel;
import com.swirlds.component.framework.model.diagram.HyperlinkBuilder;
import com.swirlds.component.framework.schedulers.TaskScheduler;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerConfiguration;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerType;
import com.swirlds.component.framework.transformers.WireFilter;
import com.swirlds.component.framework.transformers.WireTransformer;
import com.swirlds.component.framework.wires.input.BindableInputWire;
import com.swirlds.component.framework.wires.input.InputWire;
import com.swirlds.component.framework.wires.output.OutputWire;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;

public class ComponentWiring<COMPONENT_TYPE, OUTPUT_TYPE> {
    private final WiringModel model;
    private final TaskScheduler<OUTPUT_TYPE> scheduler;
    private final WiringComponentProxy proxy = new WiringComponentProxy();
    private final COMPONENT_TYPE proxyComponent;
    private COMPONENT_TYPE component;
    private final Map<Method, BindableInputWire<Object, Object>> inputWires = new HashMap<Method, BindableInputWire<Object, Object>>();
    private final List<InputWireToBind<COMPONENT_TYPE, Object, OUTPUT_TYPE>> inputsToBind = new ArrayList<InputWireToBind<COMPONENT_TYPE, Object, OUTPUT_TYPE>>();
    private final Map<Method, OutputWire<?>> alternateOutputs = new HashMap();
    private final List<TransformerToBind<COMPONENT_TYPE, Object, Object>> transformersToBind = new ArrayList<TransformerToBind<COMPONENT_TYPE, Object, Object>>();
    private final List<FilterToBind<COMPONENT_TYPE, Object>> filtersToBind = new ArrayList<FilterToBind<COMPONENT_TYPE, Object>>();
    private OutputWire<Object> splitterOutput;

    @Deprecated
    public ComponentWiring(@NonNull WiringModel model, @NonNull Class<COMPONENT_TYPE> clazz, @NonNull TaskScheduler<OUTPUT_TYPE> scheduler) {
        this.model = Objects.requireNonNull(model);
        this.scheduler = Objects.requireNonNull(scheduler);
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("Component class " + clazz.getName() + " is not an interface.");
        }
        this.proxyComponent = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this.proxy);
    }

    public ComponentWiring(@NonNull WiringModel model, @NonNull Class<COMPONENT_TYPE> clazz, @NonNull TaskSchedulerConfiguration schedulerConfiguration) {
        this(model, clazz, schedulerConfiguration, data -> 1L);
    }

    public ComponentWiring(@NonNull WiringModel model, @NonNull Class<COMPONENT_TYPE> clazz, @NonNull TaskSchedulerConfiguration schedulerConfiguration, @NonNull ToLongFunction<Object> dataCounter) {
        this.model = Objects.requireNonNull(model);
        Objects.requireNonNull(schedulerConfiguration);
        SchedulerLabel schedulerLabelAnnotation = clazz.getAnnotation(SchedulerLabel.class);
        String schedulerName = schedulerLabelAnnotation == null ? clazz.getSimpleName() : schedulerLabelAnnotation.value();
        this.scheduler = model.schedulerBuilder(schedulerName).configure(schedulerConfiguration).withHyperlink(HyperlinkBuilder.platformCoreHyperlink(clazz)).withDataCounter(dataCounter).build();
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("Component class " + clazz.getName() + " is not an interface.");
        }
        this.proxyComponent = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this.proxy);
    }

    @NonNull
    public OutputWire<OUTPUT_TYPE> getOutputWire() {
        return this.scheduler.getOutputWire();
    }

    public <INPUT_TYPE> InputWire<INPUT_TYPE> getInputWire(@NonNull BiFunction<COMPONENT_TYPE, INPUT_TYPE, OUTPUT_TYPE> handler) {
        return this.getInputWire(handler, null);
    }

    public <INPUT_TYPE> InputWire<INPUT_TYPE> getInputWire(@NonNull BiFunction<COMPONENT_TYPE, INPUT_TYPE, OUTPUT_TYPE> handler, @Nullable String name) {
        Objects.requireNonNull(handler);
        try {
            handler.apply(this.proxyComponent, null);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Component wiring does not support primitive input types or return types. Use a boxed primitive instead.", e);
        }
        return this.getOrBuildInputWire(this.proxy.getMostRecentlyInvokedMethod(), handler, null, null, null, name);
    }

    public <INPUT_TYPE> InputWire<INPUT_TYPE> getInputWire(@NonNull BiConsumer<COMPONENT_TYPE, INPUT_TYPE> handler) {
        Objects.requireNonNull(handler);
        try {
            handler.accept(this.proxyComponent, null);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Component wiring does not support primitive input types. Use a boxed primitive instead.", e);
        }
        return this.getOrBuildInputWire(this.proxy.getMostRecentlyInvokedMethod(), null, handler, null, null);
    }

    @NonNull
    public <INPUT_TYPE> InputWire<INPUT_TYPE> getInputWire(@NonNull Function<COMPONENT_TYPE, OUTPUT_TYPE> handler) {
        Objects.requireNonNull(handler);
        try {
            handler.apply(this.proxyComponent);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Component wiring does not support primitive input types. Use a boxed primitive instead.", e);
        }
        return this.getOrBuildInputWire(this.proxy.getMostRecentlyInvokedMethod(), null, null, handler, null);
    }

    @NonNull
    public <INPUT_TYPE> InputWire<INPUT_TYPE> getInputWire(@NonNull Consumer<COMPONENT_TYPE> handler) {
        Objects.requireNonNull(handler);
        try {
            handler.accept(this.proxyComponent);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Component wiring does not support primitive input types. Use a boxed primitive instead.", e);
        }
        return this.getOrBuildInputWire(this.proxy.getMostRecentlyInvokedMethod(), null, null, null, handler);
    }

    @NonNull
    public <TRANSFORMED_TYPE> OutputWire<TRANSFORMED_TYPE> getTransformedOutput(@NonNull BiFunction<COMPONENT_TYPE, OUTPUT_TYPE, TRANSFORMED_TYPE> transformation) {
        return this.getOrBuildTransformer(transformation, this.getOutputWire());
    }

    public <ELEMENT, TRANSFORMED_TYPE> OutputWire<TRANSFORMED_TYPE> getSplitAndTransformedOutput(@NonNull BiFunction<COMPONENT_TYPE, ELEMENT, TRANSFORMED_TYPE> transformation) {
        return this.getOrBuildTransformer(transformation, this.getSplitOutput());
    }

    @NonNull
    public OutputWire<OUTPUT_TYPE> getFilteredOutput(@NonNull BiFunction<COMPONENT_TYPE, OUTPUT_TYPE, Boolean> predicate) {
        return this.getOrBuildFilter(predicate, this.getOutputWire());
    }

    @NonNull
    public <ELEMENT> OutputWire<ELEMENT> getSplitAndFilteredOutput(@NonNull BiFunction<COMPONENT_TYPE, ELEMENT, Boolean> predicate) {
        return this.getOrBuildFilter(predicate, this.getSplitOutput());
    }

    @NonNull
    public <ELEMENT> OutputWire<ELEMENT> getSplitOutput() {
        if (this.splitterOutput == null) {
            this.splitterOutput = this.getOutputWire().buildSplitter(this.scheduler.getName() + "Splitter", "data");
        }
        return this.splitterOutput;
    }

    @NonNull
    private <ELEMENT, TRANSFORMED_TYPE> OutputWire<TRANSFORMED_TYPE> getOrBuildTransformer(@NonNull BiFunction<COMPONENT_TYPE, ELEMENT, TRANSFORMED_TYPE> transformation, @NonNull OutputWire<ELEMENT> transformerSource) {
        Objects.requireNonNull(transformation);
        try {
            transformation.apply(this.proxyComponent, null);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Component wiring does not support primitive input types or return types. Use a boxed primitive instead.", e);
        }
        Method method = this.proxy.getMostRecentlyInvokedMethod();
        if (!method.isDefault()) {
            throw new IllegalArgumentException("Method " + method.getName() + " does not have a default.");
        }
        if (this.alternateOutputs.containsKey(method)) {
            return this.alternateOutputs.get(method);
        }
        InputWireLabel inputWireLabel = method.getAnnotation(InputWireLabel.class);
        String wireLabel = inputWireLabel == null ? "data to transform" : inputWireLabel.value();
        SchedulerLabel schedulerLabelAnnotation = method.getAnnotation(SchedulerLabel.class);
        String schedulerLabel = schedulerLabelAnnotation == null ? method.getName() : schedulerLabelAnnotation.value();
        WireTransformer<Object, Object> transformer = new WireTransformer<Object, Object>(this.model, schedulerLabel, wireLabel);
        transformerSource.solderTo(transformer.getInputWire());
        this.alternateOutputs.put(method, transformer.getOutputWire());
        if (this.component == null) {
            this.transformersToBind.add(new TransformerToBind(transformer, transformation));
        } else {
            transformer.bind((A x) -> transformation.apply(this.component, x));
        }
        return transformer.getOutputWire();
    }

    private <ELEMENT> OutputWire<ELEMENT> getOrBuildFilter(@NonNull BiFunction<COMPONENT_TYPE, ELEMENT, Boolean> predicate, @NonNull OutputWire<ELEMENT> filterSource) {
        Objects.requireNonNull(predicate);
        try {
            predicate.apply(this.proxyComponent, null);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Component wiring does not support primitive input types or return types. Use a boxed primitive instead.", e);
        }
        Method method = this.proxy.getMostRecentlyInvokedMethod();
        if (!method.isDefault()) {
            throw new IllegalArgumentException("Method " + method.getName() + " does not have a default.");
        }
        if (this.alternateOutputs.containsKey(method)) {
            return this.alternateOutputs.get(method);
        }
        InputWireLabel inputWireLabel = method.getAnnotation(InputWireLabel.class);
        String wireLabel = inputWireLabel == null ? "data to filter" : inputWireLabel.value();
        SchedulerLabel schedulerLabelAnnotation = method.getAnnotation(SchedulerLabel.class);
        String schedulerLabel = schedulerLabelAnnotation == null ? method.getName() : schedulerLabelAnnotation.value();
        WireFilter<Object> filter = new WireFilter<Object>(this.model, schedulerLabel, wireLabel);
        filterSource.solderTo(filter.getInputWire());
        this.alternateOutputs.put(method, filter.getOutputWire());
        if (this.component == null) {
            this.filtersToBind.add(new FilterToBind(filter, predicate));
        } else {
            filter.bind((T x) -> (Boolean)predicate.apply(this.component, x));
        }
        return filter.getOutputWire();
    }

    private <INPUT_TYPE> InputWire<INPUT_TYPE> getOrBuildInputWire(@NonNull Method method, @Nullable BiFunction<COMPONENT_TYPE, INPUT_TYPE, OUTPUT_TYPE> handlerWithReturn, @Nullable BiConsumer<COMPONENT_TYPE, INPUT_TYPE> handlerWithoutReturn, @Nullable Function<COMPONENT_TYPE, OUTPUT_TYPE> handlerWithoutParameter, @Nullable Consumer<COMPONENT_TYPE> handlerWithoutReturnAndWithoutParameter) {
        return this.getOrBuildInputWire(method, handlerWithReturn, handlerWithoutReturn, handlerWithoutParameter, handlerWithoutReturnAndWithoutParameter, null);
    }

    private <INPUT_TYPE> InputWire<INPUT_TYPE> getOrBuildInputWire(@NonNull Method method, @Nullable BiFunction<COMPONENT_TYPE, INPUT_TYPE, OUTPUT_TYPE> handlerWithReturn, @Nullable BiConsumer<COMPONENT_TYPE, INPUT_TYPE> handlerWithoutReturn, @Nullable Function<COMPONENT_TYPE, OUTPUT_TYPE> handlerWithoutParameter, @Nullable Consumer<COMPONENT_TYPE> handlerWithoutReturnAndWithoutParameter, @Nullable String name) {
        InputWireLabel inputWireLabel;
        if (this.inputWires.containsKey(method)) {
            return this.inputWires.get(method);
        }
        String label = name != null ? name : ((inputWireLabel = method.getAnnotation(InputWireLabel.class)) == null ? method.getName() : inputWireLabel.value());
        BindableInputWire inputWire = this.scheduler.buildInputWire(label);
        this.inputWires.put(method, inputWire);
        if (this.component == null) {
            this.inputsToBind.add(new InputWireToBind(inputWire, handlerWithReturn, handlerWithoutReturn, handlerWithoutParameter, handlerWithoutReturnAndWithoutParameter));
        } else if (handlerWithReturn != null) {
            inputWire.bind((IN x) -> handlerWithReturn.apply(this.component, x));
        } else if (handlerWithoutReturn != null) {
            inputWire.bindConsumer(x -> handlerWithoutReturn.accept(this.component, x));
        } else if (handlerWithoutParameter != null) {
            inputWire.bind((IN x) -> handlerWithoutParameter.apply(this.component));
        } else {
            assert (handlerWithoutReturnAndWithoutParameter != null);
            inputWire.bindConsumer(x -> handlerWithoutReturnAndWithoutParameter.accept(this.component));
        }
        return inputWire;
    }

    public void flush() {
        this.scheduler.flush();
    }

    public void startSquelching() {
        this.scheduler.startSquelching();
    }

    public void stopSquelching() {
        this.scheduler.stopSquelching();
    }

    public void bind(@NonNull COMPONENT_TYPE component) {
        Objects.requireNonNull(component);
        this.component = component;
        for (InputWireToBind<COMPONENT_TYPE, Object, OUTPUT_TYPE> inputWireToBind : this.inputsToBind) {
            if (inputWireToBind.handlerWithReturn() != null) {
                BiFunction<COMPONENT_TYPE, Object, OUTPUT_TYPE> handlerWithReturn = inputWireToBind.handlerWithReturn();
                inputWireToBind.inputWire().bind((IN x) -> handlerWithReturn.apply(component, x));
                continue;
            }
            if (inputWireToBind.handlerWithoutReturn() != null) {
                BiConsumer<COMPONENT_TYPE, Object> handlerWithoutReturn = inputWireToBind.handlerWithoutReturn();
                inputWireToBind.inputWire().bindConsumer(x -> handlerWithoutReturn.accept(component, x));
                continue;
            }
            if (inputWireToBind.handlerWithoutParameter() != null) {
                inputWireToBind.inputWire().bind((IN x) -> wireToBind.handlerWithoutParameter().apply(component));
                continue;
            }
            assert (inputWireToBind.handlerWithoutReturnAndWithoutParameter() != null);
            inputWireToBind.inputWire().bindConsumer(x -> wireToBind.handlerWithoutReturnAndWithoutParameter().accept(component));
        }
        for (TransformerToBind transformerToBind : this.transformersToBind) {
            WireTransformer transformer = transformerToBind.transformer();
            BiFunction transformation = transformerToBind.transformation();
            transformer.bind((A x) -> transformation.apply(component, x));
        }
        for (FilterToBind filterToBind : this.filtersToBind) {
            filterToBind.filter().bind((T x) -> filterToBind.predicate().apply(component, x));
        }
    }

    public void bind(@NonNull Supplier<COMPONENT_TYPE> componentBuilder) {
        Objects.requireNonNull(componentBuilder);
        if (this.scheduler.getType() != TaskSchedulerType.NO_OP) {
            this.bind(componentBuilder.get());
        }
    }

    @NonNull
    public String getSchedulerName() {
        return this.scheduler.getName();
    }

    @NonNull
    public TaskSchedulerType getSchedulerType() {
        return this.scheduler.getType();
    }
}

