/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.simulated;

import com.swirlds.platform.test.fixtures.simulated.Latency;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import org.hiero.consensus.model.node.NodeId;

public class NetworkLatency {
    private final Map<NodeId, Latency> delays = new HashMap<NodeId, Latency>();

    private NetworkLatency(@NonNull HashMap<NodeId, Latency> delays) {
        Objects.requireNonNull(delays);
        this.delays.putAll(delays);
    }

    @NonNull
    public static NetworkLatency uniformLatency(@NonNull Set<NodeId> nodeIds, @NonNull Duration latency) {
        Objects.requireNonNull(nodeIds);
        Objects.requireNonNull(latency);
        HashMap<NodeId, Latency> delays = new HashMap<NodeId, Latency>();
        for (NodeId nodeId : nodeIds) {
            delays.put(nodeId, new Latency(latency));
        }
        return new NetworkLatency(delays);
    }

    @NonNull
    public static NetworkLatency randomLatency(@NonNull Set<NodeId> nodeIds, @NonNull Duration maxDelay, @NonNull Random random) {
        Objects.requireNonNull(nodeIds);
        Objects.requireNonNull(maxDelay);
        Objects.requireNonNull(random);
        HashMap<NodeId, Latency> delays = new HashMap<NodeId, Latency>();
        for (NodeId nodeId : nodeIds) {
            Latency latency = new Latency(Duration.ofMillis(random.nextInt((int)maxDelay.dividedBy(2L).toMillis())));
            delays.put(nodeId, latency);
        }
        return new NetworkLatency(delays);
    }

    public void setLatency(@NonNull NodeId nodeId, @NonNull Latency latency) {
        Objects.requireNonNull(nodeId);
        Objects.requireNonNull(latency);
        this.delays.put(nodeId, latency);
    }

    @NonNull
    public Duration getLatency(@NonNull NodeId from, @NonNull NodeId to) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        return this.delays.get(from).delay().plus(this.delays.get(to).delay());
    }
}

