/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.platform;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.utility.ThresholdLimitingHandler;
import com.swirlds.demo.merkle.map.FCMConfig;
import com.swirlds.demo.merkle.map.FCMFamily;
import com.swirlds.demo.merkle.map.internal.ExpectedFCMFamily;
import com.swirlds.demo.merkle.map.internal.ExpectedFCMFamilyImpl;
import com.swirlds.demo.platform.ControlAction;
import com.swirlds.demo.platform.NextSeqConsList;
import com.swirlds.demo.platform.PayloadCfgSimple;
import com.swirlds.demo.platform.ProgressCfg;
import com.swirlds.demo.platform.TransactionCounter;
import com.swirlds.demo.platform.TransactionCounterList;
import com.swirlds.demo.platform.UnsafeMutablePTTStateAccessor;
import com.swirlds.demo.platform.actions.QuorumResult;
import com.swirlds.demo.platform.expiration.ExpirationRecordEntry;
import com.swirlds.demo.platform.expiration.ExpirationUtils;
import com.swirlds.demo.platform.iss.IssLeaf;
import com.swirlds.demo.platform.nft.NftId;
import com.swirlds.demo.platform.nft.NftLedger;
import com.swirlds.demo.platform.nft.ReferenceNftLedger;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.merkle.test.fixtures.map.pta.MapKey;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.test.fixtures.merkle.MerkleStateRoot;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.util.Supplier;
import org.hiero.base.constructable.ConstructableIgnored;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.roster.AddressBook;
import org.hiero.consensus.roster.RosterUtils;

@ConstructableIgnored
public class PlatformTestingToolState
extends MerkleStateRoot<PlatformTestingToolState>
implements MerkleNodeState {
    static final long CLASS_ID = -4571139351850460298L;
    private static final Logger logger = LogManager.getLogger(PlatformTestingToolState.class);
    private static final Marker LOGM_DEMO_INFO = MarkerManager.getMarker((String)"DEMO_INFO");
    private static final long EXCEPTION_RATE_THRESHOLD = 10L;
    private static final double NFT_TRACKING_FRACTION = 0.001;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final ReferenceNftLedger referenceNftLedger;
    private long lastTranTimeStamp = 0L;
    private ThresholdLimitingHandler<Throwable> exceptionRateLimiter;
    private ProgressCfg progressCfg;
    protected long roundCounter = 0L;
    private long lastFileTranFinishTimeStamp = 0L;
    @JsonIgnore
    private ExpectedFCMFamily expectedFCMFamily;
    private BlockingQueue<ExpirationRecordEntry> expirationQueue;
    private Set<MapKey> accountsWithExpiringRecords;
    private NodeId selfId;
    static AtomicLong totalTransactionSignatureCount = new AtomicLong(0L);
    static AtomicLong expectedInvalidSignatureCount = new AtomicLong(0L);

    public PlatformTestingToolState() {
        this.expectedFCMFamily = new ExpectedFCMFamilyImpl();
        this.referenceNftLedger = new ReferenceNftLedger(0.001);
    }

    protected PlatformTestingToolState(PlatformTestingToolState sourceState) {
        super((MerkleStateRoot)sourceState);
        this.initialized.set(sourceState.initialized.get());
        this.lastFileTranFinishTimeStamp = sourceState.lastFileTranFinishTimeStamp;
        this.lastTranTimeStamp = sourceState.lastTranTimeStamp;
        this.referenceNftLedger = sourceState.referenceNftLedger.copy();
        this.expectedFCMFamily = sourceState.expectedFCMFamily;
        this.expirationQueue = sourceState.expirationQueue;
        this.accountsWithExpiringRecords = sourceState.accountsWithExpiringRecords;
        this.exceptionRateLimiter = sourceState.exceptionRateLimiter;
        this.progressCfg = sourceState.progressCfg;
        this.roundCounter = sourceState.roundCounter;
        this.selfId = sourceState.selfId;
        if (sourceState.getTransactionCounter() != null) {
            int size = sourceState.getTransactionCounter().size();
            this.setTransactionCounter(new TransactionCounterList(size));
            for (int index = 0; index < size; ++index) {
                this.getTransactionCounter().add(index, ((TransactionCounter)sourceState.getTransactionCounter().get(index)).copy());
            }
        }
        this.setImmutable(false);
        sourceState.setImmutable(true);
    }

    public int getMinimumChildCount() {
        return 7;
    }

    public int getMaximumChildCount() {
        return 13;
    }

    public boolean childHasExpectedType(int index, long childClassId) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
            case 3: {
                return childClassId == 2020050648304598542L;
            }
            case 4: {
                return childClassId == 1024611280899072488L;
            }
            case 5: {
                return childClassId == 4789266076140235797L || childClassId == Long.MIN_VALUE;
            }
            case 6: {
                return childClassId == 8726889819722817309L;
            }
            case 7: {
                return childClassId == -5595132415519119668L;
            }
            case 8: {
                return childClassId == -626531818109765603L;
            }
            case 9: {
                return childClassId == -5151568835156514733L || childClassId == Long.MIN_VALUE;
            }
            case 10: {
                return childClassId == -5151568835156514733L || childClassId == Long.MIN_VALUE;
            }
            case 11: {
                return childClassId == -5151568835156514733L || childClassId == Long.MIN_VALUE;
            }
            case 12: {
                return childClassId == 6401444178458397638L;
            }
        }
        return false;
    }

    public void addDeserializedChildren(List<MerkleNode> children, int version) {
        if (!children.isEmpty() && children.get(0) instanceof AddressBook) {
            children.set(0, null);
        }
        super.addDeserializedChildren(children, version);
    }

    public MerkleNode migrate(int version) {
        return this;
    }

    PayloadCfgSimple getConfig() {
        return (PayloadCfgSimple)this.getChild(3);
    }

    void setConfig(PayloadCfgSimple config) {
        this.setChild(3, (MerkleNode)config);
    }

    public NextSeqConsList getNextSeqCons() {
        return (NextSeqConsList)this.getChild(4);
    }

    void setNextSeqCons(NextSeqConsList nextSeqCons) {
        this.setChild(4, (MerkleNode)nextSeqCons);
    }

    public VirtualMap getVirtualMap() {
        return (VirtualMap)this.getChild(9);
    }

    public void setVirtualMap(VirtualMap virtualMap) {
        this.setChild(9, (MerkleNode)virtualMap);
    }

    public VirtualMap getVirtualMapForSmartContracts() {
        return (VirtualMap)this.getChild(10);
    }

    public void setVirtualMapForSmartContracts(VirtualMap virtualMap) {
        this.setChild(10, (MerkleNode)virtualMap);
    }

    public VirtualMap getVirtualMapForSmartContractsByteCode() {
        return (VirtualMap)this.getChild(11);
    }

    public void setVirtualMapForSmartContractsByteCode(VirtualMap virtualMap) {
        this.setChild(11, (MerkleNode)virtualMap);
    }

    public FCMFamily getFcmFamily() {
        return (FCMFamily)this.getChild(5);
    }

    public QuorumResult<ControlAction> getQuorumResult() {
        return (QuorumResult)this.getChild(12);
    }

    public void setFcmFamily(FCMFamily fcmFamily) {
        this.setChild(5, (MerkleNode)fcmFamily);
    }

    public TransactionCounterList getTransactionCounter() {
        return (TransactionCounterList)this.getChild(6);
    }

    void setTransactionCounter(TransactionCounterList transactionCounter) {
        this.setChild(6, (MerkleNode)transactionCounter);
    }

    IssLeaf getIssLeaf() {
        return (IssLeaf)this.getChild(7);
    }

    void setIssLeaf(IssLeaf leaf) {
        this.setChild(7, (MerkleNode)leaf);
    }

    public void setQuorumResult(QuorumResult<ControlAction> quorumResult) {
        this.setChild(12, (MerkleNode)quorumResult);
    }

    public NftLedger getNftLedger() {
        return (NftLedger)this.getChild(8);
    }

    public void setNftLedger(NftLedger ledger) {
        this.setChild(8, (MerkleNode)ledger);
    }

    public ReferenceNftLedger getReferenceNftLedger() {
        return this.referenceNftLedger;
    }

    public BlockingQueue<ExpirationRecordEntry> getExpirationQueue() {
        return this.expirationQueue;
    }

    public Set<MapKey> getAccountsWithExpiringRecords() {
        return this.accountsWithExpiringRecords;
    }

    public synchronized void setPayloadConfig(FCMConfig fcmConfig, Roster roster) {
        this.expectedFCMFamily.setNodeId(this.selfId.id());
        this.expectedFCMFamily.setFcmConfig(fcmConfig);
        this.expectedFCMFamily.setWeightedNodeNum(RosterUtils.getNumberWithWeight((Roster)roster));
        this.referenceNftLedger.setFractionToTrack(this.getNftLedger(), fcmConfig.getNftTrackingFraction());
    }

    public void setProgressCfg(ProgressCfg progressCfg) {
        this.progressCfg = progressCfg;
    }

    void setSelfId(NodeId selfId) {
        this.selfId = selfId;
    }

    public void initChildren() {
        if (this.getFcmFamily() == null) {
            this.setFcmFamily(new FCMFamily(true));
        }
        if (this.getNftLedger() == null) {
            this.setNftLedger(new NftLedger());
        }
    }

    public void initializeExpirationQueueAndAccountsSet() {
        this.expirationQueue = new PriorityBlockingQueue<ExpirationRecordEntry>();
        this.accountsWithExpiringRecords = new HashSet<MapKey>();
    }

    public void resetLastFileTranFinishTimeStamp() {
        this.lastFileTranFinishTimeStamp = System.currentTimeMillis();
    }

    public synchronized FCMFamily getStateMap() {
        return this.getFcmFamily();
    }

    @JsonIgnore
    public synchronized ExpectedFCMFamily getStateExpectedMap() {
        return this.expectedFCMFamily;
    }

    @NonNull
    public synchronized PlatformTestingToolState copy() {
        this.throwIfImmutable();
        this.setImmutable(true);
        ++this.roundCounter;
        PlatformTestingToolState mutableCopy = new PlatformTestingToolState(this);
        if (this.selfId != null) {
            UnsafeMutablePTTStateAccessor.getInstance().setMutableState(this.selfId, mutableCopy);
        }
        return mutableCopy;
    }

    public void rebuildExpectedMapFromState(Instant consensusTimestamp, boolean isRestart) {
        logger.info(LOGM_DEMO_INFO, "Start Rebuilding ExpectedMap");
        this.expectedFCMFamily.rebuildExpectedMap(this.getStateMap(), isRestart, 0L);
        logger.info(LOGM_DEMO_INFO, "Finish Rebuilding ExpectedMap [ size = {} ]", new Supplier[]{() -> this.expectedFCMFamily.getExpectedMap().size()});
    }

    public long getClassId() {
        return -4571139351850460298L;
    }

    public int getVersion() {
        return 5;
    }

    public int getMinimumSupportedVersion() {
        return this.getVersion();
    }

    public synchronized void rebuild() {
        boolean isMMapInitialized = this.getStateMap() != null;
        logger.info(LOGM_DEMO_INFO, "Finished initializing PlatformTestingDemoState with map {}", (Object)isMMapInitialized);
        if (isMMapInitialized) {
            logger.info(LOGM_DEMO_INFO, "The fcq MerkleMap has size {}", (Object)this.getStateMap().getAccountFCQMap().size());
            logger.info(LOGM_DEMO_INFO, "The account MerkleMap has size {}", (Object)this.getStateMap().getMap().size());
        }
        for (NftId nftId : this.getNftLedger().getTokenIdToToken().keySet()) {
            this.expectedFCMFamily.addNftId(nftId);
        }
        this.getReferenceNftLedger().reload(this.getNftLedger());
    }

    long removeExpiredRecordsInExpirationQueue(long consensusCurrentTimestamp) {
        long removedNumOfRecords = 0L;
        while (!this.expirationQueue.isEmpty() && ((ExpirationRecordEntry)this.expirationQueue.peek()).getEarliestExpiry() <= consensusCurrentTimestamp) {
            ExpirationRecordEntry ere = (ExpirationRecordEntry)this.expirationQueue.poll();
            MapKey id = ere.getMapKey().copy();
            FCMFamily fcmFamily = this.getFcmFamily();
            removedNumOfRecords += ExpirationUtils.purgeTransactionRecords(consensusCurrentTimestamp, this.expirationQueue, this.accountsWithExpiringRecords, id, fcmFamily, this.expectedFCMFamily);
        }
        return removedNumOfRecords;
    }

    public void rebuildExpirationQueue() {
        FCMFamily fcmFamily = this.getFcmFamily();
        if (fcmFamily == null || fcmFamily.getAccountFCQMap() == null) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "FCMFamily is null, so could not rebuild Expiration Queue");
            return;
        }
        if (fcmFamily.getAccountFCQMap().isEmpty()) {
            return;
        }
        this.expirationQueue = new PriorityBlockingQueue<ExpirationRecordEntry>();
        this.accountsWithExpiringRecords = new HashSet<MapKey>();
        ExpirationUtils.addRecordsDuringRebuild(fcmFamily, this.expirationQueue, this.accountsWithExpiringRecords);
    }

    public void setExpectedFCMFamily(ExpectedFCMFamily expectedFCMFamily) {
        this.expectedFCMFamily = expectedFCMFamily;
    }

    protected PlatformTestingToolState copyingConstructor() {
        return new PlatformTestingToolState(this);
    }

    private static class ChildIndices {
        public static final int UNUSED_PLATFORM_STATE = 0;
        public static final int UNUSED_ROSTERS = 1;
        public static final int UNUSED_ROSTER_STATE = 2;
        public static final int CONFIG = 3;
        public static final int NEXT_SEQUENCE_CONSENSUS = 4;
        public static final int FCM_FAMILY = 5;
        public static final int TRANSACTION_COUNTER = 6;
        public static final int ISS_LEAF = 7;
        public static final int SDK_VERSION_21_CHILD_COUNT = 7;
        public static final int NFT_LEDGER = 8;
        public static final int VIRTUAL_MERKLE = 9;
        public static final int VIRTUAL_MERKLE_SMART_CONTRACTS = 10;
        public static final int VIRTUAL_MERKLE_SMART_CONTRACTS_BYTE_CODE = 11;
        public static final int QUORUM_RESULT = 12;
        public static final int CHILD_COUNT = 13;

        private ChildIndices() {
        }
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;
        public static final int MIGRATE_TO_SERIALIZABLE = 2;
        public static final int REMOVED_FCM_OPERATIONS = 3;
        public static final int ADDED_NFT_LEDGER = 4;
        public static final int ADD_QUORUM_RESULT = 5;

        private ClassVersion() {
        }
    }
}

