/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.metrics;

import com.swirlds.common.metrics.RunningAverageMetric;
import com.swirlds.common.metrics.SpeedometerMetric;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;

public class StateMetrics {
    private static final RunningAverageMetric.Config AVG_SEC_TRANS_HANDLED_CONFIG = new RunningAverageMetric.Config("internal", "secTransH").withDescription("avg time to handle a consensus transaction in ConsensusStateEventHandler.onHandleTransaction (in seconds)").withFormat("%,10.6f");
    private final RunningAverageMetric avgSecTransHandled;
    private static final RunningAverageMetric.Config AVG_CONS_HANDLE_TIME_CONFIG = new RunningAverageMetric.Config("platform", "SecC2H").withDescription("time from knowing consensus for a transaction to handling it (in seconds)").withFormat("%,10.3f");
    private final RunningAverageMetric avgConsHandleTime;
    private static final SpeedometerMetric.Config TRANS_HANDLED_PER_SECOND_CONFIG = new SpeedometerMetric.Config("internal", "transH_per_sec").withDescription("number of consensus transactions per second handled by ConsensusStateEventHandler.onHandleTransaction()").withFormat("%,9.6f");
    private final SpeedometerMetric transHandledPerSecond;
    private static final RunningAverageMetric.Config AVG_STATE_COPY_MICROS_CONFIG = new RunningAverageMetric.Config("internal", "stateCopyMicros").withDescription("average time it takes the State.copy() method in ConsensusStateEventHandler to finish (in microseconds)").withFormat("%,16.2f");
    private final RunningAverageMetric avgStateCopyMicros;

    public StateMetrics(Metrics metrics) {
        this.avgSecTransHandled = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_SEC_TRANS_HANDLED_CONFIG);
        this.avgConsHandleTime = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_CONS_HANDLE_TIME_CONFIG);
        this.transHandledPerSecond = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)TRANS_HANDLED_PER_SECOND_CONFIG);
        this.avgStateCopyMicros = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_STATE_COPY_MICROS_CONFIG);
    }

    public void consensusTransHandleTime(double seconds) {
        this.avgSecTransHandled.update(seconds);
    }

    public void consensusToHandleTime(double seconds) {
        this.avgConsHandleTime.update(seconds);
    }

    public void consensusTransHandled(int numTrans) {
        this.transHandledPerSecond.update((double)numTrans);
    }

    public void stateCopyMicros(double micros) {
        this.avgStateCopyMicros.update(micros);
    }
}

