/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.crypto;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.base.utility.ToStringBuilder;
import java.util.Objects;
import org.hiero.base.crypto.SignatureType;
import org.hiero.base.crypto.VerificationStatus;

public class TransactionSignature {
    private final Bytes message;
    private final Bytes publicKey;
    private final Bytes signature;
    private final SignatureType signatureType;
    private VerificationStatus signatureStatus;

    public TransactionSignature(Bytes message, Bytes publicKey, Bytes signature, SignatureType signatureType) {
        this.message = message;
        this.publicKey = publicKey;
        this.signature = signature;
        this.signatureType = signatureType;
        this.signatureStatus = VerificationStatus.UNKNOWN;
    }

    public Bytes getMessage() {
        return this.message;
    }

    public Bytes getPublicKey() {
        return this.publicKey;
    }

    public Bytes getSignature() {
        return this.signature;
    }

    public SignatureType getSignatureType() {
        return this.signatureType;
    }

    public VerificationStatus getSignatureStatus() {
        return this.signatureStatus;
    }

    public void setSignatureStatus(VerificationStatus signatureStatus) {
        this.signatureStatus = signatureStatus;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TransactionSignature)) {
            return false;
        }
        TransactionSignature other = (TransactionSignature)obj;
        return this.signature.equals((Object)other.signature) && this.message.equals((Object)other.message) && this.publicKey.equals((Object)other.publicKey) && this.signatureType == other.signatureType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.message.hashCode(), this.publicKey.hashCode(), this.signature.hashCode(), this.signatureType});
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("message", (Object)this.message.toString()).append("publicKey", (Object)this.publicKey.toString()).append("signature", (Object)this.signature.toString()).append("signatureType", (Object)this.signatureType).append("signatureStatus", (Object)this.signatureStatus).toString();
    }
}

