/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.io.extendable.extensions;

import com.swirlds.common.io.extendable.extensions.AbstractStreamExtension;
import com.swirlds.common.io.extendable.extensions.internal.Counter;
import com.swirlds.common.io.extendable.extensions.internal.StandardCounter;
import com.swirlds.common.io.extendable.extensions.internal.ThreadSafeCounter;
import java.io.IOException;

public class MaxSizeStreamExtension
extends AbstractStreamExtension {
    private final long maxByteCount;
    private final Counter counter;

    public MaxSizeStreamExtension(long maxByteCount) {
        this(maxByteCount, true);
    }

    public MaxSizeStreamExtension(long maxByteCount, boolean threadSafe) {
        this.maxByteCount = maxByteCount;
        this.counter = threadSafe ? new ThreadSafeCounter() : new StandardCounter();
    }

    @Override
    public void newByte(int aByte) throws IOException {
        long count = this.counter.addToCount(1L);
        if (count > this.maxByteCount) {
            throw new IOException("number of bytes exceeds maximum of " + this.maxByteCount);
        }
    }

    @Override
    public void newBytes(byte[] bytes, int offset, int length) throws IOException {
        long count = this.counter.addToCount(length);
        if (count > this.maxByteCount) {
            throw new IOException("number of bytes exceeds maximum of " + this.maxByteCount);
        }
    }

    public void reset() {
        this.counter.resetCount();
    }
}

