/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.metrics.api;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.MetricType;
import com.swirlds.metrics.api.MetricsFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.EnumSet;
import java.util.Objects;

public interface IntegerGauge
extends Metric {
    @Override
    @NonNull
    default public MetricType getMetricType() {
        return MetricType.GAUGE;
    }

    @Override
    @NonNull
    default public Metric.DataType getDataType() {
        return Metric.DataType.INT;
    }

    @Override
    @NonNull
    default public EnumSet<Metric.ValueType> getValueTypes() {
        return EnumSet.of(Metric.ValueType.VALUE);
    }

    @Override
    @NonNull
    default public Integer get(@NonNull Metric.ValueType valueType) {
        Objects.requireNonNull(valueType, "valueType must not be null");
        if (valueType == Metric.ValueType.VALUE) {
            return this.get();
        }
        throw new IllegalArgumentException("Unsupported ValueType: " + String.valueOf((Object)valueType));
    }

    public int get();

    public void set(int var1);

    public void add(int var1);

    public static final class Config
    extends MetricConfig<IntegerGauge, Config> {
        private final int initialValue;

        public Config(@NonNull String category, @NonNull String name) {
            super(category, name, "%d");
            this.initialValue = 0;
        }

        private Config(@NonNull String category, @NonNull String name, @NonNull String description, @NonNull String unit, @NonNull String format, int initialValue) {
            super(category, name, description, unit, format);
            this.initialValue = initialValue;
        }

        @Override
        @NonNull
        public Config withDescription(@NonNull String description) {
            return new Config(this.getCategory(), this.getName(), description, this.getUnit(), this.getFormat(), this.getInitialValue());
        }

        @Override
        @NonNull
        public Config withUnit(@NonNull String unit) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), unit, this.getFormat(), this.getInitialValue());
        }

        @NonNull
        public Config withFormat(@NonNull String format) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), format, this.getInitialValue());
        }

        public int getInitialValue() {
            return this.initialValue;
        }

        @NonNull
        public Config withInitialValue(int initialValue) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), initialValue);
        }

        @Override
        @NonNull
        public Class<IntegerGauge> getResultClass() {
            return IntegerGauge.class;
        }

        @Override
        @NonNull
        public IntegerGauge create(@NonNull MetricsFactory factory) {
            return factory.createIntegerGauge(this);
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("initialValue", (Object)this.initialValue).toString();
        }
    }
}

