/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.merkle;

import com.swirlds.common.merkle.crypto.MerkleCryptography;
import com.swirlds.common.merkle.crypto.MerkleCryptographyFactory;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.concurrent.locks.AutoClosableLock;
import org.hiero.base.concurrent.locks.Locks;
import org.hiero.base.concurrent.locks.locked.Locked;
import org.hiero.base.crypto.config.CryptoConfig;

public class TestMerkleCryptoFactory {
    private static final Logger logger = LogManager.getLogger(TestMerkleCryptoFactory.class);
    private static final AutoClosableLock lock = Locks.createAutoLock();
    private static MerkleCryptography merkleCryptography;

    private TestMerkleCryptoFactory() {
    }

    private static void init() {
        Configuration defaultConfiguration = ConfigurationBuilder.create().withConfigDataType(CryptoConfig.class).build();
        merkleCryptography = MerkleCryptographyFactory.create((Configuration)defaultConfiguration);
    }

    public static void set(@NonNull MerkleCryptography merkleCryptography) {
        try (Locked ignored = lock.lock();){
            TestMerkleCryptoFactory.merkleCryptography = merkleCryptography;
        }
    }

    public static MerkleCryptography getInstance() {
        try (Locked ignored = lock.lock();){
            if (merkleCryptography == null) {
                TestMerkleCryptoFactory.init();
            }
            MerkleCryptography merkleCryptography = TestMerkleCryptoFactory.merkleCryptography;
            return merkleCryptography;
        }
    }
}

