/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network;

import com.swirlds.common.threading.framework.config.ThreadConfiguration;
import com.swirlds.common.threading.manager.ThreadManager;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.network.PeerInfo;
import com.swirlds.platform.network.connectivity.InboundConnectionHandler;
import com.swirlds.platform.network.connectivity.SocketFactory;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.concurrent.interrupt.InterruptableRunnable;

public class PeerConnectionServer
implements InterruptableRunnable {
    private static final int SLEEP_AFTER_BIND_FAILED_MS = 100;
    private static final Logger logger = LogManager.getLogger(PeerConnectionServer.class);
    private final int port;
    private final SocketFactory socketFactory;
    private volatile InboundConnectionHandler newConnectionHandler;
    private final ExecutorService incomingConnPool;

    public PeerConnectionServer(ThreadManager threadManager, int port, InboundConnectionHandler inboundConnectionHandler, SocketFactory socketFactory, int maxThreads) {
        this.port = port;
        this.newConnectionHandler = inboundConnectionHandler;
        this.socketFactory = socketFactory;
        this.incomingConnPool = new ThreadPoolExecutor(0, maxThreads, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), ((ThreadConfiguration)new ThreadConfiguration(threadManager).setThreadName("peer_sync_server")).buildFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public void run() throws InterruptedException {
        try (ServerSocket serverSocket = this.socketFactory.createServerSocket(this.port);){
            this.listen(serverSocket);
        }
        catch (IOException | RuntimeException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Cannot bind ServerSocket on port {}", (Object)this.port, (Object)e);
        }
        Thread.sleep(100L);
    }

    private void listen(ServerSocket serverSocket) throws InterruptedException {
        while (!serverSocket.isClosed()) {
            try {
                Socket clientSocket = serverSocket.accept();
                this.incomingConnPool.submit(() -> this.newConnectionHandler.handle(clientSocket));
            }
            catch (SocketTimeoutException expectedWithNonZeroSOTimeout) {
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new InterruptedException();
            }
            catch (IOException | RuntimeException e) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "SyncServer serverSocket.accept() error", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replacePeers(List<PeerInfo> peers) {
        SocketFactory socketFactory = this.socketFactory;
        synchronized (socketFactory) {
            this.socketFactory.reload(peers);
            this.newConnectionHandler = this.newConnectionHandler.withNewPeers(peers);
        }
    }
}

