/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.test.fixtures.merkle;

import com.swirlds.base.time.Time;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.crypto.MerkleCryptography;
import com.swirlds.common.merkle.impl.PartialNaryMerkleInternal;
import com.swirlds.common.merkle.utility.MerkleTreeSnapshotReader;
import com.swirlds.common.merkle.utility.MerkleTreeSnapshotWriter;
import com.swirlds.common.utility.Labeled;
import com.swirlds.common.utility.RuntimeObjectRecord;
import com.swirlds.common.utility.RuntimeObjectRegistry;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.state.State;
import com.swirlds.state.StateChangeListener;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.lifecycle.StateMetadata;
import com.swirlds.state.merkle.MerkleRootSnapshotMetrics;
import com.swirlds.state.spi.CommittableWritableStates;
import com.swirlds.state.spi.EmptyReadableStates;
import com.swirlds.state.spi.KVChangeListener;
import com.swirlds.state.spi.QueueChangeListener;
import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.ReadableQueueState;
import com.swirlds.state.spi.ReadableSingletonState;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableKVState;
import com.swirlds.state.spi.WritableKVStateBase;
import com.swirlds.state.spi.WritableQueueState;
import com.swirlds.state.spi.WritableQueueStateBase;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.spi.WritableSingletonStateBase;
import com.swirlds.state.spi.WritableStates;
import com.swirlds.state.test.fixtures.merkle.disk.BackedReadableKVState;
import com.swirlds.state.test.fixtures.merkle.disk.BackedWritableKVState;
import com.swirlds.state.test.fixtures.merkle.queue.BackedReadableQueueState;
import com.swirlds.state.test.fixtures.merkle.queue.BackedWritableQueueState;
import com.swirlds.state.test.fixtures.merkle.queue.QueueNode;
import com.swirlds.state.test.fixtures.merkle.singleton.BackedReadableSingletonState;
import com.swirlds.state.test.fixtures.merkle.singleton.BackedWritableSingletonState;
import com.swirlds.state.test.fixtures.merkle.singleton.SingletonNode;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.constructable.ConstructableIgnored;

@Deprecated
@ConstructableIgnored
public abstract class MerkleStateRoot<T extends MerkleStateRoot<T>>
extends PartialNaryMerkleInternal
implements MerkleInternal,
State {
    private static final Logger logger = LogManager.getLogger(MerkleStateRoot.class);
    private static final long CLASS_ID = -8201042766723040485L;
    public static final int MINIMUM_SUPPORTED_VERSION = 32;
    public static final int CURRENT_VERSION = 32;
    private static final Map<String, Integer> INDEX_LOOKUP = new ConcurrentHashMap<String, Integer>();
    private LongSupplier roundSupplier;
    private MerkleCryptography merkleCryptography;
    private Time time;
    private MerkleRootSnapshotMetrics snapshotMetrics = new MerkleRootSnapshotMetrics();
    private final Map<String, Map<Integer, StateMetadata<?, ?>>> services = new HashMap();
    private final Map<String, ReadableStates> readableStatesMap = new ConcurrentHashMap<String, ReadableStates>();
    private final Map<String, MerkleWritableStates> writableStatesMap = new HashMap<String, MerkleWritableStates>();
    private final List<StateChangeListener> listeners = new ArrayList<StateChangeListener>();
    private final RuntimeObjectRecord registryRecord = RuntimeObjectRegistry.createRecord(((Object)((Object)this)).getClass());

    public Map<String, Map<Integer, StateMetadata<?, ?>>> getServices() {
        return this.services;
    }

    public MerkleStateRoot() {
    }

    public void init(@NonNull Time time, @NonNull Metrics metrics, @NonNull MerkleCryptography merkleCryptography, @NonNull LongSupplier roundSupplier) {
        this.time = time;
        this.merkleCryptography = merkleCryptography;
        this.roundSupplier = roundSupplier;
        this.snapshotMetrics = new MerkleRootSnapshotMetrics(metrics);
    }

    protected MerkleStateRoot(@NonNull MerkleStateRoot<T> from) {
        super(from);
        this.listeners.addAll(from.listeners);
        this.roundSupplier = from.roundSupplier;
        for (Map.Entry<String, Map<Integer, StateMetadata<?, ?>>> entry : from.services.entrySet()) {
            this.services.put(entry.getKey(), new HashMap(entry.getValue()));
        }
        int n = from.getNumberOfChildren();
        for (int childIndex = 0; childIndex < n; ++childIndex) {
            MerkleNode childToCopy = from.getChild(childIndex);
            if (childToCopy == null) continue;
            this.setChild(childIndex, childToCopy.copy());
        }
    }

    public boolean isStartUpMode() {
        return false;
    }

    public boolean isHashed() {
        return this.getHash() != null;
    }

    public long getClassId() {
        return -8201042766723040485L;
    }

    public int getVersion() {
        return 32;
    }

    public int getMinimumSupportedVersion() {
        return 32;
    }

    public void close() {
        logger.info("Closing MerkleStateRoot");
        for (Map<Integer, StateMetadata<?, ?>> svc : this.services.values()) {
            for (StateMetadata<?, ?> md : svc.values()) {
                MerkleNode node;
                int index = this.findNodeIndex(md.serviceName(), md.stateDefinition().stateKey());
                if (index < 0 || !((node = this.getChild(index)) instanceof VirtualMap)) continue;
                VirtualMap virtualMap = (VirtualMap)node;
                try {
                    virtualMap.getDataSource().close();
                }
                catch (IOException e) {
                    logger.warn("Unable to close data source for virtual map {}", (Object)md.serviceName(), (Object)e);
                }
            }
        }
    }

    public void destroyNode() {
        this.registryRecord.release();
    }

    @NonNull
    public ReadableStates getReadableStates(@NonNull String serviceName) {
        return this.readableStatesMap.computeIfAbsent(serviceName, s -> {
            Map<Integer, StateMetadata<?, ?>> stateMetadata = this.services.get(s);
            return stateMetadata == null ? EmptyReadableStates.INSTANCE : new MerkleReadableStates(this, stateMetadata);
        });
    }

    @NonNull
    public WritableStates getWritableStates(@NonNull String serviceName) {
        this.throwIfImmutable();
        return this.writableStatesMap.computeIfAbsent(serviceName, s -> {
            Map<Integer, StateMetadata<?, ?>> stateMetadata = this.services.getOrDefault(s, Map.of());
            return new MerkleWritableStates(serviceName, stateMetadata);
        });
    }

    public void registerCommitListener(@NonNull StateChangeListener listener) {
        Objects.requireNonNull(listener);
        this.listeners.add(listener);
    }

    public void unregisterCommitListener(@NonNull StateChangeListener listener) {
        Objects.requireNonNull(listener);
        this.listeners.remove(listener);
    }

    @NonNull
    public T copy() {
        this.throwIfImmutable();
        this.throwIfDestroyed();
        this.setImmutable(true);
        return this.copyingConstructor();
    }

    protected abstract T copyingConstructor();

    public <T extends MerkleNode> void putServiceStateIfAbsent(@NonNull StateMetadata<?, ?> md, @NonNull Supplier<T> nodeSupplier, @NonNull Consumer<T> nodeInitializer) {
        MerkleNode node;
        this.throwIfImmutable();
        Objects.requireNonNull(md);
        Objects.requireNonNull(nodeSupplier);
        Objects.requireNonNull(nodeInitializer);
        StateDefinition def = md.stateDefinition();
        String serviceName = md.serviceName();
        Map stateMetadata = this.services.computeIfAbsent(serviceName, k -> new HashMap());
        stateMetadata.put(def.stateId(), md);
        this.readableStatesMap.put(serviceName, new MerkleReadableStates(this, stateMetadata));
        this.writableStatesMap.put(serviceName, new MerkleWritableStates(serviceName, stateMetadata));
        int nodeIndex = this.findNodeIndex(serviceName, def.stateKey());
        if (nodeIndex == -1) {
            String label;
            node = Objects.requireNonNull((MerkleNode)nodeSupplier.get());
            if (node instanceof Labeled) {
                Labeled labeled = (Labeled)node;
                v0 = labeled.getLabel();
            } else {
                v0 = label = null;
            }
            if (label == null) {
                throw new IllegalArgumentException("`node` must be a Labeled and have a label");
            }
            if (def.onDisk() && !(node instanceof VirtualMap)) {
                throw new IllegalArgumentException("Mismatch: state definition claims on-disk, but the merkle node is not a VirtualMap");
            }
            if (label.isEmpty()) {
                throw new IllegalArgumentException("A label must be specified on the node");
            }
            if (!label.equals(StateMetadata.computeLabel((String)serviceName, (String)def.stateKey()))) {
                throw new IllegalArgumentException("A label must be computed based on the same service name and state key in the metadata!");
            }
            this.setChild(this.getNumberOfChildren(), node);
        } else {
            node = this.getChild(nodeIndex);
        }
        nodeInitializer.accept(node);
    }

    public void initializeState(@NonNull StateMetadata<?, ?> md) {
        this.throwIfImmutable();
        Objects.requireNonNull(md);
        StateDefinition def = md.stateDefinition();
        String serviceName = md.serviceName();
        Map stateMetadata = this.services.computeIfAbsent(serviceName, k -> new HashMap());
        stateMetadata.put(def.stateId(), md);
        this.readableStatesMap.put(serviceName, new MerkleReadableStates(this, stateMetadata));
        this.writableStatesMap.put(serviceName, new MerkleWritableStates(serviceName, stateMetadata));
    }

    public void unregisterService(@NonNull String serviceName) {
        this.readableStatesMap.remove(serviceName);
        this.writableStatesMap.remove(serviceName);
        this.services.remove(serviceName);
    }

    public void removeServiceState(@NonNull String serviceName, int stateId) {
        throw new UnsupportedOperationException();
    }

    public int findNodeIndex(@NonNull String serviceName, @NonNull String stateKey) {
        Objects.requireNonNull(serviceName, "Service name may not be null");
        String label = StateMetadata.computeLabel((String)serviceName, (String)stateKey);
        Integer index = INDEX_LOOKUP.get(label);
        if (index != null && this.checkNodeIndex(index, label)) {
            return index;
        }
        int n = this.getNumberOfChildren();
        for (int i = 0; i < n; ++i) {
            if (!this.checkNodeIndex(i, label)) continue;
            INDEX_LOOKUP.put(label, i);
            return i;
        }
        INDEX_LOOKUP.remove(label);
        return -1;
    }

    private boolean checkNodeIndex(int index, @NonNull String label) {
        Labeled labeled;
        MerkleNode node = this.getChild(index);
        return node instanceof Labeled && Objects.equals(label, (labeled = (Labeled)node).getLabel());
    }

    public void computeHash() {
        Objects.requireNonNull(this.merkleCryptography, "MerkleStateRoot has to be initialized before hashing. merkleCryptography is not set.");
        this.throwIfMutable("Hashing should only be done on immutable states");
        this.throwIfDestroyed("Hashing should not be done on destroyed states");
        if (this.getHash() != null) {
            return;
        }
        try {
            this.merkleCryptography.digestTreeAsync((MerkleNode)this).get();
        }
        catch (ExecutionException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Exception occurred during hashing", (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Interrupted while hashing state. Expect buggy behavior.");
            Thread.currentThread().interrupt();
        }
    }

    public void createSnapshot(@NonNull Path targetPath) {
        Objects.requireNonNull(this.time);
        Objects.requireNonNull(this.snapshotMetrics);
        this.throwIfMutable();
        this.throwIfDestroyed();
        long startTime = this.time.currentTimeMillis();
        MerkleTreeSnapshotWriter.createSnapshot((MerkleNode)this, (Path)targetPath, (long)this.roundSupplier.getAsLong());
        this.snapshotMetrics.updateWriteStateToDiskTimeMetric(this.time.currentTimeMillis() - startTime);
    }

    public T loadSnapshot(@NonNull Path targetPath) throws IOException {
        return (T)((Object)((MerkleStateRoot)MerkleTreeSnapshotReader.readStateFileData((Path)targetPath).stateRoot()));
    }

    public final class MerkleReadableStates
    extends MerkleStates {
        MerkleReadableStates(@NonNull MerkleStateRoot this$0, Map<Integer, StateMetadata<?, ?>> stateMetadata) {
            super(stateMetadata);
        }

        @NonNull
        protected ReadableKVState<?, ?> createReadableKVState(@NonNull StateMetadata md, @NonNull VirtualMap v) {
            return new BackedReadableKVState(md.stateDefinition().stateId(), StateMetadata.computeLabel((String)md.serviceName(), (String)md.stateDefinition().stateKey()), Objects.requireNonNull(md.stateDefinition().keyCodec()), md.stateDefinition().valueCodec(), v);
        }

        @NonNull
        protected ReadableSingletonState<?> createReadableSingletonState(@NonNull StateMetadata md, @NonNull SingletonNode<?> s) {
            return new BackedReadableSingletonState(md.stateDefinition().stateId(), StateMetadata.computeLabel((String)md.serviceName(), (String)md.stateDefinition().stateKey()), s);
        }

        @Override
        @NonNull
        protected ReadableQueueState createReadableQueueState(@NonNull StateMetadata md, @NonNull QueueNode<?> q) {
            return new BackedReadableQueueState(md.stateDefinition().stateId(), StateMetadata.computeLabel((String)md.serviceName(), (String)md.stateDefinition().stateKey()), q);
        }
    }

    public final class MerkleWritableStates
    extends MerkleStates
    implements WritableStates,
    CommittableWritableStates {
        private final String serviceName;

        MerkleWritableStates(@NonNull String serviceName, Map<Integer, StateMetadata<?, ?>> stateMetadata) {
            super(stateMetadata);
            this.serviceName = Objects.requireNonNull(serviceName);
        }

        @NonNull
        public <K, V> WritableKVState<K, V> get(int stateId) {
            return (WritableKVState)super.get(stateId);
        }

        @NonNull
        public <S> WritableSingletonState<S> getSingleton(int stateId) {
            return (WritableSingletonState)super.getSingleton(stateId);
        }

        @NonNull
        public <E> WritableQueueState<E> getQueue(int stateId) {
            return (WritableQueueState)super.getQueue(stateId);
        }

        @NonNull
        protected WritableKVState<?, ?> createReadableKVState(@NonNull StateMetadata md, @NonNull VirtualMap v) {
            BackedWritableKVState state = new BackedWritableKVState(md.stateDefinition().stateId(), StateMetadata.computeLabel((String)md.serviceName(), (String)md.stateDefinition().stateKey()), Objects.requireNonNull(md.stateDefinition().keyCodec()), md.stateDefinition().valueCodec(), v);
            MerkleStateRoot.this.listeners.forEach(listener -> {
                if (listener.stateTypes().contains(StateChangeListener.StateType.MAP)) {
                    this.registerKVListener(state, (StateChangeListener)listener);
                }
            });
            return state;
        }

        @NonNull
        protected WritableSingletonState<?> createReadableSingletonState(@NonNull StateMetadata md, @NonNull SingletonNode<?> s) {
            BackedWritableSingletonState state = new BackedWritableSingletonState(md.stateDefinition().stateId(), StateMetadata.computeLabel((String)md.serviceName(), (String)md.stateDefinition().stateKey()), s);
            MerkleStateRoot.this.listeners.forEach(listener -> {
                if (listener.stateTypes().contains(StateChangeListener.StateType.SINGLETON)) {
                    this.registerSingletonListener(state, (StateChangeListener)listener);
                }
            });
            return state;
        }

        @NonNull
        protected WritableQueueState<?> createReadableQueueState(@NonNull StateMetadata md, @NonNull QueueNode<?> q) {
            BackedWritableQueueState state = new BackedWritableQueueState(md.stateDefinition().stateId(), StateMetadata.computeLabel((String)md.serviceName(), (String)md.stateDefinition().stateKey()), q);
            MerkleStateRoot.this.listeners.forEach(listener -> {
                if (listener.stateTypes().contains(StateChangeListener.StateType.QUEUE)) {
                    this.registerQueueListener(state, (StateChangeListener)listener);
                }
            });
            return state;
        }

        public void commit() {
            for (ReadableKVState kv : this.kvInstances.values()) {
                ((WritableKVStateBase)kv).commit();
            }
            for (ReadableSingletonState s : this.singletonInstances.values()) {
                ((WritableSingletonStateBase)s).commit();
            }
            for (ReadableQueueState q : this.queueInstances.values()) {
                ((WritableQueueStateBase)q).commit();
            }
            MerkleStateRoot.this.readableStatesMap.remove(this.serviceName);
        }

        public void remove(int stateId) {
            if (!Map.of().equals(this.stateMetadata)) {
                this.stateMetadata.remove(stateId);
            }
            this.kvInstances.remove(stateId);
            this.singletonInstances.remove(stateId);
            this.queueInstances.remove(stateId);
        }

        private <V> void registerSingletonListener(@NonNull WritableSingletonStateBase<V> singletonState, @NonNull StateChangeListener listener) {
            int stateId = singletonState.getStateId();
            singletonState.registerListener(value -> listener.singletonUpdateChange(stateId, value));
        }

        private <V> void registerQueueListener(@NonNull WritableQueueStateBase<V> queueState, final @NonNull StateChangeListener listener) {
            final int stateId = queueState.getStateId();
            queueState.registerListener(new QueueChangeListener<V>(this){

                public void queuePushChange(@NonNull V value) {
                    listener.queuePushChange(stateId, value);
                }

                public void queuePopChange() {
                    listener.queuePopChange(stateId);
                }
            });
        }

        private <K, V> void registerKVListener(WritableKVStateBase<K, V> state, final StateChangeListener listener) {
            final int stateId = state.getStateId();
            state.registerListener(new KVChangeListener<K, V>(this){

                public void mapUpdateChange(@NonNull K key, @NonNull V value) {
                    listener.mapUpdateChange(stateId, key, value);
                }

                public void mapDeleteChange(@NonNull K key) {
                    listener.mapDeleteChange(stateId, key);
                }
            });
        }
    }

    private abstract class MerkleStates
    implements ReadableStates {
        protected final Map<Integer, StateMetadata<?, ?>> stateMetadata;
        protected final Map<Integer, ReadableKVState<?, ?>> kvInstances;
        protected final Map<Integer, ReadableSingletonState<?>> singletonInstances;
        protected final Map<Integer, ReadableQueueState<?>> queueInstances;
        private final Set<Integer> stateIds;

        MerkleStates(Map<Integer, StateMetadata<?, ?>> stateMetadata) {
            this.stateMetadata = Objects.requireNonNull(stateMetadata);
            this.stateIds = Collections.unmodifiableSet(stateMetadata.keySet());
            this.kvInstances = new HashMap();
            this.singletonInstances = new HashMap();
            this.queueInstances = new HashMap();
        }

        @NonNull
        public <K, V> ReadableKVState<K, V> get(int stateId) {
            ReadableKVState<?, ?> instance = this.kvInstances.get(stateId);
            if (instance != null) {
                return instance;
            }
            StateMetadata<?, ?> md = this.stateMetadata.get(stateId);
            if (md == null || md.stateDefinition().singleton()) {
                throw new IllegalArgumentException("Unknown k/v state ID '%d'".formatted(stateId));
            }
            MerkleNode node = this.findNode(md);
            if (node instanceof VirtualMap) {
                VirtualMap v = (VirtualMap)node;
                ReadableKVState ret = this.createReadableKVState(md, v);
                this.kvInstances.put(stateId, ret);
                return ret;
            }
            throw new IllegalStateException("Unexpected type for k/v state %d".formatted(stateId));
        }

        @NonNull
        public <S> ReadableSingletonState<S> getSingleton(int stateId) {
            ReadableSingletonState<?> instance = this.singletonInstances.get(stateId);
            if (instance != null) {
                return instance;
            }
            StateMetadata<?, ?> md = this.stateMetadata.get(stateId);
            if (md == null || !md.stateDefinition().singleton()) {
                throw new IllegalArgumentException("Unknown singleton state ID '%d'".formatted(stateId));
            }
            MerkleNode node = this.findNode(md);
            if (node instanceof SingletonNode) {
                SingletonNode s = (SingletonNode)node;
                ReadableSingletonState ret = this.createReadableSingletonState(md, s);
                this.singletonInstances.put(stateId, ret);
                return ret;
            }
            throw new IllegalStateException("Unexpected type for singleton state %d".formatted(stateId));
        }

        @NonNull
        public <E> ReadableQueueState<E> getQueue(int stateId) {
            ReadableQueueState<?> instance = this.queueInstances.get(stateId);
            if (instance != null) {
                return instance;
            }
            StateMetadata<?, ?> md = this.stateMetadata.get(stateId);
            if (md == null || !md.stateDefinition().queue()) {
                throw new IllegalArgumentException("Unknown queue state ID '%d'".formatted(stateId));
            }
            MerkleNode node = this.findNode(md);
            if (node instanceof QueueNode) {
                QueueNode q = (QueueNode)node;
                ReadableQueueState ret = this.createReadableQueueState(md, q);
                this.queueInstances.put(stateId, ret);
                return ret;
            }
            throw new IllegalStateException("Unexpected type for queue state %d".formatted(stateId));
        }

        public boolean contains(int stateId) {
            return this.stateMetadata.containsKey(stateId);
        }

        @NonNull
        public Set<Integer> stateIds() {
            return this.stateIds;
        }

        @NonNull
        protected abstract ReadableKVState createReadableKVState(@NonNull StateMetadata var1, @NonNull VirtualMap var2);

        @NonNull
        protected abstract ReadableSingletonState createReadableSingletonState(@NonNull StateMetadata var1, @NonNull SingletonNode<?> var2);

        @NonNull
        protected abstract ReadableQueueState createReadableQueueState(@NonNull StateMetadata var1, @NonNull QueueNode<?> var2);

        @NonNull
        MerkleNode findNode(@NonNull StateMetadata<?, ?> md) {
            int index = MerkleStateRoot.this.findNodeIndex(md.serviceName(), md.stateDefinition().stateKey());
            if (index == -1) {
                throw new IllegalStateException("State '" + md.stateDefinition().stateKey() + "' for service '" + md.serviceName() + "' is missing from the merkle tree!");
            }
            return MerkleStateRoot.this.getChild(index);
        }
    }
}

