/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility.internal.primitive;

import java.util.Collection;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.iterator.IntIterator;

public final class IntIteratorIterate {
    private IntIteratorIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static void forEach(IntIterator iterator, IntProcedure procedure) {
        while (iterator.hasNext()) {
            procedure.value(iterator.next());
        }
    }

    public static <R extends MutableIntCollection> R select(IntIterator iterator, IntPredicate predicate, R targetCollection) {
        while (iterator.hasNext()) {
            int item = iterator.next();
            if (!predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <R extends MutableIntCollection> R reject(IntIterator iterator, IntPredicate predicate, R targetCollection) {
        while (iterator.hasNext()) {
            int item = iterator.next();
            if (predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <V, R extends Collection<V>> R collect(IntIterator iterator, IntToObjectFunction<? extends V> function, R targetCollection) {
        while (iterator.hasNext()) {
            int item = iterator.next();
            targetCollection.add((Object)function.valueOf(item));
        }
        return targetCollection;
    }

    public static int detectIfNone(IntIterator iterator, IntPredicate predicate, int ifNone) {
        while (iterator.hasNext()) {
            int item = iterator.next();
            if (!predicate.accept(item)) continue;
            return item;
        }
        return ifNone;
    }

    public static int count(IntIterator iterator, IntPredicate predicate) {
        int count = 0;
        while (iterator.hasNext()) {
            if (!predicate.accept(iterator.next())) continue;
            ++count;
        }
        return count;
    }

    public static boolean anySatisfy(IntIterator iterator, IntPredicate predicate) {
        while (iterator.hasNext()) {
            if (!predicate.accept(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean allSatisfy(IntIterator iterator, IntPredicate predicate) {
        while (iterator.hasNext()) {
            if (predicate.accept(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean noneSatisfy(IntIterator iterator, IntPredicate predicate) {
        while (iterator.hasNext()) {
            if (!predicate.accept(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static <T> T injectInto(IntIterator iterator, T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        while (iterator.hasNext()) {
            result = function.valueOf(result, iterator.next());
        }
        return result;
    }

    public static long sum(IntIterator iterator) {
        long sum = 0L;
        while (iterator.hasNext()) {
            sum += (long)iterator.next();
        }
        return sum;
    }

    public static int max(IntIterator iterator) {
        int max = iterator.next();
        while (iterator.hasNext()) {
            int next = iterator.next();
            if (max >= next) continue;
            max = next;
        }
        return max;
    }

    public static int min(IntIterator iterator) {
        int min = iterator.next();
        while (iterator.hasNext()) {
            int next = iterator.next();
            if (next >= min) continue;
            min = next;
        }
        return min;
    }
}

