/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.test.fixtures;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class TestBase {
    public static final String CAPITALS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final Set<String> WORDS;
    protected final Random rand = new Random(9239992L);

    @NonNull
    public final Random random() {
        return this.rand;
    }

    @NonNull
    public final Bytes randomBytes(int length) {
        return Bytes.wrap((byte[])TestBase.randomBytes(this.rand, length));
    }

    @NonNull
    public final byte[] randomByteArray(int length) {
        byte[] data = new byte[length];
        for (int i = 0; i < length; ++i) {
            data[i] = (byte)this.rand.nextInt();
        }
        return data;
    }

    public Set<String> words() {
        return WORDS;
    }

    public List<String> randomWords(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n must be non-negative, was " + n);
        }
        ArrayList<String> randomWords = new ArrayList<String>(WORDS);
        Collections.shuffle(randomWords, this.rand);
        return Collections.unmodifiableList(randomWords.subList(0, n));
    }

    @NonNull
    public String randomString(int length) {
        return this.randomString(CAPITALS, length);
    }

    @NonNull
    public String randomString(@NonNull String alphabet, int length) {
        return TestBase.randomString(this.rand, alphabet, length);
    }

    @NonNull
    public static String randomString(@NonNull Random generator, @NonNull String alphabet, int length) {
        assert (!alphabet.isBlank());
        assert (length >= 0);
        byte[] buf = new byte[length];
        for (int i = 0; i < length; ++i) {
            buf[i] = (byte)alphabet.charAt(generator.nextInt(alphabet.length()));
        }
        return new String(buf);
    }

    @NonNull
    public static byte[] randomBytes(@NonNull Random generator, int length) {
        assert (length >= 0);
        byte[] data = new byte[length];
        for (int i = 0; i < length; ++i) {
            data[i] = (byte)generator.nextInt();
        }
        return data;
    }

    static {
        HashSet<String> words = new HashSet<String>();
        try (InputStream input = TestBase.class.getResourceAsStream("wordlist.txt");){
            String word;
            assert (input != null) : "Missing wordlist.txt";
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            while ((word = reader.readLine()) != null) {
                words.add(word);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load word list!", e);
        }
        WORDS = Collections.unmodifiableSet(words);
    }
}

