/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.internal.network.codec;

import com.hedera.hapi.block.stream.MerkleSiblingHash;
import com.hedera.node.internal.network.PendingProof;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class PendingProofJsonCodec
implements JsonCodec<PendingProof> {
    @NonNull
    public PendingProof parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            long temp_block = 0L;
            Bytes temp_block_hash = Bytes.EMPTY;
            Bytes temp_start_of_block_state_root_hash = Bytes.EMPTY;
            Bytes temp_previous_block_hash = Bytes.EMPTY;
            List temp_sibling_hashes_from_prev_block_root = Collections.emptyList();
            block16: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "block": {
                        temp_block = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block16;
                    }
                    case "blockHash": {
                        temp_block_hash = Bytes.fromBase64((String)JsonTools.checkSize((String)"block_hash", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block16;
                    }
                    case "startOfBlockStateRootHash": {
                        temp_start_of_block_state_root_hash = Bytes.fromBase64((String)JsonTools.checkSize((String)"start_of_block_state_root_hash", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block16;
                    }
                    case "previousBlockHash": {
                        temp_previous_block_hash = Bytes.fromBase64((String)JsonTools.checkSize((String)"previous_block_hash", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block16;
                    }
                    case "siblingHashesFromPrevBlockRoot": {
                        temp_sibling_hashes_from_prev_block_root = JsonTools.parseObjArray((List)JsonTools.checkSize((String)"sibling_hashes_from_prev_block_root", (List)kvPair.value().arr().value(), (int)maxSize), MerkleSiblingHash.JSON, (int)(maxDepth - 1), (int)maxSize);
                        continue block16;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new PendingProof(temp_block, temp_block_hash, temp_start_of_block_state_root_hash, temp_previous_block_hash, temp_sibling_hashes_from_prev_block_root);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull PendingProof data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.block() != 0L) {
            fieldLines.add(JsonTools.field((String)"block", (long)data.block()));
        }
        if (data.blockHash() != Bytes.EMPTY && data.blockHash() != null && data.blockHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"blockHash", (Bytes)data.blockHash()));
        }
        if (data.startOfBlockStateRootHash() != Bytes.EMPTY && data.startOfBlockStateRootHash() != null && data.startOfBlockStateRootHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"startOfBlockStateRootHash", (Bytes)data.startOfBlockStateRootHash()));
        }
        if (data.previousBlockHash() != Bytes.EMPTY && data.previousBlockHash() != null && data.previousBlockHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"previousBlockHash", (Bytes)data.previousBlockHash()));
        }
        if (!data.siblingHashesFromPrevBlockRoot().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"siblingHashesFromPrevBlockRoot", MerkleSiblingHash.JSON, data.siblingHashesFromPrevBlockRoot()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

