/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.base.test.fixtures.time;

import com.swirlds.base.time.Time;
import java.time.Duration;
import java.time.Instant;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicLong;

public class FakeTime
implements Time {
    private static final int DEFAULT_YEAR = 2018;
    private static final int DEFAULT_MONTH = 7;
    private static final int DEFAULT_DATE = 25;
    private static final int DEFAULT_HOUR_OF_DAY = 1;
    private static final int DEFAULT_MINUTE = 24;
    private static final int DEFAULT_SECOND = 9;
    private static final int DEFAULT_MILLIS_TO_ADD = 693;
    private static final Instant DEFAULT_START;
    private final Instant start;
    private final long autoIncrement;
    private final AtomicLong elapsedNanos = new AtomicLong(0L);

    public FakeTime() {
        this(DEFAULT_START, Duration.ZERO);
    }

    public FakeTime(Duration autoIncrement) {
        this(Instant.now(), autoIncrement);
    }

    public FakeTime(Instant start, Duration autoIncrement) {
        this.start = start;
        this.autoIncrement = autoIncrement.toNanos();
    }

    public long nanoTime() {
        return this.elapsedNanos.getAndAdd(this.autoIncrement);
    }

    public long currentTimeMillis() {
        return (long)((double)this.start.toEpochMilli() + (double)this.nanoTime() * 1.0E-6);
    }

    public Instant now() {
        return this.start.plusNanos(this.nanoTime());
    }

    public void tick() {
        this.tick(1L);
    }

    public void tick(long nanos) {
        if (nanos < 0L) {
            throw new IllegalStateException("clock can only move forward");
        }
        this.elapsedNanos.getAndAdd(nanos);
    }

    public void tick(Duration time) {
        this.tick(time.toNanos());
    }

    @Deprecated
    public void set(Duration elapsedSinceStart) {
        this.elapsedNanos.set(elapsedSinceStart.toNanos());
    }

    public void reset() {
        this.elapsedNanos.set(0L);
    }

    public Duration elapsed() {
        return Duration.between(this.start, this.now());
    }

    static {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.set(2018, 7, 25, 1, 24, 9);
        DEFAULT_START = calendar.toInstant().plusMillis(693L);
    }
}

