/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime.io.buffer;

import com.hedera.pbj.runtime.hashing.XXH3_64;
import com.hedera.pbj.runtime.io.DataEncodingException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.UnsafeUtils;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.buffer.RandomAccessSequenceAdapter;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Comparator;
import java.util.HexFormat;
import java.util.Objects;

public final class Bytes
implements RandomAccessData,
Comparable<Bytes> {
    public static final Bytes EMPTY = new Bytes(new byte[0]);
    public static final Comparator<Bytes> SORT_BY_LENGTH = (o1, o2) -> Comparator.comparingLong(Bytes::length).compare((Bytes)o1, (Bytes)o2);
    public static final Comparator<Bytes> SORT_BY_SIGNED_VALUE = Bytes.valueSorter(Byte::compare);
    public static final Comparator<Bytes> SORT_BY_UNSIGNED_VALUE = Bytes.valueSorter(Byte::compareUnsigned);
    private final byte[] buffer;
    private final int start;
    private final int length;
    private int hashCode = 0;

    private Bytes(@NonNull byte[] data) {
        this(data, 0, data.length);
    }

    private Bytes(@NonNull byte[] data, int offset, int length) {
        this.buffer = Objects.requireNonNull(data);
        this.start = offset;
        this.length = length;
        if (offset < 0 || offset > data.length) {
            throw new IndexOutOfBoundsException("Offset " + offset + " is out of bounds for buffer of length " + data.length);
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length " + length + " is negative");
        }
        if (offset + length > data.length) {
            throw new IllegalArgumentException("Length " + length + " is too large buffer of length " + data.length + " starting at offset " + offset);
        }
    }

    @NonNull
    public static Bytes wrap(@NonNull byte[] byteArray) {
        return new Bytes(byteArray);
    }

    @NonNull
    public static Bytes wrap(@NonNull byte[] byteArray, int offset, int length) {
        return new Bytes(byteArray, offset, length);
    }

    @NonNull
    public static Bytes wrap(@NonNull String string) {
        return new Bytes(string.getBytes(StandardCharsets.UTF_8));
    }

    @NonNull
    public static Bytes fromBase64(@NonNull String string) {
        return new Bytes(Base64.getDecoder().decode(string));
    }

    @NonNull
    public static Bytes fromHex(@NonNull String string) {
        return new Bytes(HexFormat.of().parseHex(string.toLowerCase()));
    }

    @NonNull
    public static Bytes merge(@NonNull Bytes bytes1, @NonNull Bytes bytes2) {
        byte[] array = new byte[bytes1.length + bytes2.length];
        System.arraycopy(bytes1.buffer, bytes1.start, array, 0, bytes1.length);
        System.arraycopy(bytes2.buffer, bytes2.start, array, bytes1.length, bytes2.length);
        return new Bytes(array);
    }

    public static int indexOf(@NonNull Bytes haystack, @NonNull Bytes needle) {
        Objects.requireNonNull(haystack);
        Objects.requireNonNull(needle);
        int nLen = (int)needle.length();
        int hLen = (int)haystack.length();
        if (nLen == 0) {
            return 0;
        }
        if (nLen > hLen) {
            return -1;
        }
        byte[] hBuf = haystack.buffer;
        byte[] nBuf = needle.buffer;
        int hBase = haystack.start;
        int nBase = needle.start;
        int hLast = hBase + hLen - nLen;
        byte first = nBuf[nBase];
        for (int i = hBase; i <= hLast; ++i) {
            if (hBuf[i] != first || Arrays.mismatch(hBuf, i, i + nLen, nBuf, nBase, nBase + nLen) >= 0) continue;
            return i - hBase;
        }
        return -1;
    }

    @Override
    public int getInt(long offset) {
        return this.getInt(offset, ByteOrder.BIG_ENDIAN);
    }

    @Override
    public int getInt(long offset, @NonNull ByteOrder byteOrder) {
        return UnsafeUtils.getInt(this.buffer, Math.toIntExact((long)this.start + offset), byteOrder);
    }

    @Override
    public long getLong(long offset) {
        return this.getLong(offset, ByteOrder.BIG_ENDIAN);
    }

    @Override
    public long getLong(long offset, @NonNull ByteOrder byteOrder) {
        return UnsafeUtils.getLong(this.buffer, Math.toIntExact((long)this.start + offset), byteOrder);
    }

    @NonNull
    public Bytes replicate() {
        byte[] bytes = new byte[this.length];
        System.arraycopy(this.buffer, this.start, bytes, 0, this.length);
        return new Bytes(bytes, 0, this.length);
    }

    public boolean contains(@NonNull Bytes needle) {
        Objects.requireNonNull(needle);
        return Bytes.indexOf(this, needle) >= 0;
    }

    public void writeTo(@NonNull ByteBuffer dstBuffer) {
        dstBuffer.put(this.buffer, this.start, this.length);
    }

    public void writeTo(@NonNull ByteBuffer dstBuffer, int offset, int length) {
        dstBuffer.put(this.buffer, Math.toIntExact(this.start + offset), length);
    }

    public int writeTo(@NonNull byte[] dst, int dstOffset) {
        System.arraycopy(this.buffer, this.start, dst, dstOffset, this.length);
        return this.length;
    }

    @Override
    public void writeTo(@NonNull OutputStream outStream) {
        try {
            outStream.write(this.buffer, this.start, this.length);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeTo(@NonNull OutputStream outStream, int offset, int length) {
        try {
            outStream.write(this.buffer, Math.toIntExact(this.start + offset), length);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void writeTo(@NonNull WritableSequentialData wsd) {
        wsd.writeBytes(this.buffer, this.start, this.length);
    }

    public void writeTo(@NonNull WritableSequentialData wsd, int offset, int length) {
        wsd.writeBytes(this.buffer, Math.toIntExact(this.start + offset), length);
    }

    @Override
    public void writeTo(@NonNull MessageDigest digest) {
        digest.update(this.buffer, this.start, this.length);
    }

    public void writeTo(@NonNull MessageDigest digest, int offset, int length) {
        digest.update(this.buffer, Math.toIntExact(this.start + offset), length);
    }

    public void updateSignature(@NonNull Signature signature) throws SignatureException {
        signature.update(this.buffer, this.start, this.length);
    }

    public void updateSignature(@NonNull Signature signature, int offset, int length) throws SignatureException {
        this.validateOffsetLength(offset, length);
        signature.update(this.buffer, this.calculateOffset(offset), length);
    }

    public boolean verifySignature(@NonNull Signature signature) throws SignatureException {
        return signature.verify(this.buffer, this.start, this.length);
    }

    public boolean verifySignature(@NonNull Signature signature, int offset, int length) throws SignatureException {
        this.validateOffsetLength(offset, length);
        return signature.verify(this.buffer, this.calculateOffset(offset), length);
    }

    @NonNull
    public ReadableSequentialData toReadableSequentialData() {
        return new RandomAccessSequenceAdapter(this);
    }

    @NonNull
    public InputStream toInputStream() {
        return new InputStream(){
            private long pos = 0L;

            @Override
            public int read() throws IOException {
                if ((long)Bytes.this.length - this.pos <= 0L) {
                    return -1;
                }
                try {
                    return Bytes.this.getUnsignedByte(this.pos++);
                }
                catch (UncheckedIOException e) {
                    throw e.getCause();
                }
            }
        };
    }

    @Override
    public int compareTo(Bytes otherData) {
        int minLength = Math.min(this.length, otherData.length);
        for (int i = 0; i < minLength; ++i) {
            int compare = Byte.compareUnsigned(this.getByte(i), otherData.getByte(i));
            if (compare == 0) continue;
            return compare;
        }
        return Integer.compare(this.length, otherData.length);
    }

    @NonNull
    public String toString() {
        return HexFormat.of().formatHex(this.buffer, this.start, this.start + this.length);
    }

    public String toBase64() {
        if (this.start == 0 && this.buffer.length == this.length) {
            return Base64.getEncoder().encodeToString(this.buffer);
        }
        byte[] bytes = new byte[this.length];
        this.getBytes(0L, bytes);
        return Base64.getEncoder().encodeToString(bytes);
    }

    public String toHex() {
        return HexFormat.of().formatHex(this.buffer, this.start, this.start + this.length);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Bytes)) {
            return false;
        }
        Bytes that = (Bytes)o;
        return Arrays.equals(this.buffer, this.start, this.start + this.length, that.buffer, that.start, that.start + that.length);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = (int)XXH3_64.DEFAULT_INSTANCE.hashBytesToLong(this.buffer, this.start, this.length);
        }
        return this.hashCode;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public byte getByte(long offset) {
        if (this.length == 0) {
            throw new BufferUnderflowException();
        }
        this.validateOffset(offset);
        return this.buffer[Math.toIntExact((long)this.start + offset)];
    }

    @Override
    public long getBytes(long offset, @NonNull byte[] dst, int dstOffset, int maxLength) {
        if (maxLength < 0) {
            throw new IllegalArgumentException("Negative maxLength not allowed");
        }
        long len = Math.min((long)maxLength, (long)this.length - offset);
        if (len == 0L) {
            return 0L;
        }
        this.validateOffset(offset);
        System.arraycopy(this.buffer, Math.toIntExact((long)this.start + offset), dst, dstOffset, Math.toIntExact(len));
        return len;
    }

    @Override
    public long getBytes(long offset, @NonNull ByteBuffer dst) {
        long len = Math.min((long)dst.remaining(), this.length() - offset);
        if (len == 0L) {
            return 0L;
        }
        this.validateOffset(offset);
        dst.put(this.buffer, Math.toIntExact((long)this.start + offset), Math.toIntExact(len));
        return len;
    }

    @Override
    public long getBytes(long offset, @NonNull BufferedData dst) {
        long len = Math.min(dst.remaining(), this.length() - offset);
        if (len == 0L) {
            return 0L;
        }
        this.validateOffset(offset);
        dst.writeBytes(this.buffer, Math.toIntExact((long)this.start + offset), Math.toIntExact(len));
        return len;
    }

    @Override
    @NonNull
    public Bytes getBytes(long offset, long len) {
        if (len < 0L) {
            throw new IllegalArgumentException("Negative len not allowed");
        }
        if (this.length() - offset < len) {
            throw new BufferUnderflowException();
        }
        if (len == 0L) {
            return EMPTY;
        }
        this.validateOffset(offset);
        return new Bytes(this.buffer, Math.toIntExact((long)this.start + offset), Math.toIntExact(len));
    }

    @Override
    @NonNull
    public String asUtf8String(long offset, long len) {
        if (len < 0L) {
            throw new IllegalArgumentException("Negative len not allowed");
        }
        if (this.length() - offset < len) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0L) {
            return "";
        }
        this.validateOffset(offset);
        return new String(this.buffer, Math.toIntExact((long)this.start + offset), Math.toIntExact(len), StandardCharsets.UTF_8);
    }

    @Override
    public boolean contains(long offset, @NonNull byte[] bytes) {
        int len = bytes.length;
        if (this.length() - offset < (long)len) {
            return false;
        }
        this.validateOffset(offset);
        return Arrays.equals(this.buffer, Math.toIntExact((long)this.start + offset), Math.toIntExact((long)this.start + offset + (long)len), bytes, 0, len);
    }

    @Override
    @NonNull
    public Bytes slice(long offset, long length) {
        return this.getBytes(offset, length);
    }

    @NonNull
    public byte[] toByteArray() {
        return this.toByteArray(0, this.length);
    }

    @NonNull
    public byte[] toByteArray(int offset, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("Negative len not allowed");
        }
        byte[] ret = new byte[len];
        this.getBytes((long)offset, ret);
        return ret;
    }

    private void validateOffset(long offset) {
        if (offset < 0L || offset >= (long)this.length) {
            throw new IndexOutOfBoundsException("offset=" + offset + ", length=" + this.length);
        }
    }

    private void validateOffsetLength(long suppliedOffset, long suppliedLength) {
        if (suppliedOffset < 0L || suppliedLength < 0L) {
            throw new IllegalArgumentException("Negative length or offset not allowed");
        }
        if (suppliedOffset + suppliedLength > (long)this.length) {
            throw new IndexOutOfBoundsException("The offset(%d) and length(%d) provided are out of bounds for this Bytes object, which has a length of %d".formatted(suppliedOffset, suppliedLength, this.length));
        }
    }

    private int calculateOffset(long suppliedOffset) {
        return Math.toIntExact((long)this.start + suppliedOffset);
    }

    private static Comparator<Bytes> valueSorter(@NonNull Comparator<Byte> byteComparator) {
        return (o1, o2) -> {
            long val = Math.min(o1.length(), o2.length());
            for (long i = 0L; i < val; ++i) {
                int byteComparison = byteComparator.compare(o1.getByte(i), o2.getByte(i));
                if (byteComparison == 0) continue;
                return byteComparison;
            }
            long len = o1.length() - o2.length();
            if (len == 0L) {
                return 0;
            }
            return len > 0L ? 1 : -1;
        };
    }

    @NonNull
    public Bytes append(@NonNull Bytes bytes) {
        long length = this.length();
        byte[] newBytes = new byte[(int)(length + (long)((int)bytes.length()))];
        this.getBytes(0L, newBytes, 0, (int)length);
        bytes.getBytes(0L, newBytes, (int)length, (int)bytes.length());
        return Bytes.wrap(newBytes);
    }

    @NonNull
    public Bytes append(@NonNull RandomAccessData data) {
        byte[] newBytes = new byte[(int)(this.length() + (long)((int)data.length()))];
        int length1 = (int)this.length();
        this.getBytes(0L, newBytes, 0, length1);
        data.getBytes(0L, newBytes, length1, (int)data.length());
        return Bytes.wrap(newBytes);
    }

    @Override
    public int getVarInt(long offset, boolean zigZag) {
        return (int)this.getVar(Math.toIntExact(offset), zigZag);
    }

    @Override
    public long getVarLong(long offset, boolean zigZag) {
        return this.getVar(Math.toIntExact(offset), zigZag);
    }

    private long getVar(int offset, boolean zigZag) {
        if (offset < 0 || offset >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        int rem = this.start + this.length - (offset += this.start);
        if (rem > 10) {
            rem = 10;
        }
        long value = 0L;
        for (int i = 0; i != rem; ++i) {
            byte b = UnsafeUtils.getArrayByteNoChecks(this.buffer, offset + i);
            value |= (long)(b & 0x7F) << i * 7;
            if (b < 0) continue;
            return zigZag ? value >>> 1 ^ -(value & 1L) : value;
        }
        throw new DataEncodingException("Malformed var int");
    }
}

