/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.editor;

import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.route.MerkleRoute;
import com.swirlds.common.merkle.route.MerkleRouteUtils;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.state.editor.StateEditorOperation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="resize", mixinStandardHelpOptions=true, description={"Change the number of children in an internal node."})
public class StateEditorResize
extends StateEditorOperation {
    private static final Logger logger = LogManager.getLogger(StateEditorResize.class);
    private String parentPath = "";
    private int newSize;

    @CommandLine.Parameters(index="0", description={"The new size of the parent."})
    private void setNewSize(int newSize) {
        this.newSize = newSize;
    }

    @CommandLine.Parameters(index="1", arity="0..1", description={"The route of the parent will be resized."})
    private void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    @Override
    public void run() {
        MerkleNode parent = this.getStateEditor().getRelativeNode(this.parentPath);
        if (parent == null) {
            throw new IllegalArgumentException("The node at " + this.parentPath + " is null.");
        }
        if (!(parent instanceof MerkleInternal)) {
            throw new IllegalArgumentException("The node at " + this.parentPath + " is of type " + parent.getClass().getSimpleName() + " and is not an internal node.");
        }
        if (logger.isInfoEnabled(LogMarker.CLI.getMarker())) {
            logger.info(LogMarker.CLI.getMarker(), "Resizing [{} {}] to child count {}", (Object)MerkleRouteUtils.merkleRouteToPathFormat((MerkleRoute)parent.getRoute()), (Object)parent.getClass().getSimpleName(), (Object)this.newSize);
        }
    }
}

