/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.merkle.map;

import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.impl.PartialNaryMerkleInternal;
import com.swirlds.demo.merkle.map.MapValueData;
import com.swirlds.demo.merkle.map.MapValueFCQ;
import com.swirlds.merkle.map.MerkleMap;
import com.swirlds.merkle.test.fixtures.map.lifecycle.EntityType;
import com.swirlds.merkle.test.fixtures.map.pta.MapKey;
import com.swirlds.merkle.test.fixtures.map.pta.TransactionRecord;
import java.util.Map;

public class FCMFamily
extends PartialNaryMerkleInternal
implements MerkleInternal {
    public static final long CLASS_ID = 4789266076140235797L;

    public int getNumberOfChildren() {
        return 2;
    }

    public int getMinimumChildCount() {
        return 2;
    }

    public int getMaximumChildCount() {
        return 2;
    }

    public boolean childHasExpectedType(int index, long childClassId) {
        switch (index) {
            case 0: 
            case 1: {
                return childClassId == -7776220400278906634L;
            }
        }
        return false;
    }

    public MerkleMap<MapKey, MapValueData> getMap() {
        return (MerkleMap)this.getChild(0);
    }

    public void setMap(MerkleMap<MapKey, MapValueData> map) {
        this.setChild(0, (MerkleNode)map);
    }

    public MerkleMap<MapKey, MapValueFCQ<TransactionRecord>> getAccountFCQMap() {
        return (MerkleMap)this.getChild(1);
    }

    public void setAccountFCQMap(MerkleMap<MapKey, MapValueFCQ<TransactionRecord>> accountFCQMap) {
        this.setChild(1, (MerkleNode)accountFCQMap);
    }

    public FCMFamily() {
    }

    public FCMFamily(boolean initChildren) {
        if (initChildren) {
            this.setMap((MerkleMap<MapKey, MapValueData>)new MerkleMap());
            this.setAccountFCQMap((MerkleMap<MapKey, MapValueFCQ<TransactionRecord>>)new MerkleMap());
        }
    }

    private FCMFamily(FCMFamily other) {
        super((PartialNaryMerkleInternal)other);
        this.setMap((MerkleMap<MapKey, MapValueData>)other.getMap().copy());
        this.setAccountFCQMap((MerkleMap<MapKey, MapValueFCQ<TransactionRecord>>)other.getAccountFCQMap().copy());
        this.setImmutable(false);
        other.setImmutable(true);
    }

    public FCMFamily copy() {
        this.throwIfImmutable();
        this.throwIfDestroyed();
        return new FCMFamily(this);
    }

    public Map<MapKey, ? extends MerkleNode> getActualMap(EntityType entityType) {
        switch (entityType) {
            case Crypto: {
                return this.getMap();
            }
            case FCQ: {
                return this.getAccountFCQMap();
            }
        }
        throw new IllegalArgumentException("Unknown EntityType: " + String.valueOf(entityType));
    }

    public long getTotalCount() {
        return this.getMap().size() + this.getAccountFCQMap().size();
    }

    public long getClassId() {
        return 4789266076140235797L;
    }

    public int getVersion() {
        return 2;
    }

    public int getMinimumSupportedVersion() {
        return 2;
    }

    private static class ChildIndices {
        public static final int MAP = 0;
        public static final int ACCOUNT_FCQ_MAP = 1;
        public static final int CHILD_COUNT = 2;

        private ChildIndices() {
        }
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;
        public static final int MIGRATE_TO_SERIALIZABLE = 2;

        private ClassVersion() {
        }
    }
}

