/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.crypto;

import com.swirlds.platform.crypto.CryptoStatic;
import com.swirlds.platform.crypto.KeyCertPurpose;
import com.swirlds.platform.crypto.KeyGeneratingException;
import com.swirlds.platform.crypto.KeyLoadingException;
import com.swirlds.platform.crypto.PublicStores;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.hiero.base.crypto.internal.DetRandomProvider;
import org.hiero.consensus.crypto.CryptoConstants;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.roster.RosterUtils;

public class KeysAndCertsGenerator {
    private static final int SIG_SEED = 2;
    private static final int AGR_SEED = 0;

    private KeysAndCertsGenerator() {
    }

    public static KeysAndCerts loadExistingAndCreateAgrKeyIfMissing(NodeId nodeId, char[] password, KeyStore privateKeyStore, PublicStores publicStores) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyLoadingException, NoSuchProviderException, KeyGeneratingException {
        X509Certificate agreementCert;
        KeyPair agreementKeyPair;
        String signingName = KeyCertPurpose.SIGNING.storeName(nodeId);
        KeyPair signingKeyPair = KeysAndCertsGenerator.getKeyPair(privateKeyStore, password, signingName);
        X509Certificate signingCert = publicStores.getCertificate(KeyCertPurpose.SIGNING, nodeId);
        String agreementName = KeyCertPurpose.AGREEMENT.storeName(nodeId);
        try {
            agreementKeyPair = KeysAndCertsGenerator.getKeyPair(privateKeyStore, password, agreementName);
            agreementCert = publicStores.getCertificate(KeyCertPurpose.AGREEMENT, nodeId);
        }
        catch (KeyLoadingException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            agreementKeyPair = KeysAndCertsGenerator.generateAgreementKeyPair();
            String dnA = CryptoStatic.distinguishedName(KeyCertPurpose.AGREEMENT.storeName(nodeId));
            agreementCert = CryptoStatic.generateCertificate(dnA, agreementKeyPair, signingCert.getSubjectX500Principal().getName(), signingKeyPair, SecureRandom.getInstanceStrong());
            publicStores.setCertificate(KeyCertPurpose.AGREEMENT, agreementCert, nodeId);
        }
        return new KeysAndCerts(signingKeyPair, agreementKeyPair, signingCert, agreementCert);
    }

    private static KeyPair getKeyPair(KeyStore privateKeyStore, char[] password, String storeName) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyLoadingException {
        Certificate certificate = privateKeyStore.getCertificate(storeName);
        if (certificate == null) {
            throw new KeyLoadingException(String.format("Certificate '%s' not found!", storeName));
        }
        Key privateKey = privateKeyStore.getKey(storeName, password);
        if (privateKey instanceof PrivateKey) {
            PrivateKey pk = (PrivateKey)privateKey;
            return new KeyPair(certificate.getPublicKey(), pk);
        }
        throw new KeyLoadingException(String.format("Key '%s' is not an instance of PrivateKey!", storeName));
    }

    public static KeysAndCerts generate(NodeId nodeId, byte[] masterKey, byte[] swirldId, byte[] memberId, PublicStores publicStores) throws NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException, KeyGeneratingException {
        SecureRandom sigDetRandom = DetRandomProvider.getDetRandom();
        sigDetRandom.setSeed(masterKey);
        sigDetRandom.setSeed(swirldId);
        sigDetRandom.setSeed(memberId);
        sigDetRandom.setSeed(2L);
        SecureRandom agrDetRandom = DetRandomProvider.getDetRandom();
        agrDetRandom.setSeed(masterKey);
        agrDetRandom.setSeed(swirldId);
        agrDetRandom.setSeed(memberId);
        agrDetRandom.setSeed(0L);
        KeysAndCerts keysAndCerts = KeysAndCertsGenerator.generate(nodeId, sigDetRandom, agrDetRandom);
        publicStores.setCertificate(KeyCertPurpose.SIGNING, keysAndCerts.sigCert(), nodeId);
        publicStores.setCertificate(KeyCertPurpose.AGREEMENT, keysAndCerts.agrCert(), nodeId);
        return keysAndCerts;
    }

    @NonNull
    public static KeysAndCerts generate(@NonNull NodeId nodeId, @NonNull SecureRandom sigDetRandom, @NonNull SecureRandom agrDetRandom) throws NoSuchAlgorithmException, NoSuchProviderException, KeyGeneratingException {
        KeyPairGenerator sigKeyGen = KeyPairGenerator.getInstance("RSA", CryptoConstants.SIG_PROVIDER);
        KeyPairGenerator agrKeyGen = KeyPairGenerator.getInstance("EC", "SunEC");
        sigKeyGen.initialize(3072, sigDetRandom);
        agrKeyGen.initialize(384, agrDetRandom);
        KeyPair sigKeyPair = sigKeyGen.generateKeyPair();
        KeyPair agrKeyPair = agrKeyGen.generateKeyPair();
        String nodeName = RosterUtils.formatNodeName((NodeId)nodeId);
        String dnS = CryptoStatic.distinguishedName("s-" + nodeName);
        String dnA = CryptoStatic.distinguishedName("a-" + nodeName);
        X509Certificate sigCert = CryptoStatic.generateCertificate(dnS, sigKeyPair, dnS, sigKeyPair, sigDetRandom);
        X509Certificate agrCert = CryptoStatic.generateCertificate(dnA, agrKeyPair, dnS, sigKeyPair, agrDetRandom);
        return new KeysAndCerts(sigKeyPair, agrKeyPair, sigCert, agrCert);
    }

    @NonNull
    public static KeyPair generateAgreementKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException {
        SecureRandom secureRandom = SecureRandom.getInstanceStrong();
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC", "SunEC");
        keyPairGenerator.initialize(384, secureRandom);
        return keyPairGenerator.generateKeyPair();
    }
}

