/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.consensus.framework;

import com.swirlds.common.utility.Threshold;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ConsensusTestUtils {
    @NonNull
    public static Set<Integer> getStrongMinorityNodes(@NonNull List<Long> nodeStakes) {
        HashSet<Integer> partitionedNodes = new HashSet<Integer>();
        long totalStake = nodeStakes.stream().reduce(0L, Long::sum);
        long partitionedStake = 0L;
        for (int i = 0; i < nodeStakes.size() && !Threshold.STRONG_MINORITY.isSatisfiedBy(partitionedStake, totalStake); ++i) {
            if (Threshold.SUPER_MAJORITY.isSatisfiedBy(partitionedStake + nodeStakes.get(i), totalStake)) continue;
            partitionedNodes.add(i);
            partitionedStake += nodeStakes.get(i).longValue();
        }
        System.out.println("Partitioned nodes: " + String.valueOf(partitionedNodes));
        System.out.printf("\nPartition has %s (%s%%) of %s total stake.%n", partitionedStake, (double)partitionedStake / (double)totalStake * 100.0, totalStake);
        return partitionedNodes;
    }

    @NonNull
    public static Set<Integer> getSubStrongMinorityNodes(@NonNull List<Long> nodeStakes) {
        HashSet<Integer> partitionedNodes = new HashSet<Integer>();
        long totalStake = nodeStakes.stream().reduce(0L, Long::sum);
        long partitionedStake = 0L;
        for (int i = 0; i < nodeStakes.size() && partitionedNodes.size() + 2 != nodeStakes.size(); ++i) {
            if (Threshold.STRONG_MINORITY.isSatisfiedBy(partitionedStake + nodeStakes.get(i), totalStake)) continue;
            partitionedNodes.add(i);
            partitionedStake += nodeStakes.get(i).longValue();
        }
        System.out.println("Partitioned nodes: " + String.valueOf(partitionedNodes));
        System.out.printf("\nPartition has %s (%s%%) of %s total stake.%n", partitionedStake, (double)partitionedStake / (double)totalStake * 100.0, totalStake);
        return partitionedNodes;
    }
}

