/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.schedulers.builders;

import com.swirlds.component.framework.schedulers.builders.TaskSchedulerConfigOption;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;

public record TaskSchedulerConfiguration(@Nullable TaskSchedulerType type, @Nullable Long unhandledTaskCapacity, @Nullable Boolean unhandledTaskMetricEnabled, @Nullable Boolean busyFractionMetricEnabled, @Nullable Boolean flushingEnabled, @Nullable Boolean squelchingEnabled) {
    public static final TaskSchedulerConfiguration NO_OP_CONFIGURATION = new TaskSchedulerConfiguration(TaskSchedulerType.NO_OP, 0L, false, false, false, false);
    public static final TaskSchedulerConfiguration DIRECT_CONFIGURATION = new TaskSchedulerConfiguration(TaskSchedulerType.DIRECT, 0L, false, false, false, false);
    public static final TaskSchedulerConfiguration DIRECT_THREADSAFE_CONFIGURATION = new TaskSchedulerConfiguration(TaskSchedulerType.DIRECT_THREADSAFE, 0L, false, false, false, false);

    @NonNull
    public static TaskSchedulerConfiguration parse(@NonNull String string) {
        String[] parts;
        TaskSchedulerType type = null;
        Long unhandledTaskCapacity = null;
        Boolean unhandledTaskMetricEnabled = null;
        Boolean busyFractionMetricEnabled = null;
        Boolean flushingEnabled = null;
        Boolean squelchingEnabled = null;
        for (String part : parts = string.split(" ")) {
            String strippedPart = part.strip();
            if (strippedPart.isEmpty()) continue;
            TaskSchedulerType parsedType = TaskSchedulerConfiguration.tryToParseTaskSchedulerType(strippedPart);
            if (parsedType != null) {
                if (type != null) {
                    throw new IllegalArgumentException("Multiple task scheduler types specified: " + string);
                }
                type = parsedType;
                continue;
            }
            Long parsedCapacity = TaskSchedulerConfiguration.tryToParseCapacity(strippedPart);
            if (parsedCapacity != null) {
                if (unhandledTaskCapacity != null) {
                    throw new IllegalArgumentException("Multiple capacities specified: " + string);
                }
                unhandledTaskCapacity = parsedCapacity;
                continue;
            }
            Boolean parsedUnhandledTaskMetric = TaskSchedulerConfiguration.tryToParseOption(TaskSchedulerConfigOption.UNHANDLED_TASK_METRIC, strippedPart);
            if (parsedUnhandledTaskMetric != null) {
                if (unhandledTaskMetricEnabled != null) {
                    throw new IllegalArgumentException("Multiple unhandled task metric configurations specified: " + string);
                }
                unhandledTaskMetricEnabled = parsedUnhandledTaskMetric;
                continue;
            }
            Boolean parsedBusyFractionMetric = TaskSchedulerConfiguration.tryToParseOption(TaskSchedulerConfigOption.BUSY_FRACTION_METRIC, strippedPart);
            if (parsedBusyFractionMetric != null) {
                if (busyFractionMetricEnabled != null) {
                    throw new IllegalArgumentException("Multiple busy fraction metric configurations specified: " + string);
                }
                busyFractionMetricEnabled = parsedBusyFractionMetric;
                continue;
            }
            Boolean parsedFlushing = TaskSchedulerConfiguration.tryToParseOption(TaskSchedulerConfigOption.FLUSHABLE, strippedPart);
            if (parsedFlushing != null) {
                if (flushingEnabled != null) {
                    throw new IllegalArgumentException("Multiple flushing configurations specified: " + string);
                }
                flushingEnabled = parsedFlushing;
                continue;
            }
            Boolean parsedSquelching = TaskSchedulerConfiguration.tryToParseOption(TaskSchedulerConfigOption.SQUELCHABLE, strippedPart);
            if (parsedSquelching != null) {
                if (squelchingEnabled != null) {
                    throw new IllegalArgumentException("Multiple squelching configurations specified: " + string);
                }
                squelchingEnabled = parsedSquelching;
                continue;
            }
            throw new IllegalArgumentException("Invalid task scheduler configuration: " + part);
        }
        return new TaskSchedulerConfiguration(type, unhandledTaskCapacity, unhandledTaskMetricEnabled, busyFractionMetricEnabled, flushingEnabled, squelchingEnabled);
    }

    @Nullable
    private static TaskSchedulerType tryToParseTaskSchedulerType(@NonNull String string) {
        try {
            return TaskSchedulerType.valueOf(string);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Nullable
    private static Long tryToParseCapacity(@NonNull String string) {
        if (string.startsWith("CAPACITY")) {
            try {
                int openParenIndex = string.indexOf(40);
                int closeParenIndex = string.indexOf(41);
                if (openParenIndex == -1 || closeParenIndex == -1) {
                    throw new IllegalArgumentException("Invalid capacity \"" + string + "\"");
                }
                String capacityString = string.substring(openParenIndex + 1, closeParenIndex);
                return Long.parseLong(capacityString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid capacity \"" + string + "\"", e);
            }
        }
        return null;
    }

    @Nullable
    private static Boolean tryToParseOption(@NonNull TaskSchedulerConfigOption option, @NonNull String string) {
        if (string.equals(option.toString())) {
            return true;
        }
        if (string.equals("!" + String.valueOf((Object)option))) {
            return false;
        }
        return null;
    }
}

