/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.merkle.dummy;

import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.impl.PartialNaryMerkleInternal;
import com.swirlds.common.test.fixtures.merkle.dummy.DummyMerkleNode;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;

public class DummyMerkleInternal
extends PartialNaryMerkleInternal
implements DummyMerkleNode,
MerkleInternal {
    private final String value;
    private static final long CLASS_ID = 2255827090L;
    public static final int CLASS_VERSION = 1;
    private Integer overridingClassVersion = null;
    private boolean initialized;
    private final AtomicBoolean released = new AtomicBoolean(false);
    private static BiFunction<DummyMerkleInternal, Integer, MerkleNode> migrationMapper = (node, version) -> node;

    public DummyMerkleInternal(String value) {
        this.value = value;
        this.initialized = false;
    }

    public DummyMerkleInternal() {
        this("?");
        this.initialized = false;
    }

    private DummyMerkleInternal(DummyMerkleInternal that) {
        super((PartialNaryMerkleInternal)that);
        this.initialized = that.initialized;
        this.value = that.value;
    }

    public static void setMigrationMapper(BiFunction<DummyMerkleInternal, Integer, MerkleNode> migrationMapper) {
        DummyMerkleInternal.migrationMapper = migrationMapper;
    }

    public static void resetMigrationMapper() {
        migrationMapper = (node, version) -> node;
    }

    public void rebuild() {
        if (this.initialized) {
            throw new RuntimeException("Node should only be initialized once.");
        }
        int numberOfChildren = this.getNumberOfChildren();
        for (int childIndex = 0; childIndex < numberOfChildren; ++childIndex) {
            DummyMerkleInternal internalChild;
            MerkleNode child = this.getChild(childIndex);
            if (!(child instanceof DummyMerkleNode) || !child.isInternal() || (internalChild = (DummyMerkleInternal)child).isInitialized()) continue;
            throw new RuntimeException("Children must be initialized before their parents.");
        }
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public long getClassId() {
        return 2255827090L;
    }

    public int getVersion() {
        if (this.overridingClassVersion != null) {
            return this.overridingClassVersion;
        }
        return 1;
    }

    public void setVersion(int version) {
        this.overridingClassVersion = version;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(this.value);
        sb.append("](");
        for (int childIndex = 0; childIndex < this.getNumberOfChildren(); ++childIndex) {
            MerkleNode next = this.getChild(childIndex);
            sb.append(" ");
            String str = next == null ? "null" : next.toString();
            sb.append(str);
            sb.append(" ");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public boolean isLeaf() {
        return false;
    }

    public void destroyNode() {
        if (!this.released.compareAndSet(false, true)) {
            throw new IllegalStateException("This type of node should only be deleted once");
        }
    }

    public DummyMerkleInternal copy() {
        return new DummyMerkleInternal(this);
    }

    public MerkleNode migrate(int version) {
        return migrationMapper.apply(this, version);
    }
}

