/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.merkle.dummy;

import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.impl.PartialMerkleLeaf;
import com.swirlds.common.test.fixtures.merkle.dummy.DummyMerkleNode;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import org.hiero.base.crypto.Hash;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.junit.jupiter.api.Assertions;

public class DummyMerkleLeaf
extends PartialMerkleLeaf
implements DummyMerkleNode,
MerkleLeaf {
    protected String value;
    private static final long CLASS_ID = 140989193L;
    public static final int CLASS_VERSION = 1;
    private Integer overridingClassVersion = null;
    private boolean throwWhenHashed = false;
    private boolean allowDuplicateHashing;
    private AtomicBoolean released = new AtomicBoolean(false);
    private static BiFunction<DummyMerkleLeaf, Integer, MerkleNode> migrationMapper = (node, version) -> node;

    public DummyMerkleLeaf() {
        this("?");
    }

    public DummyMerkleLeaf(String value) {
        this(value, false);
    }

    public DummyMerkleLeaf(String value, boolean allowDuplicateHashing) {
        if (value.length() > 1024) {
            throw new RuntimeException("Value must not exceed 1024 characters");
        }
        this.value = value;
        this.allowDuplicateHashing = allowDuplicateHashing;
    }

    public DummyMerkleLeaf enableDuplicateHashing() {
        this.allowDuplicateHashing = true;
        return this;
    }

    public static void setMigrationMapper(BiFunction<DummyMerkleLeaf, Integer, MerkleNode> migrationMapper) {
        DummyMerkleLeaf.migrationMapper = migrationMapper;
    }

    public static void resetMigrationMapper() {
        migrationMapper = (node, version) -> node;
    }

    private DummyMerkleLeaf(DummyMerkleLeaf that) {
        super((PartialMerkleLeaf)that);
        this.value = that.value;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeNormalisedString(this.value);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.value = in.readNormalisedString(1024);
    }

    public long getClassId() {
        return 140989193L;
    }

    public int getVersion() {
        if (this.overridingClassVersion != null) {
            return this.overridingClassVersion;
        }
        return 1;
    }

    public void setVersion(int version) {
        this.overridingClassVersion = version;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void destroyNode() {
        if (!this.released.compareAndSet(false, true)) {
            throw new IllegalStateException("This type of node should only be deleted once");
        }
    }

    public void setHash(Hash hash) {
        if (!this.allowDuplicateHashing && this.getHash() != null && hash != null) {
            Assertions.fail((String)"Hash should not be set if value is already known");
        }
        if (this.throwWhenHashed) {
            throw new RuntimeException("this node intentionally fails when it is hashed");
        }
        super.setHash(hash);
    }

    public void setThrowWhenHashed(boolean throwWhenHashed) {
        this.throwWhenHashed = throwWhenHashed;
    }

    public String toString() {
        return this.value;
    }

    public DummyMerkleLeaf copy() {
        this.throwIfImmutable();
        this.throwIfDestroyed();
        this.setImmutable(true);
        return new DummyMerkleLeaf(this);
    }

    public int hashCode() {
        if (this.value == null) {
            return 0;
        }
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DummyMerkleLeaf)) {
            return false;
        }
        DummyMerkleLeaf that = (DummyMerkleLeaf)obj;
        return Objects.equals(this.value, that.value);
    }

    public MerkleNode migrate(int version) {
        return migrationMapper.apply(this, version);
    }
}

