/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gossip.shadowgraph;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.platform.gossip.IntakeEventCounter;
import com.swirlds.platform.gossip.permits.SyncGuard;
import com.swirlds.platform.gossip.permits.SyncGuardFactory;
import com.swirlds.platform.gossip.rpc.GossipRpcSender;
import com.swirlds.platform.gossip.shadowgraph.AbstractShadowgraphSynchronizer;
import com.swirlds.platform.gossip.shadowgraph.RpcPeerHandler;
import com.swirlds.platform.gossip.shadowgraph.Shadowgraph;
import com.swirlds.platform.gossip.sync.config.SyncConfig;
import com.swirlds.platform.metrics.SyncMetrics;
import com.swirlds.platform.reconnect.FallenBehindMonitor;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.function.Consumer;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.node.NodeId;

public class RpcShadowgraphSynchronizer
extends AbstractShadowgraphSynchronizer {
    private final NodeId selfId;
    private final Duration sleepAfterSync;
    private final SyncGuard syncGuard;

    public RpcShadowgraphSynchronizer(@NonNull PlatformContext platformContext, int numberOfNodes, @NonNull SyncMetrics syncMetrics, @NonNull Consumer<PlatformEvent> receivedEventHandler, @NonNull FallenBehindMonitor fallenBehindMonitor, @NonNull IntakeEventCounter intakeEventCounter, @NonNull NodeId selfId, @NonNull Consumer<Double> syncLagHandler) {
        super(platformContext, new Shadowgraph(platformContext, numberOfNodes, intakeEventCounter), numberOfNodes, syncMetrics, receivedEventHandler, fallenBehindMonitor, intakeEventCounter, syncLagHandler);
        SyncConfig syncConfig = (SyncConfig)platformContext.getConfiguration().getConfigData(SyncConfig.class);
        this.selfId = selfId;
        this.sleepAfterSync = syncConfig.rpcSleepAfterSync();
        this.syncGuard = SyncGuardFactory.create(syncConfig.fairMaxConcurrentSyncs(), syncConfig.fairMinimalRoundRobinSize(), numberOfNodes);
    }

    public RpcPeerHandler createPeerHandler(@NonNull GossipRpcSender sender, @NonNull NodeId otherNodeId) {
        RpcPeerHandler rpcPeerHandler = new RpcPeerHandler(this, sender, this.selfId, otherNodeId, this.sleepAfterSync, this.syncMetrics, this.time, this.intakeEventCounter, this.eventHandler, this.syncGuard, this.fallenBehindMonitor);
        return rpcPeerHandler;
    }

    public void deregisterPeerHandler(RpcPeerHandler rpcPeerHandler) {
    }
}

