/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.crypto;

import edu.umd.cs.findbugs.annotations.NonNull;

public enum SigningSchema {
    RSA("RSA", 3072, "SHA384withRSA"),
    EC("EC", 384, "SHA384withECDSA"),
    ED25519("Ed25519", 255, "Ed25519");

    private final String keyType;
    private final String signingAlgorithm;
    private final int keySizeBits;

    private SigningSchema(@NonNull String keyType, int keySizeBits, String signingAlgorithm) {
        this.keyType = keyType;
        this.signingAlgorithm = signingAlgorithm;
        this.keySizeBits = keySizeBits;
    }

    @NonNull
    public String getKeyType() {
        return this.keyType;
    }

    @NonNull
    public String getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public int getKeySizeBits() {
        return this.keySizeBits;
    }
}

