/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.cli;

import com.swirlds.cli.commands.StateCommand;
import com.swirlds.cli.utility.AbstractCommand;
import com.swirlds.cli.utility.SubcommandOf;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.config.DefaultConfiguration;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.state.signed.SignedStateComparison;
import com.swirlds.platform.state.snapshot.SignedStateFileReader;
import com.swirlds.platform.util.BootstrapUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="compare", mixinStandardHelpOptions=true, description={"Compare two signed states for differences. Useful for debugging ISS incidents."})
@SubcommandOf(value=StateCommand.class)
public final class CompareStatesCommand
extends AbstractCommand {
    private static final Logger logger = LogManager.getLogger(CompareStatesCommand.class);
    private Path stateAPath;
    private Path stateBPath;
    private int nodeLimit = 100;
    private boolean deepComparison = false;
    private List<Path> configurationPaths = List.of();

    private CompareStatesCommand() {
    }

    @CommandLine.Option(names={"-c", "--config"}, description={"A path to where a configuration file can be found. If not provided then defaults are used."})
    private void setConfigurationPath(List<Path> configurationPaths) {
        configurationPaths.forEach(x$0 -> this.pathMustExist((Path)x$0));
        this.configurationPaths = configurationPaths;
    }

    @CommandLine.Parameters(description={"the path to the first state dir that is being compared"})
    private void setStateAPath(Path stateAPath) {
        this.stateAPath = this.pathMustExist(stateAPath.toAbsolutePath());
    }

    @CommandLine.Parameters(description={"the path to the second state dir that is being compared"})
    private void setStateBPath(Path stateBPath) {
        this.stateBPath = this.pathMustExist(stateBPath.toAbsolutePath());
    }

    @CommandLine.Option(names={"--limit"}, description={"the maximum number of mismatched merkle nodes to print"})
    private void setNodeLimit(int nodeLimit) {
        if (nodeLimit <= 0) {
            throw new CommandLine.ParameterException(this.getSpec().commandLine(), "node limit must be non-zero positive");
        }
        this.nodeLimit = nodeLimit;
    }

    @CommandLine.Option(names={"--deep"}, description={"if set then do a deep comparison of the states, useful if internal hashes have been corrupted"})
    private void setDeepComparison(boolean deepComparison) {
        this.deepComparison = deepComparison;
    }

    private static ReservedSignedState loadAndHashState(@NonNull PlatformContext platformContext, @NonNull Path stateDirPath) throws IOException {
        Objects.requireNonNull(platformContext);
        Objects.requireNonNull(stateDirPath);
        logger.info(LogMarker.CLI.getMarker(), "Loading state from {}", (Object)stateDirPath);
        ReservedSignedState signedState = SignedStateFileReader.readState(stateDirPath, virtualMap -> {
            throw new UnsupportedOperationException();
        }, PlatformStateFacade.DEFAULT_PLATFORM_STATE_FACADE, platformContext).reservedSignedState();
        logger.info(LogMarker.CLI.getMarker(), "Hashing state");
        try {
            platformContext.getMerkleCryptography().digestTreeAsync(signedState.get().getState().getRoot()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("unable to hash state", e);
        }
        return signedState;
    }

    public Integer call() throws IOException {
        BootstrapUtils.setupConstructableRegistry();
        Configuration configuration = DefaultConfiguration.buildBasicConfiguration(ConfigurationBuilder.create(), FileUtils.getAbsolutePath((String)"settings.txt"), this.configurationPaths);
        PlatformContext platformContext = PlatformContext.create((Configuration)configuration);
        try (ReservedSignedState stateA = CompareStatesCommand.loadAndHashState(platformContext, this.stateAPath);
             ReservedSignedState stateB = CompareStatesCommand.loadAndHashState(platformContext, this.stateBPath);){
            SignedStateComparison.printMismatchedNodes(SignedStateComparison.mismatchedNodeIterator(stateA.get().getState().getRoot(), stateB.get().getState().getRoot(), this.deepComparison), this.nodeLimit);
        }
        return 0;
    }
}

