/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.api.extensions.event;

import com.swirlds.logging.api.Level;
import com.swirlds.logging.api.Marker;
import com.swirlds.logging.api.extensions.event.LogEvent;
import com.swirlds.logging.api.extensions.event.LogMessage;
import com.swirlds.logging.api.internal.event.SimpleLogMessage;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;

public interface LogEventFactory {
    @NonNull
    public LogEvent createLogEvent(@NonNull Level var1, @NonNull String var2, @NonNull String var3, long var4, @NonNull LogMessage var6, @Nullable Throwable var7, @Nullable Marker var8, @Nullable Map<String, String> var9);

    @NonNull
    default public LogEvent createLogEvent(@NonNull Level level, @NonNull String loggerName, @NonNull LogMessage message, @Nullable Throwable throwable, @Nullable Marker marker, @NonNull Map<String, String> context) {
        return this.createLogEvent(level, loggerName, Thread.currentThread().getName(), System.currentTimeMillis(), message, throwable, marker, context);
    }

    @NonNull
    default public LogEvent createLogEvent(@NonNull Level level, @NonNull String loggerName, @NonNull String threadName, long timestamp, @NonNull String message, @Nullable Throwable throwable, @Nullable Marker marker, @NonNull Map<String, String> context) {
        return this.createLogEvent(level, loggerName, threadName, timestamp, new SimpleLogMessage(message), throwable, marker, context);
    }

    @NonNull
    default public LogEvent createLogEvent(@NonNull Level level, @NonNull String loggerName, @NonNull String message) {
        return this.createLogEvent(level, loggerName, message, null);
    }

    @NonNull
    default public LogEvent createLogEvent(@NonNull Level level, @NonNull String loggerName, @NonNull String message, @Nullable Throwable throwable) {
        return this.createLogEvent(level, loggerName, Thread.currentThread().getName(), System.currentTimeMillis(), new SimpleLogMessage(message), throwable, null, Map.of());
    }
}

