/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.dummy;

import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.impl.PartialMerkleLeaf;
import com.swirlds.common.merkle.utility.Keyed;
import com.swirlds.common.test.fixtures.dummy.Key;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Random;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class Value
extends PartialMerkleLeaf
implements Keyed<Key>,
MerkleLeaf {
    private static final Random RANDOM = new SecureRandom();
    private static final long CLASS_ID = 9090742840909292089L;
    private Key key;
    private long balance;
    private long sendThresholdValue;
    private long receiveThresholdValue;
    private boolean receiverSignatureRequired;

    public Value() {
    }

    Value(ValueBuilder valueBuilder) {
        this.balance = valueBuilder.balance;
        this.sendThresholdValue = valueBuilder.sendThresholdValue;
        this.receiveThresholdValue = valueBuilder.receiveThresholdValue;
        this.receiverSignatureRequired = valueBuilder.receiveSignatureRequired;
    }

    public Value(long balance, long sendThresholdValue, long receiveThresholdValue, boolean receiverSignatureRequired) {
        this.balance = balance;
        this.sendThresholdValue = sendThresholdValue;
        this.receiveThresholdValue = receiveThresholdValue;
        this.receiverSignatureRequired = receiverSignatureRequired;
    }

    private Value(Value sourceValue) {
        super((PartialMerkleLeaf)sourceValue);
        this.balance = sourceValue.balance;
        this.sendThresholdValue = sourceValue.sendThresholdValue;
        this.receiveThresholdValue = sourceValue.receiveThresholdValue;
        this.receiverSignatureRequired = sourceValue.receiverSignatureRequired;
        if (sourceValue.key != null) {
            this.key = sourceValue.key.copy();
        }
        this.setImmutable(false);
        sourceValue.setImmutable(true);
    }

    public Key getKey() {
        return this.key;
    }

    public void setKey(Key key) {
        this.key = key;
    }

    public void setBalance(long balance) {
        this.balance = balance;
    }

    public void setSendThresholdValue(long sendThresholdValue) {
        this.sendThresholdValue = sendThresholdValue;
    }

    public void setReceiveThresholdValue(long receiveThresholdValue) {
        this.receiveThresholdValue = receiveThresholdValue;
    }

    public void setReceiverSignatureRequired(boolean receiverSignatureRequired) {
        this.receiverSignatureRequired = receiverSignatureRequired;
    }

    public static ValueBuilder newBuilder() {
        return new ValueBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        Value value = (Value)((Object)o);
        return this.balance == value.balance && this.sendThresholdValue == value.sendThresholdValue && this.receiveThresholdValue == value.receiveThresholdValue && this.receiverSignatureRequired == value.receiverSignatureRequired;
    }

    public int hashCode() {
        return Objects.hash(this.balance, this.sendThresholdValue, this.receiveThresholdValue, this.receiverSignatureRequired);
    }

    public String toString() {
        return "Value{balance=" + this.balance + ", sendThresholdValue=" + this.sendThresholdValue + ", receiveThresholdValue=" + this.receiveThresholdValue + ", receiverSignatureRequired=" + this.receiverSignatureRequired + "}";
    }

    public long getBalance() {
        return this.balance;
    }

    public long getSendThresholdValue() {
        return this.sendThresholdValue;
    }

    public long getReceiveThresholdValue() {
        return this.receiveThresholdValue;
    }

    public boolean isReceiverSignatureRequired() {
        return this.receiverSignatureRequired;
    }

    public Value copy() {
        this.throwIfImmutable();
        return new Value(this);
    }

    public static Value buildRandomValue() {
        return ValueBuilder.buildRandomValue();
    }

    public int getVersion() {
        return 10;
    }

    public int getMinimumSupportedVersion() {
        return 10;
    }

    public void serialize(SerializableDataOutputStream outStream) throws IOException {
        outStream.writeLong(this.balance);
        outStream.writeLong(this.sendThresholdValue);
        outStream.writeLong(this.receiveThresholdValue);
        outStream.writeByte(this.receiverSignatureRequired ? 1 : 0);
        outStream.writeSerializable((SelfSerializable)this.key, false);
    }

    public void deserialize(SerializableDataInputStream inStream, int version) throws IOException {
        this.balance = inStream.readLong();
        this.sendThresholdValue = inStream.readLong();
        this.receiveThresholdValue = inStream.readLong();
        this.receiverSignatureRequired = inStream.readByte() == 1;
        this.key = (Key)inStream.readSerializable(false, Key::new);
    }

    public long getClassId() {
        return 9090742840909292089L;
    }

    public static class ValueBuilder {
        private long balance;
        private long sendThresholdValue;
        private long receiveThresholdValue;
        private boolean receiveSignatureRequired;

        public static Value buildRandomValue() {
            return new ValueBuilder().setSendThresholdvalue(RANDOM.nextLong()).setBalance(RANDOM.nextLong()).setReceiveThresholdValue(RANDOM.nextLong()).setReceiveSignatureRequired(RANDOM.nextBoolean()).build();
        }

        ValueBuilder() {
        }

        public ValueBuilder setBalance(long balance) {
            this.balance = balance;
            return this;
        }

        public ValueBuilder setSendThresholdvalue(long sendThresholdValue) {
            this.sendThresholdValue = sendThresholdValue;
            return this;
        }

        public ValueBuilder setReceiveThresholdValue(long receiveThresholdValue) {
            this.receiveThresholdValue = receiveThresholdValue;
            return this;
        }

        public ValueBuilder setReceiveSignatureRequired(boolean receiveSignatureRequired) {
            this.receiveSignatureRequired = receiveSignatureRequired;
            return this;
        }

        public Value build() {
            return new Value(this);
        }
    }

    private static class ClassVersion {
        public static final int CURRENT = 10;

        private ClassVersion() {
        }
    }
}

