/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.wiring.components;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.component.framework.model.WiringModel;
import com.swirlds.component.framework.schedulers.TaskScheduler;
import com.swirlds.component.framework.wires.input.BindableInputWire;
import com.swirlds.component.framework.wires.input.InputWire;
import com.swirlds.component.framework.wires.output.OutputWire;
import com.swirlds.component.framework.wires.output.StandardOutputWire;
import com.swirlds.platform.wiring.NoInput;
import com.swirlds.platform.wiring.PlatformSchedulersConfig;
import com.swirlds.platform.wiring.components.Gossip;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.gossip.SyncProgress;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.status.PlatformStatus;

public class GossipWiring {
    private final WiringModel model;
    private final TaskScheduler<Void> scheduler;
    private final BindableInputWire<PlatformEvent, Void> eventInput;
    private final BindableInputWire<EventWindow, Void> eventWindowInput;
    private final StandardOutputWire<PlatformEvent> eventOutput;
    private final StandardOutputWire<SyncProgress> syncProgressOutput;
    private final BindableInputWire<NoInput, Void> startInput;
    private final BindableInputWire<NoInput, Void> stopInput;
    private final BindableInputWire<NoInput, Void> clearInput;
    private final BindableInputWire<Duration, Void> systemHealthInput;
    private final BindableInputWire<PlatformStatus, Void> platformStatusInput;
    private final BindableInputWire<NoInput, Void> pauseInput;
    private final BindableInputWire<NoInput, Void> resumeInput;

    public GossipWiring(@NonNull PlatformContext platformContext, @NonNull WiringModel model) {
        this.model = model;
        this.scheduler = model.schedulerBuilder("gossip").configure(((PlatformSchedulersConfig)platformContext.getConfiguration().getConfigData(PlatformSchedulersConfig.class)).gossip()).build();
        this.eventInput = this.scheduler.buildInputWire("events to gossip");
        this.eventWindowInput = this.scheduler.buildInputWire("event window");
        this.eventOutput = this.scheduler.buildSecondaryOutputWire();
        this.syncProgressOutput = this.scheduler.buildSecondaryOutputWire();
        this.startInput = this.scheduler.buildInputWire("start");
        this.stopInput = this.scheduler.buildInputWire("stop");
        this.clearInput = this.scheduler.buildInputWire("clear");
        this.systemHealthInput = this.scheduler.buildInputWire("health info");
        this.platformStatusInput = this.scheduler.buildInputWire("PlatformStatus");
        this.pauseInput = this.scheduler.buildInputWire("pause");
        this.resumeInput = this.scheduler.buildInputWire("resume");
    }

    public void bind(@NonNull Gossip gossip) {
        gossip.bind(this.model, this.eventInput, this.eventWindowInput, this.eventOutput, this.startInput, this.stopInput, this.clearInput, this.pauseInput, this.resumeInput, this.systemHealthInput, this.platformStatusInput, this.syncProgressOutput);
    }

    @NonNull
    public InputWire<PlatformEvent> getEventInput() {
        return this.eventInput;
    }

    @NonNull
    public InputWire<EventWindow> getEventWindowInput() {
        return this.eventWindowInput;
    }

    @NonNull
    public OutputWire<PlatformEvent> getEventOutput() {
        return this.eventOutput;
    }

    public OutputWire<SyncProgress> getSyncProgressOutput() {
        return this.syncProgressOutput;
    }

    @NonNull
    public InputWire<NoInput> getStartInput() {
        return this.startInput;
    }

    @NonNull
    public InputWire<NoInput> getStopInput() {
        return this.stopInput;
    }

    @NonNull
    public InputWire<NoInput> pauseInput() {
        return this.pauseInput;
    }

    @NonNull
    public InputWire<NoInput> resumeInput() {
        return this.resumeInput;
    }

    @NonNull
    public InputWire<NoInput> getClearInput() {
        return this.clearInput;
    }

    @NonNull
    public InputWire<Duration> getSystemHealthInput() {
        return this.systemHealthInput;
    }

    @NonNull
    public InputWire<PlatformStatus> getPlatformStatusInput() {
        return this.platformStatusInput;
    }

    public void flush() {
        this.scheduler.flush();
    }
}

