/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.consistency;

import com.hedera.hapi.node.state.primitives.ProtoLong;
import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.hedera.pbj.runtime.ParseException;
import com.swirlds.config.api.Configuration;
import com.swirlds.demo.consistency.ConsistencyTestingToolRound;
import com.swirlds.demo.consistency.TransactionHandlingHistory;
import com.swirlds.demo.consistency.V0680ConsistencyTestingToolSchema;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.lifecycle.StateMetadata;
import com.swirlds.state.merkle.VirtualMapState;
import com.swirlds.state.merkle.disk.OnDiskWritableSingletonState;
import com.swirlds.state.spi.ReadableSingletonState;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.utility.ByteUtils;
import org.hiero.base.utility.NonCryptographicHashing;
import org.hiero.consensus.model.event.Event;
import org.hiero.consensus.model.hashgraph.Round;
import org.hiero.consensus.model.transaction.ConsensusTransaction;
import org.hiero.consensus.model.transaction.ScopedSystemTransaction;
import org.hiero.consensus.model.transaction.Transaction;

public class ConsistencyTestingToolState
extends VirtualMapState
implements MerkleNodeState {
    private static final Logger logger = LogManager.getLogger(ConsistencyTestingToolState.class);
    private long stateLong = 0L;
    private long roundsHandled = 0L;
    private final TransactionHandlingHistory transactionHandlingHistory;
    private final Set<Long> transactionsAwaitingPostHandle;

    public ConsistencyTestingToolState(@NonNull Configuration configuration, @NonNull Metrics metrics) {
        super(configuration, metrics);
        this.transactionHandlingHistory = new TransactionHandlingHistory();
        this.transactionsAwaitingPostHandle = ConcurrentHashMap.newKeySet();
        logger.info(LogMarker.STARTUP.getMarker(), "New State Constructed.");
    }

    public ConsistencyTestingToolState(@NonNull VirtualMap virtualMap, @NonNull Metrics metrics) {
        super(virtualMap, metrics);
        this.transactionHandlingHistory = new TransactionHandlingHistory();
        this.transactionsAwaitingPostHandle = ConcurrentHashMap.newKeySet();
        logger.info(LogMarker.STARTUP.getMarker(), "New State Constructed.");
    }

    private ConsistencyTestingToolState(@NonNull ConsistencyTestingToolState that) {
        super((VirtualMapState)Objects.requireNonNull(that));
        this.stateLong = that.stateLong;
        this.roundsHandled = that.roundsHandled;
        this.transactionHandlingHistory = that.transactionHandlingHistory;
        this.transactionsAwaitingPostHandle = that.transactionsAwaitingPostHandle;
    }

    @NonNull
    public VirtualMapState copy() {
        return new ConsistencyTestingToolState(this);
    }

    void initState(Path logFilePath) {
        ReadableSingletonState roundsHandledState;
        ProtoLong roundsHandledProto;
        V0680ConsistencyTestingToolSchema schema = new V0680ConsistencyTestingToolSchema();
        schema.statesToCreate().stream().sorted(Comparator.comparing(StateDefinition::stateId)).forEach(def -> super.initializeState(new StateMetadata("ConsistencyTestingToolService", def)));
        ReadableStates readableStates = this.getReadableStates("ConsistencyTestingToolService");
        ReadableSingletonState stateLongState = readableStates.getSingleton(1);
        ProtoLong stateLongProto = (ProtoLong)stateLongState.get();
        if (stateLongProto != null) {
            this.stateLong = stateLongProto.value();
            logger.info(LogMarker.STARTUP.getMarker(), "State initialized with state long {}.", (Object)this.stateLong);
        }
        if ((roundsHandledProto = (ProtoLong)(roundsHandledState = readableStates.getSingleton(2)).get()) != null) {
            this.roundsHandled = roundsHandledProto.value();
            logger.info(LogMarker.STARTUP.getMarker(), "State initialized with {} rounds handled.", (Object)this.roundsHandled);
        }
        this.transactionHandlingHistory.init(logFilePath);
    }

    long getRoundsHandled() {
        return this.roundsHandled;
    }

    void incrementRoundsHandled() {
        ++this.roundsHandled;
        WritableSingletonState roundsHandledState = this.getWritableStates("ConsistencyTestingToolService").getSingleton(2);
        roundsHandledState.put((Object)new ProtoLong(this.roundsHandled));
        ((OnDiskWritableSingletonState)roundsHandledState).commit();
    }

    long getStateLong() {
        return this.stateLong;
    }

    void setStateLong(long stateLong) {
        this.stateLong = stateLong;
        WritableSingletonState stateLongState = this.getWritableStates("ConsistencyTestingToolService").getSingleton(1);
        stateLongState.put((Object)new ProtoLong(stateLong));
        ((OnDiskWritableSingletonState)stateLongState).commit();
    }

    private void processRound(Round round) {
        this.stateLong = NonCryptographicHashing.hash64((long)this.stateLong, (long)round.getRoundNum());
        this.transactionHandlingHistory.processRound(ConsistencyTestingToolRound.fromRound(round, this.stateLong));
        this.setStateLong(this.stateLong);
    }

    void processTransactions(Round round, @NonNull Consumer<ScopedSystemTransaction<StateSignatureTransaction>> stateSignatureTransaction) {
        this.incrementRoundsHandled();
        round.forEachEventTransaction((ev, tx) -> {
            if (ConsistencyTestingToolState.isSystemTransaction((Transaction)tx)) {
                this.consumeSystemTransaction((Transaction)tx, (Event)ev, stateSignatureTransaction);
            } else {
                this.applyTransactionToState((ConsensusTransaction)tx);
            }
        });
        this.processRound(round);
    }

    void processPrehandle(Transaction transaction) {
        long transactionContents = ConsistencyTestingToolState.getTransactionContents(transaction);
        if (!this.transactionsAwaitingPostHandle.add(transactionContents)) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Transaction {} was prehandled more than once.", (Object)transactionContents);
        }
    }

    private void applyTransactionToState(@NonNull ConsensusTransaction transaction) {
        Objects.requireNonNull(transaction);
        long transactionContents = ConsistencyTestingToolState.getTransactionContents((Transaction)transaction);
        if (!this.transactionsAwaitingPostHandle.remove(transactionContents)) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Transaction {} was not prehandled.", (Object)transactionContents);
        }
        this.stateLong = NonCryptographicHashing.hash64((long)this.stateLong, (long)transactionContents);
        this.setStateLong(this.stateLong);
    }

    private static long getTransactionContents(Transaction transaction) {
        return ByteUtils.byteArrayToLong((byte[])transaction.getApplicationTransaction().toByteArray(), (int)0);
    }

    static boolean isSystemTransaction(@NonNull Transaction transaction) {
        return transaction.getApplicationTransaction().length() > 8L;
    }

    void consumeSystemTransaction(@NonNull Transaction transaction, @NonNull Event event, @NonNull Consumer<ScopedSystemTransaction<StateSignatureTransaction>> stateSignatureTransactionCallback) {
        try {
            StateSignatureTransaction stateSignatureTransaction = (StateSignatureTransaction)StateSignatureTransaction.PROTOBUF.parse(transaction.getApplicationTransaction());
            stateSignatureTransactionCallback.accept((ScopedSystemTransaction<StateSignatureTransaction>)new ScopedSystemTransaction(event.getCreatorId(), event.getBirthRound(), (Object)stateSignatureTransaction));
        }
        catch (ParseException e) {
            logger.error("Failed to parse StateSignatureTransaction", (Throwable)e);
        }
    }
}

