/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime.io.buffer;

import com.hedera.pbj.runtime.io.DataEncodingException;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;

public interface RandomAccessData {
    public long length();

    public byte getByte(long var1);

    default public int getUnsignedByte(long offset) {
        return Byte.toUnsignedInt(this.getByte(offset));
    }

    default public long getBytes(long offset, @NonNull byte[] dst) {
        return this.getBytes(offset, dst, 0, dst.length);
    }

    default public long getBytes(long offset, @NonNull byte[] dst, int dstOffset, int maxLength) {
        if (maxLength < 0) {
            throw new IllegalArgumentException("Negative maxLength not allowed");
        }
        long len = Math.min((long)maxLength, this.length() - offset);
        int i = 0;
        while ((long)i < len) {
            dst[dstOffset + i] = this.getByte(offset + (long)i);
            ++i;
        }
        return len;
    }

    default public long getBytes(long offset, @NonNull ByteBuffer dst) {
        long length = this.length();
        this.checkOffset(offset, length);
        long index = offset;
        while (dst.hasRemaining() && index < length) {
            dst.put(this.getByte(index++));
        }
        return index - offset;
    }

    default public long getBytes(long offset, @NonNull BufferedData dst) {
        long length = this.length();
        this.checkOffset(offset, length);
        long index = offset;
        while (dst.hasRemaining() && index < length) {
            dst.writeByte(this.getByte(index++));
        }
        return index - offset;
    }

    @NonNull
    default public Bytes getBytes(long offset, long length) {
        this.checkOffset(offset, this.length());
        if (length < 0L) {
            throw new IllegalArgumentException("Negative maxLength not allowed");
        }
        if (length > this.length() - offset) {
            throw new BufferUnderflowException();
        }
        if (length == 0L) {
            return Bytes.EMPTY;
        }
        byte[] buf = new byte[Math.toIntExact(length)];
        if (this.getBytes(offset, buf) != length) {
            throw new BufferUnderflowException();
        }
        return Bytes.wrap(buf);
    }

    @NonNull
    default public RandomAccessData slice(long offset, long length) {
        return this.getBytes(offset, length);
    }

    default public int getInt(long offset) {
        this.checkOffset(offset, this.length());
        if (this.length() - offset < 4L) {
            throw new BufferUnderflowException();
        }
        byte b1 = this.getByte(offset);
        byte b2 = this.getByte(offset + 1L);
        byte b3 = this.getByte(offset + 2L);
        byte b4 = this.getByte(offset + 3L);
        return (b1 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
    }

    default public int getInt(long offset, @NonNull ByteOrder byteOrder) {
        if (this.length() - offset < 4L) {
            throw new BufferUnderflowException();
        }
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            this.checkOffset(offset, this.length());
            byte b4 = this.getByte(offset);
            byte b3 = this.getByte(offset + 1L);
            byte b2 = this.getByte(offset + 2L);
            byte b1 = this.getByte(offset + 3L);
            return (b1 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
        }
        return this.getInt(offset);
    }

    default public long getUnsignedInt(long offset) {
        return (long)this.getInt(offset) & 0xFFFFFFFFL;
    }

    default public long getUnsignedInt(long offset, @NonNull ByteOrder byteOrder) {
        return (long)this.getInt(offset, byteOrder) & 0xFFFFFFFFL;
    }

    default public long getLong(long offset) {
        this.checkOffset(offset, this.length());
        if (this.length() - offset < 8L) {
            throw new BufferUnderflowException();
        }
        byte b1 = this.getByte(offset);
        byte b2 = this.getByte(offset + 1L);
        byte b3 = this.getByte(offset + 2L);
        byte b4 = this.getByte(offset + 3L);
        byte b5 = this.getByte(offset + 4L);
        byte b6 = this.getByte(offset + 5L);
        byte b7 = this.getByte(offset + 6L);
        byte b8 = this.getByte(offset + 7L);
        return ((long)b1 << 56) + ((long)(b2 & 0xFF) << 48) + ((long)(b3 & 0xFF) << 40) + ((long)(b4 & 0xFF) << 32) + ((long)(b5 & 0xFF) << 24) + (long)((b6 & 0xFF) << 16) + (long)((b7 & 0xFF) << 8) + (long)(b8 & 0xFF);
    }

    default public long getLong(long offset, @NonNull ByteOrder byteOrder) {
        if (this.length() - offset < 8L) {
            throw new BufferUnderflowException();
        }
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            this.checkOffset(offset, this.length());
            byte b8 = this.getByte(offset);
            byte b7 = this.getByte(offset + 1L);
            byte b6 = this.getByte(offset + 2L);
            byte b5 = this.getByte(offset + 3L);
            byte b4 = this.getByte(offset + 4L);
            byte b3 = this.getByte(offset + 5L);
            byte b2 = this.getByte(offset + 6L);
            byte b1 = this.getByte(offset + 7L);
            return ((long)b1 << 56) + ((long)(b2 & 0xFF) << 48) + ((long)(b3 & 0xFF) << 40) + ((long)(b4 & 0xFF) << 32) + ((long)(b5 & 0xFF) << 24) + (long)((b6 & 0xFF) << 16) + (long)((b7 & 0xFF) << 8) + (long)(b8 & 0xFF);
        }
        return this.getLong(offset);
    }

    default public float getFloat(long offset) {
        return Float.intBitsToFloat(this.getInt(offset));
    }

    default public float getFloat(long offset, @NonNull ByteOrder byteOrder) {
        return Float.intBitsToFloat(this.getInt(offset, byteOrder));
    }

    default public double getDouble(long offset) {
        return Double.longBitsToDouble(this.getLong(offset));
    }

    default public double getDouble(long offset, @NonNull ByteOrder byteOrder) {
        return Double.longBitsToDouble(this.getLong(offset, byteOrder));
    }

    default public int getVarInt(long offset, boolean zigZag) {
        return (int)this.getVarLong(Math.toIntExact(offset), zigZag);
    }

    default public long getVarLong(long offset, boolean zigZag) {
        long value = 0L;
        for (int i = 0; i < 10; ++i) {
            byte b = this.getByte(offset + (long)i);
            value |= (long)(b & 0x7F) << i * 7;
            if (b < 0) continue;
            return zigZag ? value >>> 1 ^ -(value & 1L) : value;
        }
        throw new DataEncodingException("Malformed var int");
    }

    @NonNull
    default public String asUtf8String() {
        return this.asUtf8String(0L, this.length());
    }

    @NonNull
    default public String asUtf8String(long offset, long len) {
        if (len == 0L) {
            return "";
        }
        this.checkOffset(offset, this.length());
        if (len > this.length() - offset) {
            throw new BufferUnderflowException();
        }
        byte[] data = new byte[Math.toIntExact(len)];
        this.getBytes(offset, data);
        return new String(data, StandardCharsets.UTF_8);
    }

    default public boolean matchesPrefix(@NonNull byte[] prefix) {
        return this.contains(0L, prefix);
    }

    default public boolean contains(long offset, @NonNull byte[] bytes) {
        this.checkOffset(offset, this.length());
        if (this.length() - offset < (long)bytes.length) {
            return false;
        }
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == this.getByte(offset + (long)i)) continue;
            return false;
        }
        return true;
    }

    default public boolean matchesPrefix(@NonNull RandomAccessData prefix) {
        return this.contains(0L, prefix);
    }

    default public boolean contains(long offset, @NonNull RandomAccessData data) {
        if (this.length() == 0L) {
            return data.length() == 0L;
        }
        this.checkOffset(offset, this.length());
        if (this.length() - offset < data.length()) {
            return false;
        }
        for (long i = offset; i < data.length(); ++i) {
            if (data.getByte(i) == this.getByte(i)) continue;
            return false;
        }
        return true;
    }

    public void writeTo(@NonNull OutputStream var1);

    public void writeTo(@NonNull OutputStream var1, int var2, int var3);

    default public void checkOffset(long offset) {
        if (offset < 0L) {
            throw new IndexOutOfBoundsException("offset " + offset + " is negative");
        }
    }

    default public void checkOffset(long offset, long length) {
        if (offset < 0L || offset >= length) {
            throw new IndexOutOfBoundsException("offset " + offset + " is out of bounds for length " + length);
        }
    }

    default public void checkOffsetToRead(long offset, long length, long dataLength) {
        if (offset < 0L || offset > length || offset == length && dataLength != 0L) {
            throw new IndexOutOfBoundsException("offset " + offset + " is out of bounds for length " + length);
        }
        if (offset > length - dataLength) {
            throw new BufferUnderflowException();
        }
    }

    default public void checkOffsetToWrite(long offset, long length, long dataLength) {
        if (offset < 0L || offset > length || offset == length && dataLength != 0L) {
            throw new IndexOutOfBoundsException("offset " + offset + " is out of bounds for length " + length);
        }
        if (offset > length - dataLength) {
            throw new BufferOverflowException();
        }
    }
}

