/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.swirldapp;

import com.swirlds.platform.swirldapp.AppLoaderException;
import com.swirlds.platform.system.SwirldMain;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.file.Path;
import org.hiero.base.constructable.URLClassLoaderWithLookup;

public class SwirldAppLoader {
    private String mainClassName;
    private Path appJarPath;
    private Constructor<?> appMainConstructor;
    private URLClassLoaderWithLookup classLoader;

    private SwirldAppLoader(String mainClassName, Path appJarPath, Constructor<?> appMainConstructor, URLClassLoaderWithLookup classLoader) {
        this.mainClassName = mainClassName;
        this.appJarPath = appJarPath;
        this.appMainConstructor = appMainConstructor;
        this.classLoader = classLoader;
    }

    public SwirldMain instantiateSwirldMain() throws AppLoaderException {
        try {
            return (SwirldMain)this.appMainConstructor.newInstance(new Object[0]);
        }
        catch (InstantiationException | InvocationTargetException e) {
            throw new AppLoaderException("ERROR: Couldn't instantiate the class " + this.mainClassName, e);
        }
        catch (IllegalAccessException e) {
            throw new AppLoaderException("ERROR: Couldn't access the class " + this.mainClassName, e);
        }
    }

    public static SwirldAppLoader loadSwirldApp(String mainClassName, Path appJarPath) throws AppLoaderException {
        try {
            URLClassLoaderWithLookup classLoader = new URLClassLoaderWithLookup(new URL[]{appJarPath.toUri().toURL()}, Thread.currentThread().getContextClassLoader());
            Class<?> mainClass = Class.forName(mainClassName, true, (ClassLoader)classLoader);
            Constructor<?>[] constructors = mainClass.getDeclaredConstructors();
            Constructor<?> constructor = null;
            for (Constructor<?> constructor2 : constructors) {
                if (constructor2.getGenericParameterTypes().length != 0) continue;
                constructor = constructor2;
                break;
            }
            if (constructor == null) {
                throw new AppLoaderException("The class '" + mainClassName + "' must have a default constructor");
            }
            return new SwirldAppLoader(mainClassName, appJarPath, constructor, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new AppLoaderException("ERROR: Couldn't find the class \"" + mainClassName + "\"", e);
        }
        catch (Exception e) {
            throw new AppLoaderException("ERROR: There are problems loading the class " + mainClassName, e);
        }
    }

    public URLClassLoaderWithLookup getClassLoader() {
        return this.classLoader;
    }
}

