/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.test.fixtures.merkle;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.primitives.ProtoBytes;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.common.config.StateCommonConfig;
import com.swirlds.common.io.config.FileSystemManagerConfig;
import com.swirlds.common.io.config.TemporaryFileConfig;
import com.swirlds.common.io.streams.MerkleDataInputStream;
import com.swirlds.common.io.streams.MerkleDataOutputStream;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.crypto.MerkleCryptography;
import com.swirlds.common.test.fixtures.merkle.TestMerkleCryptoFactory;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.merkledb.MerkleDbDataSourceBuilder;
import com.swirlds.merkledb.config.MerkleDbConfig;
import com.swirlds.merkledb.test.fixtures.MerkleDbTestUtils;
import com.swirlds.state.lifecycle.StateMetadata;
import com.swirlds.state.merkle.StateUtils;
import com.swirlds.state.merkle.StateValue;
import com.swirlds.state.merkle.queue.QueueNode;
import com.swirlds.state.merkle.singleton.SingletonNode;
import com.swirlds.state.test.fixtures.StateTestBase;
import com.swirlds.state.test.fixtures.TestArgumentUtils;
import com.swirlds.virtualmap.VirtualMap;
import com.swirlds.virtualmap.config.VirtualMapConfig;
import com.swirlds.virtualmap.constructable.ConstructableUtils;
import com.swirlds.virtualmap.datasource.VirtualDataSourceBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.hiero.base.constructable.ClassConstructorPair;
import org.hiero.base.constructable.ConstructableRegistry;
import org.hiero.base.constructable.ConstructableRegistryException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.params.provider.Arguments;

public class MerkleTestBase
extends StateTestBase {
    protected final Configuration CONFIGURATION = ConfigurationBuilder.create().withConfigDataType(VirtualMapConfig.class).withConfigDataType(MerkleDbConfig.class).withConfigDataType(TemporaryFileConfig.class).withConfigDataType(StateCommonConfig.class).withConfigDataType(FileSystemManagerConfig.class).build();
    private static final String SINGLETON_CLASS_ID_SUFFIX = "SingletonLeaf";
    private static final String QUEUE_NODE_CLASS_ID_SUFFIX = "QueueNode";
    protected static final MerkleCryptography CRYPTO = TestMerkleCryptoFactory.getInstance();
    protected ConstructableRegistry registry;
    protected String fruitVirtualLabel;
    protected VirtualMap fruitVirtualMap;
    protected String steamLabel;
    protected QueueNode<ProtoBytes> steamQueue;
    protected String countryLabel;
    protected SingletonNode<ProtoBytes> countrySingleton;
    private static final Map<Integer, StateValue.StateValueCodec<ProtoBytes>> stateValueCodecs = new ConcurrentHashMap<Integer, StateValue.StateValueCodec<ProtoBytes>>();

    protected void setupFruitVirtualMap() {
        this.fruitVirtualLabel = StateMetadata.computeLabel((String)"First-Service", (String)"FRUIT");
        this.fruitVirtualMap = this.createVirtualMap(this.fruitVirtualLabel);
    }

    protected static long queueNodeClassId(String stateKey) {
        return StateMetadata.computeClassId((String)"First-Service", (String)stateKey, (SemanticVersion)TEST_VERSION, (String)QUEUE_NODE_CLASS_ID_SUFFIX);
    }

    protected static long singletonClassId(String stateKey) {
        return StateMetadata.computeClassId((String)"First-Service", (String)stateKey, (SemanticVersion)TEST_VERSION, (String)SINGLETON_CLASS_ID_SUFFIX);
    }

    protected void setupSingletonCountry() {
        this.countryLabel = StateMetadata.computeLabel((String)"First-Service", (String)"COUNTRY");
        this.countrySingleton = new SingletonNode(StateMetadata.computeLabel((String)"First-Service", (String)"COUNTRY"), StateMetadata.computeClassId((String)"First-Service", (String)"COUNTRY", (SemanticVersion)TEST_VERSION, (String)SINGLETON_CLASS_ID_SUFFIX), ProtoBytes.PROTOBUF, (Object)AUSTRALIA);
    }

    protected void setupSteamQueue() {
        this.steamLabel = StateMetadata.computeLabel((String)"First-Service", (String)"STEAM");
        this.steamQueue = new QueueNode(StateMetadata.computeLabel((String)"First-Service", (String)"STEAM"), StateMetadata.computeClassId((String)"First-Service", (String)"STEAM", (SemanticVersion)TEST_VERSION, (String)QUEUE_NODE_CLASS_ID_SUFFIX), StateMetadata.computeClassId((String)"First-Service", (String)"STEAM", (SemanticVersion)TEST_VERSION, (String)SINGLETON_CLASS_ID_SUFFIX), ProtoBytes.PROTOBUF);
    }

    protected void setupConstructableRegistry() {
        try {
            this.registry = ConstructableRegistry.getInstance();
            this.registry.reset();
            this.registry.registerConstructables("com.swirlds.merklemap");
            this.registry.registerConstructables("com.swirlds.merkledb");
            this.registry.registerConstructables("com.swirlds.fcqueue");
            this.registry.registerConstructables("com.swirlds.virtualmap");
            this.registry.registerConstructables("com.swirlds.common.merkle");
            this.registry.registerConstructables("com.swirlds.common");
            this.registry.registerConstructables("org.hiero");
            this.registry.registerConstructables("com.swirlds.merkle");
            this.registry.registerConstructables("com.swirlds.merkle.tree");
            ConstructableRegistry.getInstance().registerConstructable(new ClassConstructorPair(MerkleDbDataSourceBuilder.class, () -> new MerkleDbDataSourceBuilder(this.CONFIGURATION)));
            ConstructableUtils.registerVirtualMapConstructables((Configuration)this.CONFIGURATION);
        }
        catch (ConstructableRegistryException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    protected VirtualMap createVirtualMap(String label) {
        MerkleDbDataSourceBuilder builder = new MerkleDbDataSourceBuilder(this.CONFIGURATION, 100L, 0L);
        return new VirtualMap(label, (VirtualDataSourceBuilder)builder, this.CONFIGURATION);
    }

    private StateValue.StateValueCodec<ProtoBytes> getStateValueCodec(int stateId) {
        return stateValueCodecs.computeIfAbsent(stateId, id -> new StateValue.StateValueCodec(id.intValue(), ProtoBytes.PROTOBUF));
    }

    protected void addSingletonState(VirtualMap map, String serviceName, int stateId, ProtoBytes value) {
        map.put(StateUtils.getStateKeyForSingleton((int)stateId), (Object)StateUtils.getStateValueForSingleton((int)stateId, (Object)value), this.getStateValueCodec(stateId));
    }

    protected void addKvState(VirtualMap map, String serviceName, int stateId, ProtoBytes key, ProtoBytes value) {
        map.put(StateUtils.getStateKeyForKv((int)stateId, (Object)key, (Codec)ProtoBytes.PROTOBUF), (Object)StateUtils.getStateValueForKv((int)stateId, (Object)value), this.getStateValueCodec(stateId));
    }

    protected ProtoBytes readValueFromFruitVirtualMap(ProtoBytes key) {
        Bytes keyBytes = StateUtils.getStateKeyForKv((int)3, (Object)key, (Codec)ProtoBytes.PROTOBUF);
        StateValue stateValue = (StateValue)this.fruitVirtualMap.get(keyBytes, this.getStateValueCodec(3));
        return stateValue != null ? (ProtoBytes)stateValue.value() : null;
    }

    protected byte[] writeTree(@NonNull MerkleNode tree, @NonNull Path tempDir) throws IOException {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        try (MerkleDataOutputStream out = new MerkleDataOutputStream((OutputStream)byteOutputStream);){
            out.writeMerkleTree(tempDir, tree);
        }
        return byteOutputStream.toByteArray();
    }

    protected <T extends MerkleNode> T parseTree(@NonNull byte[] state, @NonNull Path tempDir) throws IOException {
        ByteArrayInputStream byteInputStream = new ByteArrayInputStream(state);
        try (MerkleDataInputStream in = new MerkleDataInputStream((InputStream)byteInputStream);){
            MerkleNode merkleNode = in.readMerkleTree(this.CONFIGURATION, tempDir, 100);
            return (T)merkleNode;
        }
    }

    public static Stream<Arguments> illegalServiceNames() {
        return TestArgumentUtils.illegalIdentifiers();
    }

    public static Stream<Arguments> legalServiceNames() {
        return TestArgumentUtils.legalIdentifiers();
    }

    @AfterEach
    void cleanUp() {
        if (this.fruitVirtualMap != null && this.fruitVirtualMap.getReservationCount() > -1) {
            this.fruitVirtualMap.release();
        }
        MerkleDbTestUtils.assertAllDatabasesClosed();
    }
}

