/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.base.utility;

import com.swirlds.base.utility.ThrowableFunction;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public final class Retry {
    static final Duration DEFAULT_RETRY_DELAY = Duration.ofMillis(500L);
    static final Duration DEFAULT_WAIT_TIME = Duration.ofSeconds(10L);

    private Retry() {
    }

    public static <T> boolean check(@NonNull Function<T, Boolean> checkFn, @NonNull T value, @NonNull Duration maxWaitTime, @NonNull Duration retryDelay) throws InterruptedException {
        Objects.requireNonNull(checkFn, "checkFn must not be null");
        Objects.requireNonNull(value, "value must not be null");
        Objects.requireNonNull(maxWaitTime, "maxWaitTime must not be null");
        Objects.requireNonNull(retryDelay, "retryDelay must not be null");
        if (maxWaitTime.isNegative() || maxWaitTime.isZero()) {
            throw new IllegalArgumentException("The maximum wait time must be greater than zero (0)");
        }
        if (retryDelay.isNegative() || retryDelay.isZero()) {
            throw new IllegalArgumentException("The retry delay must be greater than zero (0)");
        }
        if (retryDelay.compareTo(maxWaitTime) > 0) {
            throw new IllegalArgumentException("The retry delay must be less than or equal to the maximum wait time");
        }
        int maxAttempts = Math.round(maxWaitTime.dividedBy(retryDelay));
        return Retry.check(checkFn, value, maxAttempts, retryDelay.toMillis());
    }

    public static <T> boolean check(@NonNull Function<T, Boolean> checkFn, @NonNull T value, int maxAttempts, long delayMs) throws InterruptedException {
        Objects.requireNonNull(checkFn, "checkFn must not be null");
        Objects.requireNonNull(value, "value must not be null");
        if (maxAttempts <= 0) {
            throw new IllegalArgumentException("The maximum number of attempts must be greater than zero (0)");
        }
        if (delayMs < 0L) {
            throw new IllegalArgumentException("The delay must be greater than or equal to zero (0)");
        }
        for (int i = 0; i < maxAttempts; ++i) {
            if (checkFn.apply(value).booleanValue()) {
                return true;
            }
            if (delayMs <= 0L) continue;
            TimeUnit.MILLISECONDS.sleep(delayMs);
        }
        return false;
    }

    public static <T, R> R resolve(@NonNull ThrowableFunction<T, R> resolveFn, @NonNull T value, @NonNull Duration maxWaitTime, @NonNull Duration retryDelay) throws InterruptedException, ExecutionException {
        Objects.requireNonNull(resolveFn, "resolveFn must not be null");
        Objects.requireNonNull(value, "value must not be null");
        Objects.requireNonNull(maxWaitTime, "maxWaitTime must not be null");
        Objects.requireNonNull(retryDelay, "retryDelay must not be null");
        if (maxWaitTime.isNegative() || maxWaitTime.isZero()) {
            throw new IllegalArgumentException("The maximum wait time must be greater than zero (0)");
        }
        if (retryDelay.isNegative() || retryDelay.isZero()) {
            throw new IllegalArgumentException("The retry delay must be greater than zero (0)");
        }
        if (retryDelay.compareTo(maxWaitTime) > 0) {
            throw new IllegalArgumentException("The retry delay must be less than or equal to the maximum wait time");
        }
        int maxAttempts = Math.round(maxWaitTime.dividedBy(retryDelay));
        return Retry.resolve(resolveFn, value, maxAttempts, retryDelay.toMillis());
    }

    public static <T, R> R resolve(@NonNull ThrowableFunction<T, R> resolveFn, @NonNull T value, int maxAttempts, long delayMs) throws InterruptedException, ExecutionException {
        Objects.requireNonNull(resolveFn, "resolveFn must not be null");
        Objects.requireNonNull(value, "value must not be null");
        if (maxAttempts <= 0) {
            throw new IllegalArgumentException("The maximum number of attempts must be greater than zero (0)");
        }
        if (delayMs < 0L) {
            throw new IllegalArgumentException("The delay must be greater than or equal to zero (0)");
        }
        Throwable lastException = null;
        for (int i = 0; i < maxAttempts; ++i) {
            try {
                R result = resolveFn.apply(value);
                if (result != null) {
                    return result;
                }
            }
            catch (Throwable ex) {
                lastException = ex;
            }
            if (delayMs <= 0L) continue;
            TimeUnit.MILLISECONDS.sleep(delayMs);
        }
        throw new ExecutionException("The resolve function failed to return a non-null value after " + maxAttempts + " attempts", lastException);
    }
}

