/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.model.internal.deterministic;

import com.swirlds.component.framework.counters.ObjectCounter;
import com.swirlds.component.framework.model.TraceableWiringModel;
import com.swirlds.component.framework.schedulers.ExceptionHandlers;
import com.swirlds.component.framework.schedulers.TaskScheduler;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerType;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.Consumer;

public class DeterministicTaskScheduler<OUT>
extends TaskScheduler<OUT> {
    private final Consumer<Runnable> submitWork;
    private final ObjectCounter onRamp;
    private final ObjectCounter offRamp;
    private final long capacity;

    protected DeterministicTaskScheduler(@NonNull TraceableWiringModel model, @NonNull String name, @NonNull TaskSchedulerType type, @NonNull ObjectCounter onRamp, @NonNull ObjectCounter offRamp, long capacity, boolean flushEnabled, boolean squelchingEnabled, boolean insertionIsBlocking, @NonNull Consumer<Runnable> submitWork) {
        super(model, name, type, ExceptionHandlers.RETHROW_UNCAUGHT_EXCEPTION, flushEnabled, squelchingEnabled, insertionIsBlocking);
        this.onRamp = Objects.requireNonNull(onRamp);
        this.offRamp = Objects.requireNonNull(offRamp);
        this.submitWork = Objects.requireNonNull(submitWork);
        this.capacity = capacity;
    }

    @Override
    public long getUnprocessedTaskCount() {
        return this.onRamp.getCount();
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public void flush() {
    }

    @Override
    protected void put(@NonNull Consumer<Object> handler, @NonNull Object data) {
        this.onRamp.onRamp();
        this.submitWork.accept(() -> {
            handler.accept(data);
            this.offRamp.offRamp();
        });
    }

    @Override
    protected boolean offer(@NonNull Consumer<Object> handler, @NonNull Object data) {
        if (this.onRamp.attemptOnRamp()) {
            this.submitWork.accept(() -> {
                handler.accept(data);
                this.offRamp.offRamp();
            });
            return true;
        }
        return false;
    }

    @Override
    protected void inject(@NonNull Consumer<Object> handler, @NonNull Object data) {
        this.onRamp.forceOnRamp();
        this.submitWork.accept(() -> {
            handler.accept(data);
            this.offRamp.offRamp();
        });
    }
}

