/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.test.fixtures.files;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.hiero.base.constructable.ConstructableIgnored;

@ConstructableIgnored
public class MockAppender
extends AbstractAppender {
    private final List<String> messages = new CopyOnWriteArrayList<String>();

    public MockAppender(String name) {
        super("MockAppender-" + name, null, null, true, null);
    }

    public void append(LogEvent event) {
        if (this.isStarted()) {
            this.messages.add(String.format("%s - %s - %s", event.getMarker().getName(), event.getLevel(), event.getMessage().getFormattedMessage()));
        }
    }

    public int size() {
        return this.messages.size();
    }

    public void clear() {
        this.messages.clear();
    }

    public String get(int index) {
        return this.messages.get(index);
    }

    public void stop() {
        this.messages.clear();
        super.stop();
    }
}

