/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.contract.codec.ContractCallTransactionBodyJsonCodec;
import com.hedera.hapi.node.contract.codec.ContractCallTransactionBodyProtoCodec;
import com.hedera.hapi.node.contract.schema.ContractCallTransactionBodySchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class ContractCallTransactionBody {
    public static final Codec<ContractCallTransactionBody> PROTOBUF = new ContractCallTransactionBodyProtoCodec();
    public static final JsonCodec<ContractCallTransactionBody> JSON = new ContractCallTransactionBodyJsonCodec();
    public static final ContractCallTransactionBody DEFAULT = ContractCallTransactionBody.newBuilder().build();
    @Nullable
    private final ContractID contractID;
    private final long gas;
    private final long amount;
    @NonNull
    private final Bytes functionParameters;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public ContractCallTransactionBody(ContractID contractID, long gas, long amount, Bytes functionParameters) {
        this.$unknownFields = null;
        this.contractID = contractID;
        this.gas = gas;
        this.amount = amount;
        this.functionParameters = functionParameters != null ? functionParameters : Bytes.EMPTY;
    }

    public ContractCallTransactionBody(ContractID contractID, long gas, long amount, Bytes functionParameters, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.contractID = contractID;
        this.gas = gas;
        this.amount = amount;
        this.functionParameters = functionParameters != null ? functionParameters : Bytes.EMPTY;
    }

    public ContractID contractID() {
        return this.contractID;
    }

    public long gas() {
        return this.gas;
    }

    public long amount() {
        return this.amount;
    }

    public Bytes functionParameters() {
        return this.functionParameters;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ContractCallTransactionBodySchema.CONTRACT_ID, (Object)this.contractID, ContractID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)ContractCallTransactionBodySchema.GAS, (long)this.gas, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)ContractCallTransactionBodySchema.AMOUNT, (long)this.amount, (boolean)true);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)ContractCallTransactionBodySchema.FUNCTION_PARAMETERS, (RandomAccessData)this.functionParameters, (boolean)true);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.contractID != null && !this.contractID.equals(ContractCallTransactionBody.DEFAULT.contractID)) {
                result = 31 * result + this.contractID.hashCode();
            }
            if (this.gas != ContractCallTransactionBody.DEFAULT.gas) {
                result = 31 * result + Long.hashCode(this.gas);
            }
            if (this.amount != ContractCallTransactionBody.DEFAULT.amount) {
                result = 31 * result + Long.hashCode(this.amount);
            }
            if (this.functionParameters != null && !this.functionParameters.equals((Object)ContractCallTransactionBody.DEFAULT.functionParameters)) {
                result = 31 * result + this.functionParameters.hashCode();
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        ContractCallTransactionBody thatObj = (ContractCallTransactionBody)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.contractID == null && thatObj.contractID != null) {
            return false;
        }
        if (this.contractID != null && !this.contractID.equals(thatObj.contractID)) {
            return false;
        }
        if (this.gas != thatObj.gas) {
            return false;
        }
        if (this.amount != thatObj.amount) {
            return false;
        }
        if (this.functionParameters == null && thatObj.functionParameters != null) {
            return false;
        }
        if (this.functionParameters != null && !this.functionParameters.equals((Object)thatObj.functionParameters)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "ContractCallTransactionBody[contractID=" + String.valueOf(this.contractID) + ", gas=" + this.gas + ", amount=" + this.amount + ", functionParameters=" + String.valueOf(this.functionParameters) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasContractID() {
        return this.contractID != null;
    }

    public ContractID contractIDOrElse(@NonNull ContractID defaultValue) {
        return this.hasContractID() ? this.contractID : defaultValue;
    }

    @NonNull
    public ContractID contractIDOrThrow() {
        return Objects.requireNonNull(this.contractID, "Field contractID is null");
    }

    public void ifContractID(@NonNull Consumer<ContractID> ifPresent) {
        if (this.hasContractID()) {
            ifPresent.accept(this.contractID);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.contractID, this.gas, this.amount, this.functionParameters, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private ContractID contractID = null;
        private long gas = 0L;
        private long amount = 0L;
        @NonNull
        private Bytes functionParameters = Bytes.EMPTY;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(ContractID contractID, long gas, long amount, Bytes functionParameters) {
            this.$unknownFields = null;
            this.contractID = contractID;
            this.gas = gas;
            this.amount = amount;
            this.functionParameters = functionParameters != null ? functionParameters : Bytes.EMPTY;
        }

        public Builder(ContractID contractID, long gas, long amount, Bytes functionParameters, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.contractID = contractID;
            this.gas = gas;
            this.amount = amount;
            this.functionParameters = functionParameters != null ? functionParameters : Bytes.EMPTY;
        }

        public ContractCallTransactionBody build() {
            return new ContractCallTransactionBody(this.contractID, this.gas, this.amount, this.functionParameters);
        }

        public Builder contractID(@Nullable ContractID contractID) {
            this.contractID = contractID;
            return this;
        }

        public Builder contractID(ContractID.Builder builder) {
            this.contractID = builder.build();
            return this;
        }

        public Builder gas(long gas) {
            this.gas = gas;
            return this;
        }

        public Builder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public Builder functionParameters(@NonNull Bytes functionParameters) {
            this.functionParameters = functionParameters != null ? functionParameters : Bytes.EMPTY;
            return this;
        }
    }
}

