/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.merkle.util;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.base.time.Time;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.copy.MerkleInitialize;
import com.swirlds.common.merkle.interfaces.MerkleType;
import com.swirlds.common.merkle.iterators.MerkleIterator;
import com.swirlds.common.merkle.synchronization.LearningSynchronizer;
import com.swirlds.common.merkle.synchronization.TeachingSynchronizer;
import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.common.merkle.synchronization.utility.MerkleSynchronizationException;
import com.swirlds.common.metrics.PlatformMetricsFactory;
import com.swirlds.common.metrics.config.MetricsConfig;
import com.swirlds.common.metrics.platform.DefaultPlatformMetrics;
import com.swirlds.common.metrics.platform.MetricKeyRegistry;
import com.swirlds.common.metrics.platform.PlatformMetricsFactoryImpl;
import com.swirlds.common.test.fixtures.merkle.TestMerkleCryptoFactory;
import com.swirlds.common.test.fixtures.merkle.dummy.DummyCustomReconnectRoot;
import com.swirlds.common.test.fixtures.merkle.dummy.DummyMerkleExternalLeaf;
import com.swirlds.common.test.fixtures.merkle.dummy.DummyMerkleInternal;
import com.swirlds.common.test.fixtures.merkle.dummy.DummyMerkleInternal2;
import com.swirlds.common.test.fixtures.merkle.dummy.DummyMerkleLeaf;
import com.swirlds.common.test.fixtures.merkle.dummy.DummyMerkleLeaf2;
import com.swirlds.common.test.fixtures.merkle.dummy.DummyMerkleNode;
import com.swirlds.common.test.fixtures.merkle.util.AverageLeafDepth;
import com.swirlds.common.test.fixtures.merkle.util.LaggingLearningSynchronizer;
import com.swirlds.common.test.fixtures.merkle.util.LaggingTeachingSynchronizer;
import com.swirlds.common.test.fixtures.merkle.util.PairedStreams;
import com.swirlds.common.test.fixtures.platform.TestPlatformContextBuilder;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import com.swirlds.common.threading.manager.ThreadManager;
import com.swirlds.common.threading.pool.StandardWorkGroup;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.extensions.test.fixtures.TestConfigBuilder;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.virtualmap.VirtualMap;
import com.swirlds.virtualmap.internal.merkle.VirtualLeafNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.junit.jupiter.api.Assertions;
import org.mockito.Mockito;

public final class MerkleTestUtils {
    private static final Metrics metrics = MerkleTestUtils.createMetrics();

    private static Metrics createMetrics() {
        Configuration configuration = new TestConfigBuilder().getOrCreateConfig();
        MetricsConfig metricsConfig = (MetricsConfig)configuration.getConfigData(MetricsConfig.class);
        MetricKeyRegistry registry = new MetricKeyRegistry();
        return new DefaultPlatformMetrics(null, registry, (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class), (PlatformMetricsFactory)new PlatformMetricsFactoryImpl(metricsConfig), metricsConfig);
    }

    private MerkleTestUtils() {
    }

    public static DummyMerkleNode buildSizeZeroTree() {
        return null;
    }

    public static DummyMerkleNode buildSizeOneTree() {
        return new DummyMerkleLeaf("A");
    }

    public static DummyMerkleNode buildSimpleTree() {
        DummyMerkleInternal root = new DummyMerkleInternal("root");
        DummyMerkleLeaf A = new DummyMerkleLeaf("A");
        root.setChild(0, A);
        MerkleInitialize.initializeTreeAfterCopy((MerkleNode)root);
        return root;
    }

    public static DummyMerkleInternal buildLessSimpleTree() {
        DummyMerkleInternal root = new DummyMerkleInternal("root");
        DummyMerkleLeaf A = new DummyMerkleLeaf("A");
        DummyMerkleInternal i0 = new DummyMerkleInternal("i0");
        DummyMerkleInternal i1 = new DummyMerkleInternal("i1");
        root.setChild(0, A);
        root.setChild(1, i0);
        root.setChild(2, i1);
        DummyMerkleLeaf B = new DummyMerkleLeaf("B");
        DummyMerkleLeaf C = new DummyMerkleLeaf("C");
        i0.setChild(0, B);
        i0.setChild(1, C);
        DummyMerkleLeaf D = new DummyMerkleLeaf("D");
        i1.setChild(0, D);
        i1.setChild(1, null);
        MerkleInitialize.initializeTreeAfterCopy((MerkleNode)root);
        return root;
    }

    public static DummyMerkleInternal buildLessSimpleTreeExtended() {
        DummyMerkleInternal root = new DummyMerkleInternal("root");
        DummyMerkleLeaf A = new DummyMerkleLeaf("A");
        DummyMerkleInternal i0 = new DummyMerkleInternal("i0");
        DummyMerkleInternal i1 = new DummyMerkleInternal("i1");
        root.setChild(0, A);
        root.setChild(1, i0);
        root.setChild(2, i1);
        DummyMerkleInternal i4 = new DummyMerkleInternal("i4");
        DummyMerkleLeaf C = new DummyMerkleLeaf("C");
        i0.setChild(0, i4);
        i0.setChild(1, C);
        DummyMerkleLeaf D = new DummyMerkleLeaf("D");
        DummyMerkleInternal i2 = new DummyMerkleInternal("i2");
        i1.setChild(0, D);
        i1.setChild(1, i2);
        DummyMerkleInternal i3 = new DummyMerkleInternal("i3");
        DummyMerkleLeaf E = new DummyMerkleLeaf("E");
        i2.setChild(0, i3);
        i2.setChild(1, E);
        DummyMerkleLeaf F = new DummyMerkleLeaf("F");
        DummyMerkleLeaf G = new DummyMerkleLeaf("G");
        i3.setChild(0, F);
        i3.setChild(1, G);
        MerkleInitialize.initializeTreeAfterCopy((MerkleNode)root);
        return root;
    }

    public static DummyMerkleNode buildLessSimpleTreeWithSwappedTypes() {
        DummyMerkleInternal root = new DummyMerkleInternal("root");
        DummyMerkleLeaf2 A = new DummyMerkleLeaf2("A");
        DummyMerkleInternal2 i0 = new DummyMerkleInternal2("i0");
        DummyMerkleInternal2 i1 = new DummyMerkleInternal2("i1");
        root.setChild(0, A);
        root.setChild(1, i0);
        root.setChild(2, i1);
        DummyMerkleLeaf B = new DummyMerkleLeaf("B");
        DummyMerkleLeaf C = new DummyMerkleLeaf("C");
        i0.setChild(0, B);
        i0.setChild(1, C);
        DummyMerkleLeaf D = new DummyMerkleLeaf("D");
        i1.setChild(0, D);
        i1.setChild(1, null);
        MerkleInitialize.initializeTreeAfterCopy((MerkleNode)root);
        return root;
    }

    public static DummyMerkleNode buildTreeWithExternalData() {
        DummyMerkleInternal root = new DummyMerkleInternal("root");
        DummyMerkleLeaf A = new DummyMerkleLeaf("A");
        DummyMerkleInternal i0 = new DummyMerkleInternal("i0");
        DummyMerkleInternal i1 = new DummyMerkleInternal("i1");
        root.setChild(0, A);
        root.setChild(1, i0);
        root.setChild(2, i1);
        DummyMerkleLeaf B = new DummyMerkleLeaf("B");
        DummyMerkleExternalLeaf E1 = new DummyMerkleExternalLeaf(1234L, 10, 0);
        i0.setChild(0, B);
        i0.setChild(1, E1);
        DummyMerkleLeaf D = new DummyMerkleLeaf("D");
        DummyMerkleExternalLeaf E2 = new DummyMerkleExternalLeaf(4321L, 10, 0);
        i1.setChild(0, D);
        i1.setChild(1, E2);
        MerkleInitialize.initializeTreeAfterCopy((MerkleNode)root);
        return root;
    }

    public static double randomWithDistribution(Random random, double mean, double standardDeviation, double minimum) {
        return Math.max(random.nextGaussian() * standardDeviation + mean, minimum);
    }

    public static boolean randomChance(Random random, double probability) {
        return random.nextDouble() < probability;
    }

    public static String generateRandomString(long seed, double averageSize, double standardDeviation) {
        return MerkleTestUtils.generateRandomString(new Random(seed), averageSize, standardDeviation);
    }

    public static char generateRandomCharacter(Random random) {
        int min = 65;
        int max = 90;
        int next = random.nextInt();
        if (next < 0) {
            next *= -1;
        }
        next = next % 25 + 65;
        return (char)next;
    }

    public static String generateRandomString(Random random, double averageSize, double standardDeviation) {
        int length = (int)MerkleTestUtils.randomWithDistribution(random, averageSize, standardDeviation, 1.0);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(MerkleTestUtils.generateRandomCharacter(random));
        }
        return sb.toString();
    }

    public static DummyMerkleLeaf generateRandomMerkleLeaf(Random random, double leafSizeAverage, double leafSizeStandardDeviation) {
        return new DummyMerkleLeaf(MerkleTestUtils.generateRandomString(random, leafSizeAverage, leafSizeStandardDeviation));
    }

    public static DummyMerkleInternal generateRandomInternalNode(Random random, MerkleInternal parent, int indexInParent, double numberOfLeavesAverage, double numberOfLeavesStandardDeviation, double leafSizeAverage, double leafSizeStandardDeviation, double numberOfInternalNodesAverage, double numberOfInternalNodesStandardDeviation, double numberOfInternalNodesDecayFactor, int depth) {
        DummyMerkleInternal node = new DummyMerkleInternal();
        node.rebuild();
        if (parent != null) {
            parent.setChild(indexInParent, (MerkleNode)node);
        }
        int numberOfLeaves = (int)MerkleTestUtils.randomWithDistribution(random, numberOfLeavesAverage, numberOfLeavesStandardDeviation, 0.0);
        int numberOfInternalNodes = (int)MerkleTestUtils.randomWithDistribution(random, numberOfInternalNodesAverage - numberOfInternalNodesDecayFactor * (double)depth, numberOfInternalNodesStandardDeviation, 0.0);
        int numberOfLeavesCreated = 0;
        int numberOfInternalNodesCreated = 0;
        while (numberOfLeavesCreated < numberOfLeaves || numberOfInternalNodesCreated < numberOfInternalNodes) {
            if (numberOfLeavesCreated < numberOfLeaves) {
                node.setChild(numberOfLeavesCreated + numberOfInternalNodesCreated, MerkleTestUtils.generateRandomMerkleLeaf(random, leafSizeAverage, leafSizeStandardDeviation));
                ++numberOfLeavesCreated;
            }
            if (numberOfInternalNodesCreated >= numberOfInternalNodes) continue;
            MerkleTestUtils.generateRandomInternalNode(random, node, numberOfLeavesCreated + numberOfInternalNodesCreated, numberOfLeavesAverage, numberOfLeavesStandardDeviation, leafSizeAverage, leafSizeStandardDeviation, numberOfInternalNodesAverage, numberOfInternalNodesStandardDeviation, numberOfInternalNodesDecayFactor, depth + 1);
            ++numberOfInternalNodesCreated;
        }
        return node;
    }

    public static DummyMerkleNode generateRandomTree(long seed, double numberOfLeavesAverage, double numberOfLeavesStandardDeviation, double leafSizeAverage, double leafSizeStandardDeviation, double numberOfInternalNodesAverage, double numberOfInternalNodesStandardDeviation, double numberOfInternalNodesDecayFactor) {
        Random random = new Random(seed);
        return MerkleTestUtils.generateRandomInternalNode(random, null, 0, numberOfLeavesAverage, numberOfLeavesStandardDeviation, leafSizeAverage, leafSizeStandardDeviation, numberOfInternalNodesAverage, numberOfInternalNodesStandardDeviation, numberOfInternalNodesDecayFactor, 0);
    }

    private static DummyMerkleNode generateRandomBalancedTree(Random random, MerkleInternal parent, int indexInParent, int depth, int internalNodeChildren, double leafSizeAverage, double leafSizeStandardDeviation, int currentDepth) {
        if (depth == currentDepth) {
            DummyMerkleLeaf child = MerkleTestUtils.generateRandomMerkleLeaf(random, leafSizeAverage, leafSizeStandardDeviation);
            if (parent != null) {
                parent.setChild(indexInParent, (MerkleNode)child);
            }
            return child;
        }
        DummyMerkleInternal node = new DummyMerkleInternal();
        node.rebuild();
        if (parent != null) {
            parent.setChild(indexInParent, (MerkleNode)node);
        }
        for (int childIndex = 0; childIndex < internalNodeChildren; ++childIndex) {
            MerkleTestUtils.generateRandomBalancedTree(random, node, childIndex, depth, internalNodeChildren, leafSizeAverage, leafSizeStandardDeviation, currentDepth + 1);
        }
        return node;
    }

    public static DummyMerkleNode generateRandomBalancedTree(long seed, int depth, int internalNodeChildren, double leafSizeAverage, double leafSizeStandardDeviation) {
        Random random = new Random(seed);
        return MerkleTestUtils.generateRandomBalancedTree(random, null, 0, depth, internalNodeChildren, leafSizeAverage, leafSizeStandardDeviation, 0);
    }

    private static void randomlyMutateTree(DummyMerkleNode root, double leafMutationProbability, double internalMutationProbability, Random random, double numberOfLeavesAverage, double numberOfLeavesStandardDeviation, double leafSizeAverage, double leafSizeStandardDeviation, double numberOfInternalNodesAverage, double numberOfInternalNodesStandardDeviation, double numberOfInternalNodesDecayFactor, int depth) {
        if (root instanceof MerkleInternal) {
            MerkleInternal internal = (MerkleInternal)root.cast();
            for (int childIndex = 0; childIndex < internal.getNumberOfChildren(); ++childIndex) {
                DummyMerkleNode replacement;
                MerkleNode child = internal.getChild(childIndex);
                if (child == null || child instanceof MerkleLeaf && MerkleTestUtils.randomChance(random, leafMutationProbability)) {
                    replacement = MerkleTestUtils.generateRandomMerkleLeaf(random, leafSizeAverage, leafSizeStandardDeviation);
                    internal.setChild(childIndex, (MerkleNode)replacement);
                    continue;
                }
                if (!(child instanceof MerkleInternal)) continue;
                if (MerkleTestUtils.randomChance(random, internalMutationProbability)) {
                    replacement = MerkleTestUtils.generateRandomInternalNode(random, internal, childIndex, numberOfLeavesAverage, numberOfLeavesStandardDeviation, leafSizeAverage, leafSizeStandardDeviation, numberOfInternalNodesAverage, numberOfInternalNodesStandardDeviation, numberOfInternalNodesDecayFactor, depth + 1);
                    internal.setChild(childIndex, (MerkleNode)replacement);
                    continue;
                }
                MerkleTestUtils.randomlyMutateTree((DummyMerkleNode)child, leafMutationProbability, internalMutationProbability, random, numberOfLeavesAverage, numberOfLeavesStandardDeviation, leafSizeAverage, leafSizeStandardDeviation, numberOfInternalNodesAverage, numberOfInternalNodesStandardDeviation, numberOfInternalNodesDecayFactor, depth + 1);
            }
        }
    }

    public static void randomlyMutateTree(DummyMerkleNode root, double leafMutationProbability, double internalMutationProbability, long seed, double numberOfLeavesAverage, double numberOfLeavesStandardDeviation, double leafSizeAverage, double leafSizeStandardDeviation, double numberOfInternalNodesAverage, double numberOfInternalNodesStandardDeviation, double numberOfInternalNodesDecayFactor) {
        Random random = new Random(seed);
        MerkleTestUtils.randomlyMutateTree(root, leafMutationProbability, internalMutationProbability, random, numberOfLeavesAverage, numberOfLeavesStandardDeviation, leafSizeAverage, leafSizeStandardDeviation, numberOfInternalNodesAverage, numberOfInternalNodesStandardDeviation, numberOfInternalNodesDecayFactor, 0);
    }

    public static void printTreeStats(MerkleNode root) {
        System.out.println("Number of nodes: " + MerkleTestUtils.measureNumberOfNodes(root));
        System.out.println("Number of leaves: " + MerkleTestUtils.measureNumberOfLeafNodes(root));
        System.out.println("Maximum depth: " + MerkleTestUtils.measureTreeDepth(root));
        System.out.println("Average leaf depth: " + MerkleTestUtils.measureAverageLeafDepth(root));
    }

    public static int measureNumberOfNodes(MerkleNode root) {
        MerkleIterator it = new MerkleIterator(root).ignoreNull(false);
        int count = 0;
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    public static int measureNumberOfLeafNodes(MerkleNode root) {
        MerkleIterator it = new MerkleIterator(root).ignoreNull(false).setFilter(node -> !(node instanceof MerkleInternal));
        int count = 0;
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    public static int measureTreeDepth(MerkleNode root) {
        if (root == null) {
            return 0;
        }
        if (root.isLeaf()) {
            return 1;
        }
        MerkleInternal node = (MerkleInternal)root.cast();
        int maxChildDepth = 0;
        for (int childIndex = 0; childIndex < node.getNumberOfChildren(); ++childIndex) {
            maxChildDepth = Math.max(maxChildDepth, MerkleTestUtils.measureTreeDepth(node.getChild(childIndex)));
        }
        return maxChildDepth + 1;
    }

    private static AverageLeafDepth measureAverageLeafDepthInternal(MerkleNode tree, int depth, Set<MerkleNode> visitedNodes) {
        AverageLeafDepth averageDepth = new AverageLeafDepth();
        if (tree != null) {
            if (tree.isLeaf()) {
                averageDepth.addLeaves(1);
                averageDepth.addDepth(depth + 1);
            } else {
                MerkleInternal node = (MerkleInternal)tree.cast();
                for (int childIndex = 0; childIndex < node.getNumberOfChildren(); ++childIndex) {
                    MerkleNode child = node.getChild(childIndex);
                    if (visitedNodes.contains(child)) continue;
                    AverageLeafDepth childDepth = MerkleTestUtils.measureAverageLeafDepthInternal(child, depth + 1, visitedNodes);
                    averageDepth.add(childDepth);
                    visitedNodes.add(child);
                }
            }
        }
        return averageDepth;
    }

    public static double measureAverageLeafDepth(MerkleNode root) {
        HashSet<MerkleNode> visitedNodes = new HashSet<MerkleNode>();
        return MerkleTestUtils.measureAverageLeafDepthInternal(root, 0, visitedNodes).getAverageDepth();
    }

    public static double measureAverageLeafSize(DummyMerkleNode root) {
        if (root == null) {
            return 0.0;
        }
        double totalSize = 0.0;
        int count = 0;
        MerkleIterator iterator = new MerkleIterator((MerkleNode)root).setFilter(MerkleType::isLeaf);
        while (iterator.hasNext()) {
            DummyMerkleNode next = (DummyMerkleNode)iterator.next();
            if (next == null) continue;
            totalSize += (double)next.getValue().length();
            ++count;
        }
        if (count == 0) {
            return totalSize;
        }
        return totalSize / (double)count;
    }

    public static List<DummyMerkleNode> buildSmallTreeList() {
        ArrayList<DummyMerkleNode> list = new ArrayList<DummyMerkleNode>();
        list.add(MerkleTestUtils.buildSizeZeroTree());
        list.add(MerkleTestUtils.buildSizeOneTree());
        list.add(MerkleTestUtils.buildSimpleTree());
        list.add(MerkleTestUtils.buildLessSimpleTree());
        list.add(MerkleTestUtils.buildLessSimpleTreeExtended());
        list.add(MerkleTestUtils.buildTreeWithExternalData());
        list.add(MerkleTestUtils.buildLessSimpleTreeWithSwappedTypes());
        return list;
    }

    public static List<DummyMerkleNode> buildTreeList() {
        List<DummyMerkleNode> list = MerkleTestUtils.buildSmallTreeList();
        DummyMerkleNode randomTree = MerkleTestUtils.generateRandomTree(0L, 2.0, 1.0, 1.0, 0.0, 3.0, 1.0, 0.25);
        System.out.println("Random tree statistics:");
        MerkleTestUtils.printTreeStats(randomTree);
        list.add(randomTree);
        DummyMerkleNode mutatedRandomTree = MerkleTestUtils.generateRandomTree(0L, 2.0, 1.0, 1.0, 0.0, 3.0, 1.0, 0.25);
        MerkleTestUtils.randomlyMutateTree(mutatedRandomTree, 0.1, 0.05, 1234L, 2.0, 1.0, 1.0, 0.0, 3.0, 1.0, 0.25);
        System.out.println("Random tree statistics (mutated):");
        MerkleTestUtils.printTreeStats(mutatedRandomTree);
        list.add(mutatedRandomTree);
        return list;
    }

    private static boolean areNodesEqual(MerkleNode a, MerkleNode b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a.getClassId() != b.getClassId()) {
            return false;
        }
        if (a.isLeaf()) {
            return MerkleTestUtils.areLeavesEqual(a.asLeaf(), b.asLeaf());
        }
        return MerkleTestUtils.areInternalsEqual(a.asInternal(), b.asInternal());
    }

    private static boolean areLeavesEqual(MerkleLeaf a, MerkleLeaf b) {
        try {
            ByteArrayOutputStream bsA = new ByteArrayOutputStream();
            SerializableDataOutputStream sA = new SerializableDataOutputStream((OutputStream)bsA);
            try {
                sA.writeSerializable((SelfSerializable)a, true);
            }
            catch (IOException e) {
                Assertions.fail((Throwable)e);
            }
            ByteArrayOutputStream bsB = new ByteArrayOutputStream();
            SerializableDataOutputStream sB = new SerializableDataOutputStream((OutputStream)bsB);
            try {
                sB.writeSerializable((SelfSerializable)b, true);
            }
            catch (IOException e) {
                Assertions.fail((Throwable)e);
            }
            byte[] bytesA = bsA.toByteArray();
            byte[] bytesB = bsB.toByteArray();
            if (bytesA.length != bytesB.length) {
                return false;
            }
            for (int index = 0; index < bytesA.length; ++index) {
                if (bytesA[index] == bytesB[index]) continue;
                return false;
            }
            return true;
        }
        catch (UnsupportedOperationException e) {
            return Objects.equals(a, b);
        }
    }

    private static boolean areInternalsEqual(MerkleInternal a, MerkleInternal b) {
        return a.getNumberOfChildren() == b.getNumberOfChildren();
    }

    public static boolean areTreesEqual(MerkleNode rootA, MerkleNode rootB) {
        MerkleIterator iteratorA = new MerkleIterator(rootA);
        MerkleIterator iteratorB = new MerkleIterator(rootB);
        while (iteratorA.hasNext()) {
            MerkleNode b;
            if (!iteratorB.hasNext()) {
                return false;
            }
            MerkleNode a = (MerkleNode)iteratorA.next();
            if (MerkleTestUtils.areNodesEqual(a, b = (MerkleNode)iteratorB.next())) continue;
            return false;
        }
        return !iteratorB.hasNext();
    }

    public static boolean checkVirtualMapKeys(MerkleNode rootA, MerkleNode rootB, Set<Bytes> virtualKeys) {
        MerkleIterator iteratorA = new MerkleIterator(rootA);
        MerkleIterator iteratorB = new MerkleIterator(rootB);
        while (iteratorA.hasNext()) {
            if (!iteratorB.hasNext()) {
                return false;
            }
            MerkleNode a = (MerkleNode)iteratorA.next();
            MerkleNode b = (MerkleNode)iteratorB.next();
            if (!(a instanceof VirtualMap)) continue;
            VirtualMap vmA = (VirtualMap)a;
            if (!(b instanceof VirtualMap)) {
                return false;
            }
            VirtualMap vmB = (VirtualMap)b;
            for (Bytes key : virtualKeys) {
                if (vmA.containsKey(key) == vmB.containsKey(key)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isFullyInitialized(DummyMerkleNode root) {
        MerkleIterator iterator = new MerkleIterator((MerkleNode)root).setFilter(MerkleType::isInternal);
        while (iterator.hasNext()) {
            MerkleInternal node = (MerkleInternal)iterator.next();
            if (!(node instanceof DummyMerkleInternal) || ((DummyMerkleInternal)node).isInitialized()) continue;
            return false;
        }
        return true;
    }

    public static boolean isTreeMutable(MerkleNode root) {
        if (root == null) {
            return true;
        }
        AtomicBoolean mutable = new AtomicBoolean(true);
        root.forEachNode(node -> {
            if (node.isImmutable()) {
                mutable.set(false);
            }
        });
        return mutable.get();
    }

    public static boolean haveAnyNodesBeenReleased(MerkleNode root) {
        AtomicBoolean haveAnyNodesBeenReleased = new AtomicBoolean(false);
        root.forEachNode(node -> {
            if (node != null && node.isDestroyed()) {
                haveAnyNodesBeenReleased.set(true);
            }
        });
        return haveAnyNodesBeenReleased.get();
    }

    public static int countSimilarLeaves(MerkleNode treeA, MerkleNode treeB) {
        HashSet<String> values = new HashSet<String>();
        int count = 0;
        MerkleIterator iterator = new MerkleIterator(treeA).setFilter(MerkleType::isLeaf);
        while (iterator.hasNext()) {
            values.add(((DummyMerkleNode)iterator.next()).getValue());
        }
        iterator = new MerkleIterator(treeB).setFilter(MerkleType::isLeaf);
        while (iterator.hasNext()) {
            if (!values.contains(((DummyMerkleNode)iterator.next()).getValue())) continue;
            ++count;
        }
        return count;
    }

    private static void teachingSynchronizerThread(TeachingSynchronizer teacher) {
        try {
            teacher.synchronize();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    private static void learningSynchronizerThread(LearningSynchronizer learner) {
        try {
            learner.synchronize();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static <T extends MerkleNode> T testSynchronization(MerkleNode startingTree, MerkleNode desiredTree, ReconnectConfig reconnectConfig) throws Exception {
        return MerkleTestUtils.testSynchronization(startingTree, desiredTree, 0, reconnectConfig);
    }

    public static <T extends MerkleNode> T testSynchronization(MerkleNode startingTree, MerkleNode desiredTree, int latencyMilliseconds, ReconnectConfig reconnectConfig) throws Exception {
        try (PairedStreams streams = new PairedStreams();){
            TeachingSynchronizer teacher;
            LearningSynchronizer learner;
            if (latencyMilliseconds == 0) {
                learner = new LearningSynchronizer(AdHocThreadManager.getStaticThreadManager(), streams.getLearnerInput(), streams.getLearnerOutput(), startingTree, streams::disconnect, TestMerkleCryptoFactory.getInstance(), reconnectConfig, metrics){

                    protected StandardWorkGroup createStandardWorkGroup(ThreadManager threadManager, Runnable breakConnection, Function<Throwable, Boolean> reconnectExceptionListener) {
                        return new StandardWorkGroup(threadManager, "test-learning-synchronizer", breakConnection, MerkleTestUtils.createSuppressedExceptionListener(reconnectExceptionListener), true);
                    }
                };
                platformContext = TestPlatformContextBuilder.create().build();
                teacher = new TeachingSynchronizer(platformContext.getConfiguration(), Time.getCurrent(), AdHocThreadManager.getStaticThreadManager(), streams.getTeacherInput(), streams.getTeacherOutput(), desiredTree, streams::disconnect, reconnectConfig){

                    protected StandardWorkGroup createStandardWorkGroup(ThreadManager threadManager, Runnable breakConnection, Function<Throwable, Boolean> exceptionListener) {
                        return new StandardWorkGroup(threadManager, "test-teaching-synchronizer", breakConnection, MerkleTestUtils.createSuppressedExceptionListener(exceptionListener), true);
                    }
                };
            } else {
                learner = new LaggingLearningSynchronizer(streams.getLearnerInput(), streams.getLearnerOutput(), startingTree, latencyMilliseconds, streams::disconnect, reconnectConfig, metrics){

                    protected StandardWorkGroup createStandardWorkGroup(ThreadManager threadManager, Runnable breakConnection, Function<Throwable, Boolean> reconnectExceptionListener) {
                        return new StandardWorkGroup(threadManager, "test-learning-synchronizer", breakConnection, MerkleTestUtils.createSuppressedExceptionListener(reconnectExceptionListener), true);
                    }
                };
                platformContext = TestPlatformContextBuilder.create().build();
                teacher = new LaggingTeachingSynchronizer(platformContext, streams.getTeacherInput(), streams.getTeacherOutput(), desiredTree, latencyMilliseconds, streams::disconnect, reconnectConfig){

                    protected StandardWorkGroup createStandardWorkGroup(ThreadManager threadManager, Runnable breakConnection, Function<Throwable, Boolean> reconnectExceptionListener) {
                        return new StandardWorkGroup(threadManager, "test-teaching-synchronizer", breakConnection, MerkleTestUtils.createSuppressedExceptionListener(reconnectExceptionListener), true);
                    }
                };
            }
            AtomicReference firstReconnectException = new AtomicReference();
            Function<Throwable, Boolean> exceptionListener = MerkleTestUtils.createSuppressedExceptionListener(t -> {
                firstReconnectException.compareAndSet(null, t);
                return false;
            });
            StandardWorkGroup workGroup = new StandardWorkGroup(AdHocThreadManager.getStaticThreadManager(), "synchronization-test", null, exceptionListener, true);
            workGroup.execute("teaching-synchronizer-main", () -> MerkleTestUtils.teachingSynchronizerThread(teacher));
            workGroup.execute("learning-synchronizer-main", () -> MerkleTestUtils.learningSynchronizerThread(learner));
            try {
                workGroup.waitForTermination();
            }
            catch (InterruptedException e) {
                workGroup.shutdown();
                Thread.currentThread().interrupt();
            }
            if (workGroup.hasExceptions()) {
                throw new MerkleSynchronizationException("Exception(s) in synchronization test", (Throwable)firstReconnectException.get());
            }
            MerkleNode generatedTree = learner.getRoot();
            MerkleTestUtils.assertReconnectValidity(startingTree, desiredTree, generatedTree);
            MerkleNode merkleNode = generatedTree;
            return (T)merkleNode;
        }
    }

    private static boolean isVirtual(MerkleNode node) {
        return node != null && (node.getClassId() == -5826388714229745985L || node.getClassId() == 5302557153892697290L);
    }

    private static Set<Bytes> getVirtualKeys(MerkleNode node) {
        HashSet<Bytes> keys = new HashSet<Bytes>();
        MerkleIterator it = new MerkleIterator(node);
        while (it.hasNext()) {
            MerkleNode n = (MerkleNode)it.next();
            if (!(n instanceof VirtualLeafNode)) continue;
            VirtualLeafNode leaf = (VirtualLeafNode)n;
            keys.add(leaf.getKey());
        }
        return keys;
    }

    private static void assertReconnectValidity(MerkleNode startingTree, MerkleNode desiredTree, MerkleNode generatedTree) {
        Assertions.assertTrue((boolean)MerkleTestUtils.areTreesEqual(generatedTree, desiredTree), (String)"reconnect should produce identical tree");
        HashSet<Bytes> allKeys = new HashSet<Bytes>();
        allKeys.addAll(MerkleTestUtils.getVirtualKeys(startingTree));
        allKeys.addAll(MerkleTestUtils.getVirtualKeys(desiredTree));
        Assertions.assertTrue((boolean)MerkleTestUtils.checkVirtualMapKeys(generatedTree, desiredTree, allKeys));
        if (desiredTree != null) {
            Assertions.assertNotSame((Object)startingTree, (Object)desiredTree, (String)"trees should be distinct objects");
            desiredTree.treeIterator().setFilter(node -> !MerkleTestUtils.isVirtual(node)).setDescendantFilter(node -> !MerkleTestUtils.isVirtual((MerkleNode)node)).forEachRemaining(node -> {
                Assertions.assertEquals((int)1, (int)node.getReservationCount(), (String)"each teacher node should have a reference count of exactly 1");
                if (node instanceof DummyCustomReconnectRoot) {
                    ((DummyCustomReconnectRoot)node).assertViewsAreClosed();
                }
            });
        }
        if (startingTree == generatedTree) {
            if (startingTree != null) {
                startingTree.forEachNode(node -> {
                    if (!MerkleTestUtils.isVirtual(node)) {
                        Assertions.assertEquals((int)1, (int)node.getReservationCount(), (String)"each node should have a single reference");
                    }
                });
            }
        } else {
            if (startingTree != null) {
                startingTree.forEachNode(node -> {
                    if (!MerkleTestUtils.isVirtual(node)) {
                        int referenceCount = node.getReservationCount();
                        Assertions.assertTrue((referenceCount == 1 || referenceCount == 2 ? 1 : 0) != 0, (String)("illegal reference count " + referenceCount));
                    }
                });
            }
            if (generatedTree != null) {
                generatedTree.forEachNode(node -> {
                    if (!MerkleTestUtils.isVirtual(node)) {
                        int referenceCount = node.getReservationCount();
                        if (node == generatedTree) {
                            Assertions.assertEquals((int)0, (int)referenceCount, (String)"root should have a reference count of 0");
                        } else {
                            Assertions.assertTrue((referenceCount == 1 || referenceCount == 2 ? 1 : 0) != 0, (String)("illegal reference count " + referenceCount));
                        }
                    }
                });
            }
        }
        if (startingTree != null) {
            Assertions.assertTrue((boolean)MerkleTestUtils.isTreeMutable(startingTree.cast()), (String)"tree should be mutable");
        }
        if (generatedTree instanceof DummyMerkleNode) {
            Assertions.assertTrue((boolean)MerkleTestUtils.isFullyInitialized((DummyMerkleNode)generatedTree.cast()), (String)"tree should be initialized");
            Assertions.assertTrue((boolean)MerkleTestUtils.isTreeMutable(generatedTree.cast()), (String)"tree should be mutable");
        }
    }

    public static <T extends MerkleNode> T hashAndTestSynchronization(MerkleNode startingTree, MerkleNode desiredTree, ReconnectConfig reconnectConfig) throws Exception {
        System.out.println("------------");
        System.out.println("starting: " + String.valueOf(startingTree));
        System.out.println("desired: " + String.valueOf(desiredTree));
        if (startingTree != null && startingTree.getHash() == null) {
            TestMerkleCryptoFactory.getInstance().digestTreeSync(startingTree);
        }
        if (desiredTree != null && desiredTree.getHash() == null) {
            TestMerkleCryptoFactory.getInstance().digestTreeSync(desiredTree);
        }
        return MerkleTestUtils.testSynchronization(startingTree, desiredTree, 0, reconnectConfig);
    }

    public static MerkleNode getNodeInTree(MerkleNode root, int ... steps) {
        MerkleNode next = root;
        for (int step : steps) {
            if (next == null || next.isLeaf()) {
                throw new IllegalStateException("No node exists at the given location");
            }
            next = next.asInternal().getChild(step);
        }
        return next;
    }

    private static Function<Throwable, Boolean> createSuppressedExceptionListener(Function<Throwable, Boolean> originalListener) {
        return t -> {
            Throwable cause;
            boolean handled = (Boolean)originalListener.apply((Throwable)t);
            if (handled) {
                return true;
            }
            Throwable throwable = cause = t.getCause() != null ? t.getCause() : t;
            if (cause instanceof IOException || cause instanceof UncheckedIOException || cause instanceof ExecutionException || cause instanceof MerkleSynchronizationException) {
                return true;
            }
            return false;
        };
    }
}

