/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state;

import com.hedera.hapi.node.base.SemanticVersion;
import com.swirlds.platform.metrics.StateMetrics;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public final class SwirldStateManagerUtils {
    private SwirldStateManagerUtils() {
    }

    public static MerkleNodeState fastCopy(@NonNull MerkleNodeState state, @NonNull StateMetrics stats, @NonNull SemanticVersion softwareVersion, @NonNull PlatformStateFacade platformStateFacade) {
        Objects.requireNonNull(softwareVersion);
        long copyStart = System.nanoTime();
        MerkleNodeState copy = state.copy();
        platformStateFacade.setCreationSoftwareVersionTo((State)copy, softwareVersion);
        copy.getRoot().reserve();
        long copyEnd = System.nanoTime();
        stats.stateCopyMicros((double)(copyEnd - copyStart) * 0.001);
        return copy;
    }
}

