/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.addressbook;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.platform.state.NodeId;
import com.swirlds.common.test.fixtures.WeightGenerator;
import com.swirlds.common.test.fixtures.WeightGenerators;
import com.swirlds.platform.crypto.KeyCertPurpose;
import com.swirlds.platform.crypto.KeysAndCertsGenerator;
import com.swirlds.platform.crypto.PublicStores;
import com.swirlds.platform.test.fixtures.addressbook.RandomRosterEntryBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.IntStream;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.roster.SerializableX509Certificate;

public class RandomRosterBuilder {
    private final Random random;
    private int size = 4;
    private WeightGenerator weightGenerator = WeightGenerators.GAUSSIAN;
    private long minimumWeight = 0L;
    private Long maximumWeight;
    private org.hiero.consensus.model.node.NodeId nextNodeId = org.hiero.consensus.model.node.NodeId.FIRST_NODE_ID;
    private boolean realKeys;
    private final Map<org.hiero.consensus.model.node.NodeId, KeysAndCerts> privateKeys = new HashMap<org.hiero.consensus.model.node.NodeId, KeysAndCerts>();

    @NonNull
    public static RandomRosterBuilder create(@NonNull Random random) {
        return new RandomRosterBuilder(random);
    }

    private RandomRosterBuilder(@NonNull Random random) {
        this.random = Objects.requireNonNull(random);
    }

    @NonNull
    public Roster build() {
        Roster.Builder builder = Roster.newBuilder();
        if (this.maximumWeight == null && this.size > 0) {
            this.maximumWeight = Long.MAX_VALUE / (long)this.size;
        }
        List<Long> weights = this.weightGenerator.getWeights(this.random.nextLong(), this.size).stream().map(this::applyWeightBounds).toList();
        builder.rosterEntries(IntStream.range(0, this.size).mapToObj(index -> {
            org.hiero.consensus.model.node.NodeId nodeId = this.getNextNodeId();
            RandomRosterEntryBuilder addressBuilder = RandomRosterEntryBuilder.create(this.random).withNodeId(nodeId.id()).withWeight((Long)weights.get(index));
            this.generateKeys(nodeId, addressBuilder);
            return addressBuilder.build();
        }).toList());
        return builder.build();
    }

    @NonNull
    public RandomRosterBuilder withSize(int size) {
        this.size = size;
        return this;
    }

    @NonNull
    public RandomRosterBuilder withWeightGenerator(@NonNull WeightGenerator weightGenerator) {
        this.weightGenerator = weightGenerator;
        return this;
    }

    @NonNull
    public RandomRosterBuilder withMinimumWeight(long minimumWeight) {
        this.minimumWeight = minimumWeight;
        return this;
    }

    @NonNull
    public RandomRosterBuilder withMaximumWeight(long maximumWeight) {
        this.maximumWeight = maximumWeight;
        return this;
    }

    @NonNull
    public RandomRosterBuilder withRealKeysEnabled(boolean realKeysEnabled) {
        this.realKeys = realKeysEnabled;
        return this;
    }

    @NonNull
    public KeysAndCerts getPrivateKeys(@NonNull NodeId nodeId) {
        return this.getPrivateKeys(org.hiero.consensus.model.node.NodeId.of((long)nodeId.id()));
    }

    @NonNull
    public KeysAndCerts getPrivateKeys(@NonNull org.hiero.consensus.model.node.NodeId nodeId) {
        if (!this.realKeys) {
            throw new IllegalStateException("Real keys are not being generated");
        }
        if (!this.privateKeys.containsKey(nodeId)) {
            throw new IllegalStateException("Unknown node ID " + String.valueOf(nodeId));
        }
        return this.privateKeys.get(nodeId);
    }

    @NonNull
    private org.hiero.consensus.model.node.NodeId getNextNodeId() {
        org.hiero.consensus.model.node.NodeId nextId = this.nextNodeId;
        int randomAdvance = this.random.nextInt(3);
        this.nextNodeId = this.nextNodeId.getOffset((long)randomAdvance + 1L);
        return nextId;
    }

    private long applyWeightBounds(long weight) {
        return Math.min(this.maximumWeight, Math.max(this.minimumWeight, weight));
    }

    private void generateKeys(@NonNull org.hiero.consensus.model.node.NodeId nodeId, @NonNull RandomRosterEntryBuilder addressBuilder) {
        if (this.realKeys) {
            try {
                PublicStores publicStores = new PublicStores();
                byte[] masterKey = new byte[64];
                this.random.nextBytes(masterKey);
                KeysAndCerts keysAndCerts = KeysAndCertsGenerator.generate((org.hiero.consensus.model.node.NodeId)nodeId, (byte[])new byte[0], (byte[])masterKey, (byte[])new byte[0], (PublicStores)publicStores);
                this.privateKeys.put(nodeId, keysAndCerts);
                SerializableX509Certificate sigCert = new SerializableX509Certificate(publicStores.getCertificate(KeyCertPurpose.SIGNING, nodeId));
                addressBuilder.withSigCert(sigCert);
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
        }
    }
}

