/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenKeyValidation;
import com.hedera.hapi.node.token.TokenUpdateTransactionBody;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class TokenUpdateTransactionBodyJsonCodec
implements JsonCodec<TokenUpdateTransactionBody> {
    @NonNull
    public TokenUpdateTransactionBody parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            TokenID temp_token = null;
            String temp_symbol = "";
            String temp_name = "";
            AccountID temp_treasury = null;
            Key temp_adminKey = null;
            Key temp_kycKey = null;
            Key temp_freezeKey = null;
            Key temp_wipeKey = null;
            Key temp_supplyKey = null;
            AccountID temp_autoRenewAccount = null;
            Duration temp_autoRenewPeriod = null;
            Timestamp temp_expiry = null;
            String temp_memo = null;
            Key temp_fee_schedule_key = null;
            Key temp_pause_key = null;
            Bytes temp_metadata = null;
            Key temp_metadata_key = null;
            TokenKeyValidation temp_key_verification_mode = TokenKeyValidation.fromProtobufOrdinal(0);
            block42: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "token": {
                        temp_token = (TokenID)TokenID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block42;
                    }
                    case "symbol": {
                        temp_symbol = JsonTools.unescape((String)kvPair.value().STRING().getText());
                        continue block42;
                    }
                    case "name": {
                        temp_name = JsonTools.unescape((String)kvPair.value().STRING().getText());
                        continue block42;
                    }
                    case "treasury": {
                        temp_treasury = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block42;
                    }
                    case "adminKey": {
                        temp_adminKey = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block42;
                    }
                    case "kycKey": {
                        temp_kycKey = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block42;
                    }
                    case "freezeKey": {
                        temp_freezeKey = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block42;
                    }
                    case "wipeKey": {
                        temp_wipeKey = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block42;
                    }
                    case "supplyKey": {
                        temp_supplyKey = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block42;
                    }
                    case "autoRenewAccount": {
                        temp_autoRenewAccount = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block42;
                    }
                    case "autoRenewPeriod": {
                        temp_autoRenewPeriod = (Duration)Duration.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block42;
                    }
                    case "expiry": {
                        temp_expiry = (Timestamp)Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block42;
                    }
                    case "memo": {
                        temp_memo = JsonTools.unescape((String)kvPair.value().STRING().getText());
                        continue block42;
                    }
                    case "feeScheduleKey": {
                        temp_fee_schedule_key = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block42;
                    }
                    case "pauseKey": {
                        temp_pause_key = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block42;
                    }
                    case "metadata": {
                        temp_metadata = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block42;
                    }
                    case "metadataKey": {
                        temp_metadata_key = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block42;
                    }
                    case "keyVerificationMode": {
                        temp_key_verification_mode = TokenKeyValidation.fromString(kvPair.value().STRING().getText());
                        continue block42;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new TokenUpdateTransactionBody(temp_token, temp_symbol, temp_name, temp_treasury, temp_adminKey, temp_kycKey, temp_freezeKey, temp_wipeKey, temp_supplyKey, temp_autoRenewAccount, temp_autoRenewPeriod, temp_expiry, temp_memo, temp_fee_schedule_key, temp_pause_key, temp_metadata, temp_metadata_key, temp_key_verification_mode);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull TokenUpdateTransactionBody data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.token() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"token", TokenID.JSON, (Object)data.token()));
        }
        if (data.symbol() != "") {
            fieldLines.add(JsonTools.field((String)"symbol", (String)data.symbol()));
        }
        if (data.name() != "") {
            fieldLines.add(JsonTools.field((String)"name", (String)data.name()));
        }
        if (data.treasury() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"treasury", AccountID.JSON, (Object)data.treasury()));
        }
        if (data.adminKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"adminKey", Key.JSON, (Object)data.adminKey()));
        }
        if (data.kycKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"kycKey", Key.JSON, (Object)data.kycKey()));
        }
        if (data.freezeKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"freezeKey", Key.JSON, (Object)data.freezeKey()));
        }
        if (data.wipeKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"wipeKey", Key.JSON, (Object)data.wipeKey()));
        }
        if (data.supplyKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"supplyKey", Key.JSON, (Object)data.supplyKey()));
        }
        if (data.autoRenewAccount() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"autoRenewAccount", AccountID.JSON, (Object)data.autoRenewAccount()));
        }
        if (data.autoRenewPeriod() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"autoRenewPeriod", Duration.JSON, (Object)data.autoRenewPeriod()));
        }
        if (data.expiry() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"expiry", Timestamp.JSON, (Object)data.expiry()));
        }
        if (data.memo() != null) {
            fieldLines.add(JsonTools.field((String)"memo", (String)data.memo()));
        }
        if (data.feeScheduleKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"feeScheduleKey", Key.JSON, (Object)data.feeScheduleKey()));
        }
        if (data.pauseKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"pauseKey", Key.JSON, (Object)data.pauseKey()));
        }
        if (data.metadata() != null) {
            fieldLines.add(JsonTools.field((String)"metadata", (Bytes)data.metadata()));
        }
        if (data.metadataKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"metadataKey", Key.JSON, (Object)data.metadataKey()));
        }
        if (data.keyVerificationMode() != TokenKeyValidation.fromProtobufOrdinal(0)) {
            fieldLines.add(JsonTools.field((String)"keyVerificationMode", (String)data.keyVerificationMode().protoName()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

